/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.sql;

import com.senzing.sql.ConnectionPool;
import com.senzing.sql.ConnectionProvider;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Objects;

public class PoolConnectionProvider
implements ConnectionProvider {
    private static final long ONE_MILLION = 1000000L;
    private ConnectionPool pool;
    private long maxWait = 0L;

    public PoolConnectionProvider(ConnectionPool pool) throws NullPointerException {
        this(pool, -1L);
    }

    public PoolConnectionProvider(ConnectionPool pool, long maxWait) {
        Objects.requireNonNull(pool, "The specified pool cannot be null");
        this.pool = pool;
        this.maxWait = maxWait;
    }

    @Override
    public Connection getConnection() throws SQLException {
        long startTime = System.nanoTime();
        Connection conn = this.pool.acquire(this.getMaximumWaitTime());
        long elapsedMillis = (System.nanoTime() - startTime) / 1000000L;
        if (conn == null) {
            throw new SQLException("The connection could not be obtained within the allotted time.  maximumWait=[ " + this.getMaximumWaitTime() + " ], elapsed=[ " + elapsedMillis + " ]");
        }
        return conn;
    }

    public long getMaximumWaitTime() {
        return this.maxWait;
    }
}

