/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.text;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class TextUtilities {
    private static final SecureRandom PRNG = new SecureRandom();
    public static final int MINIMUM_LINE_LENGTH = 30;
    private static final int MIN_CHAR = 33;
    private static final int MAX_CHAR = 126;
    private static final List<Character> PRINTABLE_CHARS;
    private static final List<Character> ALPHA_CHARS;
    private static final List<Character> ALPHANUMERIC_CHARS;

    private TextUtilities() {
    }

    public static String randomPrintableText(int count) {
        return TextUtilities.randomText(count, PRINTABLE_CHARS);
    }

    public static String randomAlphabeticText(int count) {
        return TextUtilities.randomText(count, ALPHA_CHARS);
    }

    public static String randomAlphanumericText(int count) {
        return TextUtilities.randomText(count, ALPHANUMERIC_CHARS);
    }

    private static String randomText(int count, List<Character> allowedChars) {
        StringBuilder sb = new StringBuilder();
        int max = allowedChars.size();
        for (int index = 0; index < count; ++index) {
            sb.append(allowedChars.get(PRNG.nextInt(max)));
        }
        return sb.toString();
    }

    public static String urlEncodeUtf8(String text) {
        try {
            return URLEncoder.encode(text, "UTF-8");
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new IllegalStateException("UTF-8 encoding was not supported");
        }
    }

    public static String urlDecodeUtf8(String encodedText) {
        try {
            return URLDecoder.decode(encodedText, "UTF-8");
        }
        catch (UnsupportedEncodingException cannotHappen) {
            throw new IllegalStateException("UTF-8 encoding was not supported");
        }
    }

    static {
        try {
            int capacity = 94;
            ArrayList<Character> printableChars = new ArrayList<Character>(capacity);
            ArrayList<Character> alphaChars = new ArrayList<Character>(capacity);
            ArrayList<Character> alphaNumChars = new ArrayList<Character>(capacity);
            for (int index = 33; index <= 126; ++index) {
                Character c = Character.valueOf((char)index);
                printableChars.add(c);
                if (Character.isAlphabetic(c.charValue())) {
                    alphaChars.add(c);
                    alphaNumChars.add(c);
                    continue;
                }
                if (!Character.isDigit(c.charValue())) continue;
                alphaNumChars.add(c);
            }
            PRINTABLE_CHARS = Collections.unmodifiableList(printableChars);
            ALPHA_CHARS = Collections.unmodifiableList(alphaChars);
            ALPHANUMERIC_CHARS = Collections.unmodifiableList(alphaNumChars);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }
}

