/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class CollectionUtilities {
    private CollectionUtilities() {
    }

    public static <T> List<T> recursivelyUnmodifiableList(List<T> list) {
        ListIterator<T> iter = list.listIterator();
        while (iter.hasNext()) {
            T elem = iter.next();
            if (elem instanceof Set) {
                iter.set(Collections.unmodifiableSet((Set)elem));
                continue;
            }
            if (elem instanceof List) {
                iter.set(CollectionUtilities.recursivelyUnmodifiableList((List)elem));
                continue;
            }
            if (!(elem instanceof Map)) continue;
            iter.set(CollectionUtilities.recursivelyUnmodifiableMap((Map)elem));
        }
        return Collections.unmodifiableList(list);
    }

    public static <K, V> Map<K, V> recursivelyUnmodifiableMap(Map<K, V> map) {
        for (Map.Entry<K, Object> entry : map.entrySet()) {
            V value = entry.getValue();
            if (value == null) continue;
            if (value instanceof Set) {
                entry.setValue(Collections.unmodifiableSet((Set)value));
                continue;
            }
            if (value instanceof List) {
                entry.setValue(CollectionUtilities.recursivelyUnmodifiableList((List)value));
                continue;
            }
            if (!(value instanceof Map)) continue;
            entry.setValue(CollectionUtilities.recursivelyUnmodifiableMap((Map)value));
        }
        return Collections.unmodifiableMap(map);
    }

    public static <T> List<T> list(T ... elements) {
        ArrayList<T> list = new ArrayList<T>(elements.length);
        for (T element : elements) {
            list.add(element);
        }
        return list;
    }

    public static <T> Set<T> set(T ... elements) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        for (T element : elements) {
            set.add(element);
        }
        return set;
    }
}

