/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonNumber;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonString;
import javax.json.JsonValue;
import javax.json.JsonWriter;
import javax.json.JsonWriterFactory;
import org.apache.commons.configuration2.INIConfiguration;
import org.apache.commons.configuration2.SubnodeConfiguration;

public class JsonUtilities {
    private static JsonWriterFactory PRETTY_WRITER_FACTORY = Json.createWriterFactory(Collections.singletonMap("javax.json.stream.JsonGenerator.prettyPrinting", true));

    private JsonUtilities() {
    }

    public static String getString(JsonObject obj, String key) {
        return JsonUtilities.getString(obj, key, null);
    }

    public static String getString(JsonObject obj, String key, String defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        JsonValue jsonValue = (JsonValue)obj.get((Object)key);
        return JsonUtilities.valueAsString(jsonValue, defaultValue);
    }

    public static String getString(JsonArray arr, int index) {
        return JsonUtilities.getString(arr, index, null);
    }

    public static String getString(JsonArray arr, int index, String defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        JsonValue jsonValue = (JsonValue)arr.get(index);
        return JsonUtilities.valueAsString(jsonValue, defaultValue);
    }

    private static String valueAsString(JsonValue jsonValue) {
        return JsonUtilities.valueAsString(jsonValue, null);
    }

    private static String valueAsString(JsonValue jsonValue, String defaultValue) {
        if (jsonValue == null) {
            return defaultValue;
        }
        switch (jsonValue.getValueType()) {
            case STRING: {
                return ((JsonString)jsonValue).getString();
            }
            case NULL: {
                return defaultValue;
            }
            case TRUE: {
                return Boolean.TRUE.toString();
            }
            case FALSE: {
                return Boolean.FALSE.toString();
            }
            case NUMBER: {
                return "" + ((JsonNumber)jsonValue).numberValue();
            }
        }
        return JsonUtilities.toJsonText(jsonValue, true);
    }

    public static JsonArray getJsonArray(JsonObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (!obj.containsKey((Object)key) || obj.isNull(key)) {
            return null;
        }
        return obj.getJsonArray(key);
    }

    public static JsonArray getJsonArray(JsonArray arr, int index) {
        if (arr == null) {
            return null;
        }
        if (arr.isNull(index)) {
            return null;
        }
        return arr.getJsonArray(index);
    }

    public static List<String> getStrings(JsonObject obj, String key) {
        return JsonUtilities.getStrings(obj, key, null);
    }

    public static List<String> getStrings(JsonObject obj, String key, List<String> defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key) || obj.isNull(key)) {
            return defaultValue;
        }
        return Collections.unmodifiableList(obj.getJsonArray(key).getValuesAs(JsonUtilities::valueAsString));
    }

    public static List<String> getStrings(JsonArray arr, int index) {
        return JsonUtilities.getStrings(arr, index, null);
    }

    public static List<String> getStrings(JsonArray arr, int index, List<String> defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return Collections.unmodifiableList(arr.getJsonArray(index).getValuesAs(JsonUtilities::valueAsString));
    }

    public static Integer getInteger(JsonObject obj, String key) {
        return JsonUtilities.getInteger(obj, key, null);
    }

    public static Integer getInteger(JsonObject obj, String key, Integer defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (obj.isNull(key)) {
            return defaultValue;
        }
        return obj.getJsonNumber(key).intValue();
    }

    public static Integer getInteger(JsonArray arr, int index) {
        return JsonUtilities.getInteger(arr, index, null);
    }

    public static Integer getInteger(JsonArray arr, int index, Integer defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return arr.getJsonNumber(index).intValue();
    }

    public static Long getLong(JsonObject obj, String key) {
        return JsonUtilities.getLong(obj, key, null);
    }

    public static Long getLong(JsonObject obj, String key, Long defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (obj.isNull(key)) {
            return defaultValue;
        }
        return obj.getJsonNumber(key).longValue();
    }

    public static Long getLong(JsonArray arr, int index) {
        return JsonUtilities.getLong(arr, index, null);
    }

    public static Long getLong(JsonArray arr, int index, Long defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return arr.getJsonNumber(index).longValue();
    }

    public static BigInteger getBigInteger(JsonObject obj, String key) {
        return JsonUtilities.getBigInteger(obj, key, null);
    }

    public static BigInteger getBigInteger(JsonObject obj, String key, BigInteger defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (obj.isNull(key)) {
            return defaultValue;
        }
        return obj.getJsonNumber(key).bigIntegerValue();
    }

    public static BigInteger getBigInteger(JsonArray arr, int index) {
        return JsonUtilities.getBigInteger(arr, index, null);
    }

    public static BigInteger getBigInteger(JsonArray arr, int index, BigInteger defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return arr.getJsonNumber(index).bigIntegerValue();
    }

    public static Float getFloat(JsonObject obj, String key) {
        return JsonUtilities.getFloat(obj, key, null);
    }

    public static Float getFloat(JsonObject obj, String key, Float defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (obj.isNull(key)) {
            return defaultValue;
        }
        return Float.valueOf(obj.getJsonNumber(key).numberValue().floatValue());
    }

    public static Float getFloat(JsonArray arr, int index) {
        return JsonUtilities.getFloat(arr, index, null);
    }

    public static Float getFloat(JsonArray arr, int index, Float defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return Float.valueOf(arr.getJsonNumber(index).numberValue().floatValue());
    }

    public static Double getDouble(JsonObject obj, String key) {
        return JsonUtilities.getDouble(obj, key, null);
    }

    public static Double getDouble(JsonObject obj, String key, Double defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (obj.isNull(key)) {
            return defaultValue;
        }
        return obj.getJsonNumber(key).doubleValue();
    }

    public static Double getDouble(JsonArray arr, int index) {
        return JsonUtilities.getDouble(arr, index, null);
    }

    public static Double getDouble(JsonArray arr, int index, Double defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return arr.getJsonNumber(index).doubleValue();
    }

    public static BigDecimal getBigDecimal(JsonObject obj, String key) {
        return JsonUtilities.getBigDecimal(obj, key, null);
    }

    public static BigDecimal getBigDecimal(JsonObject obj, String key, BigDecimal defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (obj.isNull(key)) {
            return defaultValue;
        }
        return obj.getJsonNumber(key).bigDecimalValue();
    }

    public static BigDecimal getBigDecimal(JsonArray arr, int index) {
        return JsonUtilities.getBigDecimal(arr, index, null);
    }

    public static BigDecimal getBigDecimal(JsonArray arr, int index, BigDecimal defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return arr.getJsonNumber(index).bigDecimalValue();
    }

    public static Boolean getBoolean(JsonObject obj, String key) {
        return JsonUtilities.getBoolean(obj, key, null);
    }

    public static Boolean getBoolean(JsonObject obj, String key, Boolean defaultValue) {
        if (obj == null) {
            return defaultValue;
        }
        if (!obj.containsKey((Object)key)) {
            return defaultValue;
        }
        if (obj.isNull(key)) {
            return defaultValue;
        }
        return obj.getBoolean(key);
    }

    public static Boolean getBoolean(JsonArray arr, int index) {
        return JsonUtilities.getBoolean(arr, index, null);
    }

    public static Boolean getBoolean(JsonArray arr, int index, Boolean defaultValue) {
        if (arr == null) {
            return defaultValue;
        }
        if (arr.isNull(index)) {
            return defaultValue;
        }
        return arr.getBoolean(index);
    }

    public static JsonValue getJsonValue(JsonObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (!obj.containsKey((Object)key)) {
            return null;
        }
        return obj.getValue("/" + key);
    }

    public static JsonObject getJsonObject(JsonObject obj, String key) {
        if (obj == null) {
            return null;
        }
        if (!obj.containsKey((Object)key)) {
            return null;
        }
        if (obj.isNull(key)) {
            return null;
        }
        return obj.getJsonObject(key);
    }

    public static JsonObject getJsonObject(JsonArray arr, int index) {
        if (arr == null) {
            return null;
        }
        if (arr.isNull(index)) {
            return null;
        }
        return arr.getJsonObject(index);
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, JsonObjectBuilder val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val);
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, JsonArrayBuilder val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val);
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, JsonValue val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val);
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, String val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val);
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, Integer val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val.intValue());
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, Long val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val.longValue());
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, Double val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val.doubleValue());
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, Float val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val.doubleValue());
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, BigInteger val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val);
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, BigDecimal val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val);
        }
        return job;
    }

    public static JsonObjectBuilder add(JsonObjectBuilder job, String key, Boolean val) {
        if (val == null) {
            job.addNull(key);
        } else {
            job.add(key, val.booleanValue());
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, JsonObjectBuilder val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val);
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, JsonArrayBuilder val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val);
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, JsonValue val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val);
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, String val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val);
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, Integer val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val.intValue());
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, Long val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val.longValue());
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, Double val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val.doubleValue());
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, Float val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val.doubleValue());
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder job, BigInteger val) {
        if (val == null) {
            job.addNull();
        } else {
            job.add(val);
        }
        return job;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder jab, BigDecimal val) {
        if (val == null) {
            jab.addNull();
        } else {
            jab.add(val);
        }
        return jab;
    }

    public static JsonArrayBuilder add(JsonArrayBuilder jab, Boolean val) {
        if (val == null) {
            jab.addNull();
        } else {
            jab.add(val.booleanValue());
        }
        return jab;
    }

    public static JsonValue parseValue(String jsonText) {
        if (jsonText == null) {
            return null;
        }
        StringReader sr = new StringReader(jsonText);
        JsonReader jsonReader = Json.createReader((Reader)sr);
        return jsonReader.readValue();
    }

    public static JsonObject parseJsonObject(String jsonText) {
        if (jsonText == null) {
            return null;
        }
        StringReader sr = new StringReader(jsonText);
        JsonReader jsonReader = Json.createReader((Reader)sr);
        return jsonReader.readObject();
    }

    public static JsonArray parseJsonArray(String jsonText) {
        if (jsonText == null) {
            return null;
        }
        StringReader sr = new StringReader(jsonText);
        JsonReader jsonReader = Json.createReader((Reader)sr);
        return jsonReader.readArray();
    }

    public static Object normalizeJsonText(String jsonText) {
        if (jsonText == null) {
            return null;
        }
        jsonText = jsonText.trim();
        JsonValue jsonValue = null;
        if (jsonText.indexOf("{") == 0 || jsonText.indexOf("[") == 0) {
            StringReader sr = new StringReader(jsonText);
            JsonReader jsonReader = Json.createReader((Reader)sr);
            jsonValue = jsonReader.read();
        } else if (jsonText.equals("true")) {
            jsonValue = JsonValue.TRUE;
        } else if (jsonText.equals("false")) {
            jsonValue = JsonValue.FALSE;
        } else if (jsonText.equals("null")) {
            jsonValue = JsonValue.NULL;
        } else {
            String harnessText = "{\"value\": " + jsonText + "}";
            StringReader sr = new StringReader(harnessText);
            JsonReader jsonReader = Json.createReader((Reader)sr);
            JsonObject jsonObject = jsonReader.readObject();
            jsonValue = jsonObject.getValue("/value");
        }
        return JsonUtilities.normalizeJsonValue(jsonValue);
    }

    public static Object normalizeJsonValue(JsonValue jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        switch (jsonValue.getValueType()) {
            case NULL: {
                return null;
            }
            case TRUE: {
                return Boolean.TRUE;
            }
            case FALSE: {
                return Boolean.FALSE;
            }
            case NUMBER: {
                JsonNumber jsonNumber = (JsonNumber)jsonValue;
                if (jsonNumber.isIntegral()) {
                    return jsonNumber.longValue();
                }
                return jsonNumber.doubleValue();
            }
            case STRING: {
                JsonString jsonString = (JsonString)jsonValue;
                return jsonString.getString();
            }
            case ARRAY: {
                JsonArray jsonArray = (JsonArray)jsonValue;
                int count = jsonArray.size();
                ArrayList<Object> result = new ArrayList<Object>(count);
                for (JsonValue jv : jsonArray) {
                    result.add(JsonUtilities.normalizeJsonValue(jv));
                }
                return result;
            }
            case OBJECT: {
                LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
                JsonObject jsonObject = (JsonObject)jsonValue;
                for (Map.Entry entry : jsonObject.entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = JsonUtilities.normalizeJsonValue((JsonValue)entry.getValue());
                    result.put(key, value);
                }
                return result;
            }
        }
        throw new IllegalStateException("Unrecognized JsonValue.ValueType: " + jsonValue.getValueType());
    }

    public static JsonObjectBuilder addProperty(JsonObjectBuilder builder, String property, Object value) {
        if (value == null) {
            builder.addNull(property);
        } else if (value instanceof String) {
            builder.add(property, (String)value);
        } else if (value instanceof Boolean) {
            builder.add(property, ((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            builder.add(property, ((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add(property, ((Long)value).longValue());
        } else if (value instanceof Short) {
            builder.add(property, (int)((Short)value).shortValue());
        } else if (value instanceof Float) {
            builder.add(property, (double)((Float)value).floatValue());
        } else if (value instanceof Double) {
            builder.add(property, ((Double)value).doubleValue());
        } else if (value instanceof BigInteger) {
            builder.add(property, (BigInteger)value);
        } else if (value instanceof BigDecimal) {
            builder.add(property, (BigDecimal)value);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            JsonArrayBuilder jab = Json.createArrayBuilder();
            for (int index = 0; index < length; ++index) {
                JsonUtilities.addElement(jab, Array.get(value, index));
            }
            builder.add(property, jab);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            JsonArrayBuilder jab = Json.createArrayBuilder();
            for (Object elem : collection) {
                JsonUtilities.addElement(jab, elem);
            }
            builder.add(property, jab);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            boolean stringKeys = true;
            for (Object key : map.keySet()) {
                if (key != null && key instanceof String) continue;
                stringKeys = false;
                break;
            }
            if (stringKeys) {
                JsonObjectBuilder job = Json.createObjectBuilder();
                map.forEach((subKey, subValue) -> JsonUtilities.addProperty(job, (String)subKey, subValue));
                builder.add(property, job);
            } else {
                builder.add(property, value.toString());
            }
        } else {
            builder.add(property, value.toString());
        }
        return builder;
    }

    public static JsonArrayBuilder addElement(JsonArrayBuilder builder, Object value) {
        if (value == null) {
            builder.addNull();
        } else if (value instanceof String) {
            builder.add((String)value);
        } else if (value instanceof Boolean) {
            builder.add(((Boolean)value).booleanValue());
        } else if (value instanceof Integer) {
            builder.add(((Integer)value).intValue());
        } else if (value instanceof Long) {
            builder.add(((Long)value).longValue());
        } else if (value instanceof Short) {
            builder.add((int)((Short)value).shortValue());
        } else if (value instanceof Float) {
            builder.add((double)((Float)value).floatValue());
        } else if (value instanceof Double) {
            builder.add(((Double)value).doubleValue());
        } else if (value instanceof BigInteger) {
            builder.add((BigInteger)value);
        } else if (value instanceof BigDecimal) {
            builder.add((BigDecimal)value);
        } else if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            JsonArrayBuilder jab = Json.createArrayBuilder();
            for (int index = 0; index < length; ++index) {
                JsonUtilities.addElement(jab, Array.get(value, index));
            }
            builder.add(jab);
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            JsonArrayBuilder jab = Json.createArrayBuilder();
            for (Object elem : collection) {
                JsonUtilities.addElement(jab, elem);
            }
            builder.add(jab);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            boolean stringKeys = true;
            for (Object key : map.keySet()) {
                if (key != null && key instanceof String) continue;
                stringKeys = false;
                break;
            }
            if (stringKeys) {
                JsonObjectBuilder job = Json.createObjectBuilder();
                map.forEach((subKey, subValue) -> JsonUtilities.addProperty(job, (String)subKey, subValue));
                builder.add(job);
            } else {
                builder.add(value.toString());
            }
        } else {
            builder.add(value.toString());
        }
        return builder;
    }

    public static JsonObject toJsonObject(String property, Object value) {
        return JsonUtilities.toJsonObject(property, value, null, null);
    }

    public static JsonObject toJsonObject(String property1, Object value1, String property2, Object value2) {
        return JsonUtilities.toJsonObject(property1, value1, property2, value2, null, null);
    }

    public static JsonObject toJsonObject(String property1, Object value1, String property2, Object value2, String property3, Object value3) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        if (property1 != null) {
            JsonUtilities.addProperty(builder, property1, value1);
        }
        if (property2 != null) {
            JsonUtilities.addProperty(builder, property2, value2);
        }
        if (property3 != null) {
            JsonUtilities.addProperty(builder, property3, value3);
        }
        return builder.build();
    }

    public static JsonArray toJsonArray(Object ... values) {
        JsonArrayBuilder builder = Json.createArrayBuilder();
        for (Object value : values) {
            JsonUtilities.addElement(builder, value);
        }
        return builder.build();
    }

    public static JsonObject toJsonObject(Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        return JsonUtilities.toJsonObjectBuilder(map).build();
    }

    public static JsonObjectBuilder toJsonObjectBuilder(Map<String, ?> map) {
        if (map == null) {
            return null;
        }
        JsonObjectBuilder builder = Json.createObjectBuilder();
        map.forEach((key, value) -> JsonUtilities.addProperty(builder, key, value));
        return builder;
    }

    public static JsonArray toJsonArray(List<?> list) {
        return JsonUtilities.toJsonArray(list);
    }

    public static JsonArray toJsonArray(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        return JsonUtilities.toJsonArrayBuilder(collection).build();
    }

    public static JsonArrayBuilder toJsonArrayBuilder(List<?> list) {
        return JsonUtilities.toJsonArrayBuilder(list);
    }

    public static JsonArrayBuilder toJsonArrayBuilder(Collection<?> collection) {
        if (collection == null) {
            return null;
        }
        JsonArrayBuilder builder = Json.createArrayBuilder();
        collection.forEach(value -> JsonUtilities.addElement(builder, value));
        return builder;
    }

    public static <T extends Writer> T toJsonText(T writer, JsonValue jsonValue) {
        return JsonUtilities.toJsonText(writer, jsonValue, false);
    }

    public static String toJsonText(JsonValue jsonValue) {
        return JsonUtilities.toJsonText(jsonValue, false);
    }

    public static <T extends Writer> T toJsonText(T writer, JsonObjectBuilder builder) {
        return JsonUtilities.toJsonText(writer, builder, false);
    }

    public static String toJsonText(JsonObjectBuilder builder) {
        return JsonUtilities.toJsonText(new StringWriter(), builder, false).toString();
    }

    public static <T extends Writer> T toJsonText(T writer, JsonArrayBuilder builder) {
        return JsonUtilities.toJsonText(writer, builder, false);
    }

    public static String toJsonText(JsonArrayBuilder builder) {
        return JsonUtilities.toJsonText(new StringWriter(), builder, false).toString();
    }

    public static <T extends Writer> T toJsonText(T writer, JsonValue jsonValue, boolean prettyPrint) {
        JsonWriter jsonWriter;
        Objects.requireNonNull(writer, "Writer cannot be null");
        JsonWriter jsonWriter2 = jsonWriter = prettyPrint ? PRETTY_WRITER_FACTORY.createWriter(writer) : Json.createWriter(writer);
        if (jsonValue != null) {
            jsonWriter.write(jsonValue);
        } else {
            jsonWriter.write(JsonValue.NULL);
        }
        return writer;
    }

    public static String toJsonText(JsonValue jsonValue, boolean prettyPrint) {
        return JsonUtilities.toJsonText(new StringWriter(), jsonValue, prettyPrint).toString();
    }

    public static <T extends Writer> T toJsonText(T writer, JsonObjectBuilder builder, boolean prettyPrint) {
        Objects.requireNonNull(writer, "Writer cannot be null");
        JsonWriter jsonWriter = prettyPrint ? PRETTY_WRITER_FACTORY.createWriter(writer) : Json.createWriter(writer);
        JsonObject jsonObject = builder.build();
        jsonWriter.writeObject(jsonObject);
        return writer;
    }

    public static String toJsonText(JsonObjectBuilder builder, boolean prettyPrint) {
        return JsonUtilities.toJsonText(new StringWriter(), builder, prettyPrint).toString();
    }

    public static <T extends Writer> T toJsonText(T writer, JsonArrayBuilder builder, boolean prettyPrint) {
        Objects.requireNonNull(writer, "Writer cannot be null");
        JsonWriter jsonWriter = prettyPrint ? PRETTY_WRITER_FACTORY.createWriter(writer) : Json.createWriter(writer);
        JsonArray jsonArray = builder.build();
        jsonWriter.writeArray(jsonArray);
        return writer;
    }

    public static String toJsonText(JsonArrayBuilder builder, boolean prettyPrint) {
        return JsonUtilities.toJsonText(new StringWriter(), builder, prettyPrint).toString();
    }

    public static JsonObject iniToJson(File iniFile) {
        try {
            INIConfiguration ini = new INIConfiguration();
            try (FileReader fileReader = new FileReader(iniFile);){
                ini.read((Reader)fileReader);
            }
            JsonObjectBuilder job = Json.createObjectBuilder();
            for (String sectionKey : ini.getSections()) {
                SubnodeConfiguration section = ini.getSection(sectionKey);
                JsonObjectBuilder sectionBuilder = Json.createObjectBuilder();
                Iterator iter = section.getKeys();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    String value = section.getProperty(key).toString();
                    JsonUtilities.add(sectionBuilder, key, value);
                }
                job.add(sectionKey, sectionBuilder);
            }
            return job.build();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

