/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;

public class SemanticVersion
implements Comparable<SemanticVersion> {
    private List<Integer> versionParts;
    private String versionString;
    private String normalizedString;

    public SemanticVersion(String versionString) throws NullPointerException, IllegalArgumentException {
        Objects.requireNonNull(versionString, "Version string cannot be null");
        try {
            Integer part;
            String[] tokens = versionString.split("\\.");
            this.versionParts = new ArrayList<Integer>(tokens.length);
            for (String token : tokens) {
                int part2 = Integer.parseInt(token);
                if (part2 < 0) {
                    throw new IllegalArgumentException("Negative version part is not allowed: " + part2);
                }
                this.versionParts.add(part2);
            }
            LinkedList<Integer> normalized = new LinkedList<Integer>(this.versionParts);
            Collections.reverse(normalized);
            Iterator iter = normalized.iterator();
            while (iter.hasNext() && (part = (Integer)iter.next()).equals(0)) {
                iter.remove();
            }
            Collections.reverse(normalized);
            StringBuilder versionSB = new StringBuilder();
            String prefix = "";
            for (Integer part3 : this.versionParts) {
                versionSB.append(prefix).append(part3);
                prefix = ".";
            }
            this.versionString = versionSB.toString();
            StringBuilder normalizedSB = new StringBuilder();
            prefix = "";
            for (Integer part4 : normalized) {
                normalizedSB.append(prefix).append(part4);
                prefix = ".";
            }
            this.normalizedString = normalizedSB.toString();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid semantic version string: " + versionString);
        }
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        SemanticVersion version = (SemanticVersion)object;
        return this.compareTo(version) == 0;
    }

    public int hashCode() {
        return this.normalizedString.hashCode();
    }

    @Override
    public int compareTo(SemanticVersion other) {
        Objects.requireNonNull(other, "The specified parameter cannot be null");
        Iterator<Integer> iter1 = this.versionParts.iterator();
        Iterator<Integer> iter2 = other.versionParts.iterator();
        while (iter1.hasNext() || iter2.hasNext()) {
            Integer part1 = iter1.hasNext() ? iter1.next() : 0;
            Integer part2 = iter2.hasNext() ? iter2.next() : 0;
            int diff = part1 - part2;
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean normalized) {
        return normalized ? this.normalizedString : this.versionString;
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("USAGE: java " + SemanticVersion.class.getName() + " <version> [compare-version]*");
            System.exit(1);
        }
        SemanticVersion version = new SemanticVersion(args[0]);
        System.out.println("VERSION: " + version + " (" + version.toString(true) + ")");
        for (int index = 1; index < args.length; ++index) {
            SemanticVersion version2 = new SemanticVersion(args[index]);
            System.out.println();
            System.out.println("VERSUS " + version2 + " (" + version2.toString(true) + "): COMPARE (" + version.compareTo(version2) + ")  / EQUALS (" + version.equals(version2) + ")  / HASH (" + version2.hashCode() + ")  / HASH-EQUALITY (" + (version.hashCode() == version2.hashCode()) + ")");
        }
    }
}

