/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;

public class Timers {
    private Map<String, TimerInfo> timerInfos = new LinkedHashMap<String, TimerInfo>();

    private static long now() {
        return System.nanoTime();
    }

    public Timers(String ... initialTimers) throws NullPointerException, IllegalArgumentException {
        long startTime = Timers.now();
        if (initialTimers != null) {
            for (String initialTimer : initialTimers) {
                if (initialTimer == null) {
                    throw new NullPointerException("Timer cannot have a null name: " + Arrays.asList(initialTimers));
                }
                if (this.timerInfos.containsKey(initialTimer)) {
                    throw new IllegalArgumentException("At least one timer (" + initialTimer + ") is duplicated: " + Arrays.asList(initialTimers));
                }
                this.timerInfos.put(initialTimer, new TimerInfo(startTime));
            }
        }
    }

    public boolean hasTimer(String timerName) {
        return this.timerInfos.containsKey(timerName);
    }

    public boolean isPaused(String timerName) {
        TimerInfo info = this.timerInfos.get(timerName);
        return info != null && info.isPaused();
    }

    public boolean isRunning(String timerName) {
        TimerInfo info = this.timerInfos.get(timerName);
        return info != null && info.isRunning();
    }

    public long getElapsedTime(String timerName) {
        TimerInfo info = this.timerInfos.get(timerName);
        return info != null ? info.getDuration() : -1L;
    }

    public int start(String timerName, String ... moreTimerNames) {
        int count = 0;
        long now = Timers.now();
        TimerInfo info = this.timerInfos.get(timerName);
        if (info == null) {
            this.timerInfos.put(timerName, new TimerInfo(now));
            ++count;
        } else if (info.resume()) {
            ++count;
        }
        if (moreTimerNames != null) {
            for (String addlTimerName : moreTimerNames) {
                info = this.timerInfos.get(addlTimerName);
                if (info == null) {
                    this.timerInfos.put(addlTimerName, new TimerInfo(now));
                    ++count;
                    continue;
                }
                if (!info.resume()) continue;
                ++count;
            }
        }
        return count;
    }

    public int pause(String timerName, String ... moreTimerNames) {
        int count = 0;
        long now = Timers.now();
        TimerInfo info = this.timerInfos.get(timerName);
        if (info != null && info.pause(now)) {
            ++count;
        }
        if (moreTimerNames != null) {
            for (String addlTimerName : moreTimerNames) {
                info = this.timerInfos.get(addlTimerName);
                if (info == null || !info.pause(now)) continue;
                ++count;
            }
        }
        return count;
    }

    public int resume(String timerName, String ... moreTimerNames) {
        int count = 0;
        long now = Timers.now();
        TimerInfo info = this.timerInfos.get(timerName);
        if (info != null && info.resume(now)) {
            ++count;
        }
        if (moreTimerNames != null) {
            for (String addlTimerName : moreTimerNames) {
                info = this.timerInfos.get(addlTimerName);
                if (info == null || !info.resume(now)) continue;
                ++count;
            }
        }
        return count;
    }

    public int pauseAll() {
        int count = 0;
        for (TimerInfo info : this.timerInfos.values()) {
            if (!info.pause()) continue;
            ++count;
        }
        return count;
    }

    public int resumeAll() {
        int count = 0;
        for (TimerInfo info : this.timerInfos.values()) {
            if (!info.resume()) continue;
            ++count;
        }
        return count;
    }

    public Map<String, Long> getTimings() {
        LinkedHashMap<String, Long> result = new LinkedHashMap<String, Long>();
        long now = Timers.now();
        this.timerInfos.entrySet().forEach(e -> result.put((String)e.getKey(), ((TimerInfo)e.getValue()).getDuration(now)));
        return result;
    }

    public void mergeWith(Timers timers) {
        if (timers == null) {
            return;
        }
        long now = Timers.now();
        timers.timerInfos.entrySet().forEach(e -> {
            String key = (String)e.getKey();
            TimerInfo info1 = this.timerInfos.get(key);
            TimerInfo info2 = (TimerInfo)e.getValue();
            if (info1 == null) {
                info1 = new TimerInfo(info2, now);
                this.timerInfos.put(key, info1);
            } else {
                info1.mergeWith(info2, now);
            }
        });
    }

    private static class TimerInfo {
        private Long start = null;
        private long accumulated = 0L;

        private TimerInfo(long startTime) {
            this.start = startTime;
        }

        private TimerInfo() {
            this(Timers.now());
        }

        private TimerInfo(TimerInfo other) {
            this(other, Timers.now());
        }

        private TimerInfo(TimerInfo other, long atTime) {
            this.start = null;
            this.accumulated = other.getDuration(atTime);
        }

        private long getDuration() {
            return this.getDuration(Timers.now());
        }

        private long getDuration(long atTime) {
            if (this.start == null) {
                return this.accumulated;
            }
            return this.accumulated + (atTime - this.start) / 1000000L;
        }

        private boolean isRunning() {
            return this.start != null;
        }

        private boolean isPaused() {
            return this.start == null;
        }

        private boolean pause() {
            return this.pause(Timers.now());
        }

        private boolean pause(long atTime) {
            if (this.start == null) {
                return false;
            }
            long duration = (atTime - this.start) / 1000000L;
            this.accumulated += duration;
            this.start = null;
            return true;
        }

        private boolean resume() {
            return this.resume(Timers.now());
        }

        private boolean resume(long atTime) {
            if (this.start != null) {
                return false;
            }
            this.start = atTime;
            return true;
        }

        private void mergeWith(TimerInfo timerInfo) {
            this.accumulated += timerInfo.getDuration();
        }

        private void mergeWith(TimerInfo timerInfo, long now) {
            this.accumulated += timerInfo.getDuration(now);
        }
    }
}

