/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import com.senzing.util.AccessToken;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class WorkerThreadPool {
    public static final String DEFAULT_BASE_NAME = "WorkerThread";
    private List<WorkerThread> available;
    private List<WorkerThread> allThreads;
    private boolean closed;
    private AccessToken pauseToken;

    public WorkerThreadPool(int size) {
        this(DEFAULT_BASE_NAME, size);
    }

    public WorkerThreadPool(String baseName, int size) {
        if (size < 1) {
            throw new IllegalArgumentException("The thread-pool size must be a positive number.  size=[ " + size + " ]");
        }
        this.available = new LinkedList<WorkerThread>();
        this.allThreads = new LinkedList<WorkerThread>();
        this.closed = false;
        if (baseName.endsWith("-")) {
            baseName = baseName.substring(0, baseName.length() - 1);
        }
        int identityHashCode = System.identityHashCode(this);
        for (int index = 0; index < size; ++index) {
            WorkerThread wt = new WorkerThread();
            wt.setName(baseName + "-" + identityHashCode + "-" + index);
            this.available.add(wt);
            this.allThreads.add(wt);
            wt.start();
        }
        this.allThreads = Collections.unmodifiableList(this.allThreads);
    }

    public int size() {
        return this.allThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        List<WorkerThread> list = this.available;
        synchronized (list) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(boolean join) {
        Iterator<WorkerThread> iterator = this.available;
        synchronized (iterator) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.available.notifyAll();
        }
        for (WorkerThread thread : this.allThreads) {
            thread.markComplete();
        }
        if (join) {
            for (WorkerThread thread : this.allThreads) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T, E extends Exception> T execute(Task<T, E> task) throws E {
        WorkerThread thread = null;
        List<WorkerThread> list = this.available;
        synchronized (list) {
            if (this.isClosed()) {
                throw new IllegalStateException("This WorkerThreadPool has already been marked as closed and the threads have been shutdown.");
            }
            while (this.available.size() == 0 || this.pauseToken != null) {
                try {
                    this.available.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            thread = this.available.remove(0);
        }
        try {
            list = thread.execute(task);
            return (T)list;
        }
        finally {
            if (thread != null) {
                List<WorkerThread> list2 = this.available;
                synchronized (list2) {
                    if (!this.closed) {
                        this.available.add(thread);
                        this.available.notifyAll();
                        thread = null;
                    }
                }
                if (thread != null) {
                    thread.markComplete();
                }
            }
        }
    }

    public boolean isPaused() {
        return this.pauseToken != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessToken pause() {
        List<WorkerThread> list = this.available;
        synchronized (list) {
            if (this.isPaused()) {
                return null;
            }
            this.pauseToken = new AccessToken();
            while (this.available.size() < this.allThreads.size()) {
                try {
                    this.available.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            return this.pauseToken;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resume(AccessToken accessToken) {
        if (accessToken == null) {
            return false;
        }
        List<WorkerThread> list = this.available;
        synchronized (list) {
            if (accessToken != null && this.pauseToken == null) {
                throw new IllegalStateException("This WorkerThreadPool is NOT currently in a paused state.  Cannot resume.");
            }
            if (accessToken != null && this.pauseToken != accessToken) {
                throw new IllegalArgumentException("The specifeid access token is not valid for unpausing this WorkerThreadPool instance.");
            }
            this.pauseToken = null;
            this.available.notifyAll();
            return true;
        }
    }

    public static void main(String[] args) {
        WorkerThreadPool pool = new WorkerThreadPool(4);
        for (int index = 0; index < args.length; ++index) {
            String arg = args[index];
            try {
                String result = pool.execute(() -> {
                    String threadName = Thread.currentThread().getName();
                    String message = threadName + ": " + arg;
                    if (arg.startsWith("ERROR")) {
                        throw new RuntimeException(message);
                    }
                    return message;
                });
                System.out.println((Object)result);
                continue;
            }
            catch (Exception failure) {
                failure.printStackTrace();
            }
        }
        System.out.println();
        System.out.println("JOINING AGAINST THE POOL....");
        pool.close(true);
        System.out.println("JOINED AGAINST THE POOL.");
    }

    private class WorkerThread
    extends Thread {
        private boolean complete = false;
        private Task task = null;
        private Object result = null;
        private Exception failure = null;
        private boolean busy = false;

        private WorkerThread() {
        }

        private void reset() {
            this.task = null;
            this.result = null;
            this.failure = null;
            this.busy = false;
        }

        private synchronized boolean isComplete() {
            return this.complete;
        }

        private synchronized void markComplete() {
            this.complete = true;
            this.notifyAll();
        }

        private synchronized boolean isBusy() {
            return this.busy;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized <T, E extends Exception> T execute(Task<T, E> task) throws E {
            try {
                if (this.isBusy()) {
                    throw new IllegalStateException("Already busy with another task.");
                }
                this.busy = true;
                this.task = task;
                this.notifyAll();
                while (this.task != null) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.failure != null) {
                    Exception e = this.failure;
                    this.reset();
                    throw e;
                }
                Object result = this.result;
                this.reset();
                Object object = result;
                return (T)object;
            }
            finally {
                this.reset();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            WorkerThread workerThread = this;
            synchronized (workerThread) {
                while (!this.isComplete()) {
                    while (this.task == null && !this.isComplete()) {
                        try {
                            this.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    if (this.task == null) continue;
                    try {
                        this.result = this.task.execute();
                    }
                    catch (Exception e) {
                        this.failure = e;
                    }
                    this.task = null;
                    this.notifyAll();
                }
            }
        }
    }

    public static interface Task<T, E extends Exception> {
        public T execute() throws E;
    }
}

