/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import com.senzing.io.IOUtilities;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Base64;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;

public class ZipUtilities {
    public static byte[] zip(byte[] uncompressedData) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (DeflaterOutputStream dos = new DeflaterOutputStream(baos);){
                dos.write(uncompressedData, 0, uncompressedData.length);
                dos.finish();
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when using Byte-Array streams", e);
        }
    }

    public static byte[] unzip(byte[] compressedData) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayInputStream bais = new ByteArrayInputStream(compressedData);
            byte[] buffer = new byte[8192];
            try (InflaterInputStream iis = new InflaterInputStream(bais);){
                int readCount = iis.read(buffer);
                while (readCount >= 0) {
                    baos.write(buffer, 0, readCount);
                    readCount = iis.read(buffer);
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when using Byte-Array streams", e);
        }
    }

    public static String zip64(byte[] uncompressedData) {
        try {
            byte[] data = ZipUtilities.zip(uncompressedData);
            return new String(Base64.getEncoder().encode(data), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not recognized", e);
        }
    }

    public static byte[] unzip64(String compressedBase64Data) {
        byte[] compressedData = Base64.getDecoder().decode(compressedBase64Data);
        return ZipUtilities.unzip(compressedData);
    }

    public static String zipText64(String uncompressedText) {
        try {
            return ZipUtilities.zip64(uncompressedText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not recognized", e);
        }
    }

    public static String unzipText64(String compressedBase64Data) {
        try {
            byte[] data = ZipUtilities.unzip64(compressedBase64Data);
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not recognized", e);
        }
    }

    public static byte[] gzip(byte[] uncompressedData) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try (GZIPOutputStream gzos = new GZIPOutputStream(baos);){
                gzos.write(uncompressedData, 0, uncompressedData.length);
                gzos.finish();
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when using Byte-Array streams", e);
        }
    }

    public static byte[] gunzip(byte[] compressedData) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ByteArrayInputStream bais = new ByteArrayInputStream(compressedData);
            byte[] buffer = new byte[8192];
            try (GZIPInputStream gzis = new GZIPInputStream(bais);){
                int readCount = gzis.read(buffer);
                while (readCount >= 0) {
                    baos.write(buffer, 0, readCount);
                    readCount = gzis.read(buffer);
                }
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new IllegalStateException("IOException when using Byte-Array streams", e);
        }
    }

    public static String gzip64(byte[] uncompressedData) {
        try {
            byte[] data = ZipUtilities.gzip(uncompressedData);
            return new String(Base64.getEncoder().encode(data), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not recognized", e);
        }
    }

    public static byte[] gunzip64(String compressedBase64Data) {
        byte[] compressedData = Base64.getDecoder().decode(compressedBase64Data);
        return ZipUtilities.gunzip(compressedData);
    }

    public static String gzipText64(String uncompressedText) {
        try {
            return ZipUtilities.gzip64(uncompressedText.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not recognized", e);
        }
    }

    public static String gunzipText64(String compressedBase64Data) {
        try {
            byte[] data = ZipUtilities.gunzip64(compressedBase64Data);
            return new String(data, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("UTF-8 encoding not recognized", e);
        }
    }

    public static void zip(File directoryOrFile, File targetZipFile) throws IOException {
        try (FileOutputStream fos = new FileOutputStream(targetZipFile);
             BufferedOutputStream bos = new BufferedOutputStream(fos);
             ZipOutputStream zos = new ZipOutputStream((OutputStream)bos, IOUtilities.UTF_8_CHARSET);){
            ZipUtilities.zip(directoryOrFile, zos);
            zos.finish();
        }
    }

    public static void zip(File directoryOrFile, ZipOutputStream targetZipStream) throws IOException {
        String basePath = directoryOrFile.getParentFile().getPath();
        ZipUtilities.doZip(basePath, directoryOrFile, targetZipStream);
    }

    private static void doZip(String basePath, File directoryOrFile, ZipOutputStream targetZip) throws IOException {
        String name = directoryOrFile.getPath().substring(basePath.length());
        if (name.startsWith(File.separator)) {
            name = name.substring(1);
        }
        if (File.separatorChar != '/') {
            name.replace(File.separatorChar, '/');
        }
        if (directoryOrFile.isDirectory()) {
            File[] children;
            Object dirName = name;
            if (!((String)dirName).endsWith("/")) {
                dirName = (String)dirName + "/";
            }
            ZipEntry zipEntry = new ZipEntry((String)dirName);
            targetZip.putNextEntry(zipEntry);
            targetZip.closeEntry();
            for (File child : children = directoryOrFile.listFiles()) {
                ZipUtilities.doZip(basePath, child, targetZip);
            }
        } else {
            ZipEntry zipEntry = new ZipEntry(name);
            targetZip.putNextEntry(zipEntry);
            try (FileInputStream fis = new FileInputStream(directoryOrFile);){
                byte[] bytes = new byte[8192];
                int count = fis.read(bytes);
                while (count >= 0) {
                    targetZip.write(bytes, 0, count);
                    count = fis.read(bytes);
                }
            }
            targetZip.closeEntry();
        }
    }

    public static void unzip(File zipFile, File targetDirectory) throws IOException {
        try (FileInputStream fis = new FileInputStream(zipFile);
             ZipInputStream zis = new ZipInputStream((InputStream)fis, IOUtilities.UTF_8_CHARSET);){
            ZipUtilities.unzip(zis, targetDirectory);
        }
    }

    public static void unzip(ZipInputStream zipStream, File targetDirectory) throws IOException {
        byte[] buffer = new byte[8192];
        ZipEntry zipEntry = zipStream.getNextEntry();
        while (zipEntry != null) {
            boolean directory;
            String name = zipEntry.getName();
            long size = zipEntry.getSize();
            boolean bl = directory = size <= 0L && name.endsWith("/");
            if (File.separatorChar != '/') {
                name = name.replace('/', File.separatorChar);
            }
            File targetFile = new File(targetDirectory, name);
            if (directory) {
                targetFile.mkdirs();
            } else {
                try (FileOutputStream fos = new FileOutputStream(targetFile);){
                    int count = zipStream.read(buffer);
                    while (count >= 0) {
                        fos.write(buffer, 0, count);
                        count = zipStream.read(buffer);
                    }
                }
            }
            zipEntry = zipStream.getNextEntry();
        }
    }

    public static void main(String[] args) {
        try {
            File source = null;
            File target = null;
            if (args.length == 2) {
                source = new File(args[0]);
                target = new File(args[1]);
                if (!source.exists()) {
                    source = null;
                }
            }
            if (source == null || target == null) {
                for (int index = 0; index < args.length; ++index) {
                    String arg = args[index];
                    String compressed = ZipUtilities.zipText64(arg);
                    String uncompressed = ZipUtilities.unzipText64(compressed);
                    System.out.println();
                    System.out.println(index + " (zip): From " + arg.length() + " to " + compressed.length() + " --> " + arg.equals(uncompressed));
                    compressed = ZipUtilities.gzipText64(arg);
                    uncompressed = ZipUtilities.gunzipText64(compressed);
                    System.out.println(index + " (gzip): From " + arg.length() + " to " + compressed.length() + " --> " + arg.equals(uncompressed));
                }
            } else {
                boolean targetZip;
                boolean sourceZip = source.getName().toLowerCase().endsWith(".zip") && !source.isDirectory();
                boolean bl = targetZip = target.getName().toLowerCase().endsWith(".zip") && !target.isDirectory();
                if (target.exists() && target.isDirectory() && sourceZip) {
                    ZipUtilities.unzip(source, target);
                } else if (targetZip) {
                    ZipUtilities.zip(source, target);
                } else {
                    System.err.println("At least one argument must be a ZIP file");
                    System.exit(1);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
    }
}

