/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.cmdline;

import com.senzing.cmdline.CommandLineOption;
import com.senzing.cmdline.CommandLineSource;
import com.senzing.cmdline.SpecifiedOption;
import java.util.List;
import java.util.Objects;

public class CommandLineValue
implements SpecifiedOption {
    private CommandLineOption option;
    private CommandLineSource source;
    private String specifier;
    private Object processedValue;
    private List<String> parameters;

    public CommandLineValue(CommandLineSource source, CommandLineOption option, Object processedValue, List<String> parameters) {
        this(source, option, null, processedValue, parameters);
    }

    public CommandLineValue(CommandLineSource source, CommandLineOption option, String specifier, Object processedValue, List<String> parameters) {
        this.option = option;
        this.source = source;
        this.specifier = specifier;
        this.processedValue = processedValue;
        this.parameters = List.copyOf(parameters);
    }

    @Override
    public CommandLineOption getOption() {
        return this.option;
    }

    @Override
    public CommandLineSource getSource() {
        return this.source;
    }

    public void setSource(CommandLineSource source) {
        this.source = source;
    }

    @Override
    public String getSpecifier() {
        return this.specifier;
    }

    public void setSpecifier(String specifier) {
        this.specifier = specifier;
    }

    public Object getProcessedValue() {
        return this.processedValue;
    }

    public void setProcessedValue(Object processedValue) {
        this.processedValue = processedValue;
    }

    public List<String> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<String> parameters) {
        this.parameters = parameters;
    }

    public String toString() {
        return "{ option=[ " + String.valueOf(this.getOption()) + " ], processedValue=[ " + String.valueOf(this.getProcessedValue()) + " ], source=[ " + String.valueOf((Object)this.getSource()) + " ], specifier=[ " + this.getSpecifier() + " ], parameters=[ " + String.valueOf(this.getParameters()) + " ] }";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandLineValue value = (CommandLineValue)o;
        return Objects.equals(this.getOption(), value.getOption()) && this.getSource() == value.getSource() && Objects.equals(this.getSpecifier(), value.getSpecifier()) && Objects.equals(this.getProcessedValue(), value.getProcessedValue()) && Objects.equals(this.getParameters(), value.getParameters());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getOption(), this.getSource(), this.getSpecifier(), this.getProcessedValue(), this.getParameters()});
    }
}

