/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.cmdline;

import com.senzing.cmdline.CommandLineOption;
import com.senzing.cmdline.CommandLineSource;
import com.senzing.cmdline.SpecifiedOption;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.Set;

public class DeprecatedOptionWarning
implements SpecifiedOption {
    private CommandLineSource source;
    private CommandLineOption option;
    private String specifier;

    public DeprecatedOptionWarning(CommandLineSource source, CommandLineOption option, String specifier) throws IllegalArgumentException {
        if (!option.isDeprecated()) {
            throw new IllegalArgumentException("The specified CommandLineOption is not deprecated: " + String.valueOf(option) + " (source=[ " + String.valueOf((Object)source) + " ], specifier=[ " + specifier + " ])");
        }
        this.source = source;
        this.specifier = specifier;
        this.option = option;
    }

    public DeprecatedOptionWarning(SpecifiedOption specifiedOption) {
        this(specifiedOption.getSource(), specifiedOption.getOption(), specifiedOption.getSpecifier());
    }

    @Override
    public CommandLineSource getSource() {
        return this.source;
    }

    @Override
    public CommandLineOption getOption() {
        return this.option;
    }

    @Override
    public String getSpecifier() {
        return this.specifier;
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("WARNING: The " + this.getSourceDescriptor() + " option is deprecated and will be removed in a future release.");
        Set alternatives = this.option.getDeprecationAlternatives();
        if (alternatives.size() == 1) {
            CommandLineOption alternative = (CommandLineOption)alternatives.iterator().next();
            pw.println();
            pw.println("Consider using " + alternative.getCommandLineFlag() + " instead.");
        } else if (alternatives.size() > 1) {
            pw.println();
            pw.println("Consider using one of the following instead:");
            for (CommandLineOption alternative : alternatives) {
                pw.println("     o " + alternative.getCommandLineFlag());
            }
        }
        pw.println();
        pw.flush();
        return sw.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeprecatedOptionWarning that = (DeprecatedOptionWarning)o;
        return this.getSource() == that.getSource() && Objects.equals(this.getOption(), that.getOption()) && Objects.equals(this.getSpecifier(), that.getSpecifier());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.getSource(), this.getOption(), this.getSpecifier()});
    }
}

