/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.cmdline;

import com.senzing.cmdline.CommandLineException;
import com.senzing.cmdline.CommandLineOption;
import java.util.Set;

public class RepeatedOptionException
extends CommandLineException {
    private CommandLineOption option;
    private Set<String> flags;

    public RepeatedOptionException(CommandLineOption option, Set<String> flags) {
        super(RepeatedOptionException.buildErrorMessage(option, flags));
        this.option = option;
        this.flags = flags == null ? Set.of() : Set.copyOf(flags);
    }

    public CommandLineOption getOption() {
        return this.option;
    }

    public Set<String> getFlags() {
        return this.flags;
    }

    public static String buildErrorMessage(CommandLineOption option, Set<String> flags) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder("Option specified more than once: ");
        String prefix = "";
        int count = 0;
        for (String repeatedFlag : flags) {
            sb.append(prefix).append(repeatedFlag);
            prefix = ++count == flags.size() ? " and " : ", ";
        }
        return sb.toString();
    }
}

