/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.io;

import java.io.ByteArrayInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ChunkedEncodingInputStream
extends FilterInputStream {
    private ByteArrayInputStream currentChunk = null;
    private boolean eof = false;

    public ChunkedEncodingInputStream(InputStream inputStream) {
        super(inputStream);
    }

    @Override
    public int available() throws IOException {
        if (this.currentChunk == null) {
            int available = this.in.available();
            if (available > 0) {
                this.readChunk();
            } else {
                return 0;
            }
        }
        return this.currentChunk == null ? 0 : this.currentChunk.available();
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    @Override
    public void mark(int readLimit) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Mark is not supported when decoding chunked transfer encoding");
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        if (this.currentChunk == null || this.currentChunk.available() == 0) {
            this.readChunk();
        }
        return this.currentChunk == null ? -1 : this.currentChunk.read();
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (this.currentChunk == null || this.currentChunk.available() == 0) {
            this.readChunk();
        }
        return this.currentChunk == null ? -1 : this.currentChunk.read(buffer, offset, length);
    }

    @Override
    public void reset() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Reset is not supported when decoding chunked transfer encoding");
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = 0L;
        while (!this.eof && skipped < n) {
            if (this.currentChunk == null || this.currentChunk.available() == 0) {
                this.readChunk();
            }
            if (this.currentChunk == null) continue;
            skipped += this.currentChunk.skip(n - skipped);
        }
        return skipped;
    }

    private boolean readChunk() throws IOException {
        this.currentChunk = null;
        StringBuilder sb = new StringBuilder();
        boolean cr = false;
        int readByte = this.in.read();
        while (readByte >= 0) {
            if (cr) {
                if (readByte == 10) break;
                throw new IOException("Bad chunked encoding.  Encountered CR without subsequent LF: " + sb.toString());
            }
            if (readByte == 10) {
                throw new IOException("Bad chunked encoding.  Encountered LF without preceding CR: " + sb.toString());
            }
            if (readByte == 13) {
                cr = true;
            } else {
                sb.append((char)readByte);
            }
            readByte = this.in.read();
        }
        if (!cr) {
            this.eof = true;
            throw new IOException("Bad chunked encoding.  Unexpected EOF (" + sb.length() + "): " + String.valueOf(sb));
        }
        String chunkLine = sb.toString();
        int index = chunkLine.indexOf(59);
        String chunkSize = index <= 0 ? chunkLine : chunkLine.substring(0, index);
        int readCount = Integer.parseInt(chunkSize, 16);
        if (readCount == 0) {
            this.eof = true;
        }
        byte[] chunkBytes = null;
        if (readCount > 0 && (chunkBytes = this.in.readNBytes(readCount)).length != readCount) {
            this.eof = true;
            throw new IOException("Bad chunked encoding.  Unexpected EOF while reading chunk of size " + readCount + " (only " + chunkBytes.length + " read): " + chunkLine);
        }
        int trailerByte = this.in.read();
        if (trailerByte < 0) {
            throw new IOException("Bad chunked encoding.  EOF prior to trailing CR following chunk: " + Integer.toString(readCount, 16).toUpperCase());
        }
        if (trailerByte != 13) {
            throw new IOException("Bad chunked encoding.  Expected trailing CR following chunk (" + Integer.toString(readCount, 16).toUpperCase() + "), but got code point: " + trailerByte);
        }
        trailerByte = this.in.read();
        if (trailerByte < 0) {
            throw new IOException("Bad chunked encoding.  EOF prior to trailing LF following chunk: " + Integer.toString(readCount, 16).toUpperCase());
        }
        if (trailerByte != 10) {
            throw new IOException("Bad chunked encoding.  Expected trailing LF following chunk (" + Integer.toString(readCount, 16).toUpperCase() + "), but got code point: " + trailerByte);
        }
        this.currentChunk = chunkBytes == null ? null : new ByteArrayInputStream(chunkBytes);
        return this.currentChunk != null;
    }
}

