/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.io;

import com.senzing.util.JsonUtilities;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import javax.json.stream.JsonParserFactory;
import javax.json.stream.JsonParsingException;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;

public class RecordReader {
    private Format format;
    private Reader reader;
    private Map<String, String> dataSourceMap;
    private String sourceId;
    private RecordProvider recordProvider;

    public RecordReader(Reader reader) throws IOException {
        this(null, reader, Collections.emptyMap(), null);
    }

    public RecordReader(Format format, Reader reader) throws IOException {
        this(format, reader, Collections.emptyMap(), null);
    }

    public RecordReader(Reader reader, String dataSource) throws IOException {
        this(null, reader, Collections.singletonMap("", dataSource), null);
    }

    public RecordReader(Format format, Reader reader, String dataSource) throws IOException {
        this(format, reader, Collections.singletonMap("", dataSource), null);
    }

    public RecordReader(Reader reader, String dataSource, String sourceId) throws IOException {
        this(null, reader, Collections.singletonMap("", dataSource), sourceId);
    }

    public RecordReader(Format format, Reader reader, String dataSource, String sourceId) throws IOException {
        this(format, reader, Collections.singletonMap("", dataSource), sourceId);
    }

    public RecordReader(Reader reader, Map<String, String> dataSourceMap) throws IOException {
        this(null, reader, dataSourceMap, null);
    }

    public RecordReader(Format format, Reader reader, Map<String, String> dataSourceMap) throws IOException {
        this(format, reader, dataSourceMap, null);
    }

    public RecordReader(Reader reader, Map<String, String> dataSourceMap, String sourceId) throws IOException {
        this(null, reader, dataSourceMap, sourceId);
    }

    public RecordReader(Format format, Reader reader, Map<String, String> dataSourceMap, String sourceId) throws IOException {
        block18: {
            block17: {
                this.format = null;
                this.format = format;
                if (this.format == null) {
                    int nextChar;
                    PushbackReader pushbackReader = new PushbackReader(reader);
                    this.reader = pushbackReader;
                    block11: while (this.format == null && (nextChar = pushbackReader.read()) >= 0) {
                        if (Character.isWhitespace((char)nextChar)) continue;
                        pushbackReader.unread(nextChar);
                        switch ((char)nextChar) {
                            case '[': {
                                this.format = Format.JSON;
                                continue block11;
                            }
                            case '{': {
                                this.format = Format.JSON_LINES;
                                continue block11;
                            }
                        }
                        this.format = Format.CSV;
                    }
                } else {
                    this.reader = reader;
                }
                if (this.format == null) break block17;
                switch (this.format.ordinal()) {
                    case 0: {
                        this.recordProvider = new JsonArrayRecordProvider(this.reader);
                        break block18;
                    }
                    case 1: {
                        this.recordProvider = new JsonLinesRecordProvider(this.reader);
                        break block18;
                    }
                    case 2: {
                        this.recordProvider = new CsvRecordProvider(this.reader);
                        break block18;
                    }
                    default: {
                        throw new IllegalStateException("Unrecognized RecordReader.Format; " + String.valueOf((Object)this.format));
                    }
                }
            }
            this.format = Format.JSON_LINES;
            this.recordProvider = new JsonLinesRecordProvider(this.reader);
        }
        this.dataSourceMap = dataSourceMap == null ? Collections.emptyMap() : new LinkedHashMap();
        try {
            if (dataSourceMap != null) {
                dataSourceMap.entrySet().forEach(entry -> {
                    String key = (String)entry.getKey();
                    if (key != null) {
                        key = key.trim().toUpperCase();
                    }
                    String value = ((String)entry.getValue()).trim().toUpperCase();
                    this.dataSourceMap.put(key, value);
                });
                this.dataSourceMap = Collections.unmodifiableMap(this.dataSourceMap);
            }
        }
        catch (NullPointerException e) {
            System.err.println("DATA SOURCE MAP: " + String.valueOf(dataSourceMap));
            throw e;
        }
        this.sourceId = sourceId;
        if (this.sourceId != null) {
            this.sourceId = this.sourceId.trim();
            if (this.sourceId.length() == 0) {
                this.sourceId = null;
            }
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public JsonObject readRecord() {
        return this.recordProvider.getNextRecord();
    }

    public Long getErrorLineNumber() {
        return this.recordProvider.getErrorLineNumber();
    }

    private JsonObject augmentRecord(JsonObject record) {
        if (record == null) {
            return null;
        }
        JsonObjectBuilder job = Json.createObjectBuilder((JsonObject)record);
        String dsrc = JsonUtilities.getString(record, "DATA_SOURCE", "");
        String dataSource = this.dataSourceMap.get(dsrc = dsrc.trim().toUpperCase());
        if (dataSource == null) {
            dataSource = this.dataSourceMap.get(null);
        }
        if (dataSource != null && dataSource.trim().length() == 0) {
            dataSource = null;
        }
        if (dataSource != null) {
            job.remove("DATA_SOURCE");
            job.add("DATA_SOURCE", dataSource);
            dsrc = dataSource;
        }
        if (this.sourceId != null) {
            job.remove("SOURCE_ID");
            job.add("SOURCE_ID", this.sourceId);
        }
        return job.build();
    }

    public static void main(String[] args) {
        try {
            for (String arg : args) {
                File file = new File(arg);
                try (FileInputStream fis = new FileInputStream(file);
                     InputStreamReader isr = new InputStreamReader(fis);){
                    RecordReader recordReader = new RecordReader(isr);
                    System.out.println();
                    System.out.println("----------------------------------------------");
                    System.out.println("FILE    : " + String.valueOf(file));
                    System.out.println("FORMAT  : " + String.valueOf((Object)recordReader.getFormat()));
                    System.out.println();
                    int index = 0;
                    JsonObject record = recordReader.readRecord();
                    while (record != null) {
                        System.out.println(++index + ": " + JsonUtilities.toJsonText((JsonValue)record));
                        System.out.println();
                        record = recordReader.readRecord();
                    }
                    System.out.println("COUNT   : " + index);
                    System.out.println("----------------------------------------------");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static enum Format {
        JSON("application/json", "JSON"),
        JSON_LINES("application/x-jsonlines", "JSON Lines"),
        CSV("text/csv", "CSV");

        private String mediaType;
        private String simpleName;
        private static Map<String, Format> MEDIA_TYPE_LOOKUP;

        private Format(String mediaType, String simpleName) {
            this.mediaType = mediaType;
            this.simpleName = simpleName;
        }

        public String getMediaType() {
            return this.mediaType;
        }

        public String getSimpleName() {
            return this.simpleName;
        }

        public static Format fromMediaType(String mediaType) {
            if (mediaType == null) {
                return null;
            }
            return MEDIA_TYPE_LOOKUP.get(mediaType.trim().toLowerCase());
        }

        static {
            try {
                LinkedHashMap<String, Format> map = new LinkedHashMap<String, Format>();
                for (Format format : Format.values()) {
                    map.put(format.getMediaType(), format);
                }
                MEDIA_TYPE_LOOKUP = Collections.unmodifiableMap(map);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new ExceptionInInitializerError(e);
            }
        }
    }

    private class JsonArrayRecordProvider
    implements RecordProvider {
        private Iterator<JsonObject> recordIter;
        private boolean errant = false;
        private Long errorLineNumber = null;

        public JsonArrayRecordProvider(Reader reader) {
            JsonParserFactory jpf = Json.createParserFactory(Collections.emptyMap());
            JsonParser jp = jpf.createParser(reader);
            jp.next();
            this.recordIter = jp.getArrayStream().map(jv -> (JsonObject)jv).iterator();
        }

        @Override
        public JsonObject getNextRecord() {
            RecordReader owner = RecordReader.this;
            JsonObject result = null;
            while (result == null) {
                try {
                    if (!this.recordIter.hasNext()) break;
                    result = owner.augmentRecord(this.recordIter.next());
                    this.errant = false;
                }
                catch (Exception e) {
                    if (this.errant) continue;
                    if (e instanceof JsonParsingException) {
                        JsonParsingException jpe = (JsonParsingException)e;
                        System.out.println("LOCATION: " + String.valueOf(jpe.getLocation()));
                        System.out.println("LINE NUMBER: " + jpe.getLocation().getLineNumber());
                        this.errorLineNumber = jpe.getLocation().getLineNumber();
                    }
                    this.errant = true;
                    throw e;
                }
            }
            return result;
        }

        @Override
        public Long getErrorLineNumber() {
            return this.errorLineNumber;
        }
    }

    private static interface RecordProvider {
        public JsonObject getNextRecord();

        public Long getErrorLineNumber();
    }

    private class JsonLinesRecordProvider
    implements RecordProvider {
        private BufferedReader reader;
        private long lineNumber = 0L;
        private Long errorLineNumber = null;

        public JsonLinesRecordProvider(Reader reader) {
            this.reader = new BufferedReader(reader);
        }

        @Override
        public JsonObject getNextRecord() {
            try {
                RecordReader owner = RecordReader.this;
                JsonObject record = null;
                while (this.reader != null && record == null) {
                    String line = this.reader.readLine();
                    if (line == null) {
                        this.reader.close();
                        this.reader = null;
                        continue;
                    }
                    ++this.lineNumber;
                    this.errorLineNumber = null;
                    if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                    if (!line.startsWith("{")) {
                        throw new IllegalStateException("Line does not appear to be JSON record: " + line);
                    }
                    try {
                        record = JsonUtilities.parseJsonObject(line);
                    }
                    catch (JsonParsingException e) {
                        this.errorLineNumber = this.lineNumber;
                        throw e;
                    }
                }
                return owner.augmentRecord(record);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public Long getErrorLineNumber() {
            return this.errorLineNumber;
        }
    }

    private class CsvRecordProvider
    implements RecordProvider {
        private CSVParser parser;
        private Iterator<CSVRecord> recordIter;
        private Long errorLineNumber = null;

        public CsvRecordProvider(Reader reader) {
            CSVFormat csvFormat = CSVFormat.Builder.create((CSVFormat)CSVFormat.DEFAULT).setHeader(new String[0]).setSkipHeaderRecord(true).setIgnoreEmptyLines(true).setTrim(true).setIgnoreSurroundingSpaces(true).build();
            try {
                this.parser = new CSVParser(reader, csvFormat);
                Map headerMap = this.parser.getHeaderMap();
                HashSet headers = new HashSet();
                headerMap.keySet().forEach(h -> headers.add(h.toUpperCase()));
                this.recordIter = this.parser.iterator();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public JsonObject getNextRecord() {
            RecordReader owner = RecordReader.this;
            this.errorLineNumber = null;
            try {
                if (!this.recordIter.hasNext()) {
                    return null;
                }
                CSVRecord record = this.recordIter.next();
                Map recordMap = record.toMap();
                Iterator entryIter = recordMap.entrySet().iterator();
                while (entryIter.hasNext()) {
                    Map.Entry entry = entryIter.next();
                    String value = (String)entry.getValue();
                    if (value != null && value.trim().length() != 0) continue;
                    entryIter.remove();
                }
                Map map = recordMap;
                JsonObject jsonObj = Json.createObjectBuilder((Map)map).build();
                JsonObject result = owner.augmentRecord(jsonObj);
                return result;
            }
            catch (RuntimeException e) {
                this.errorLineNumber = this.parser.getCurrentLineNumber();
                throw e;
            }
            catch (Exception e) {
                this.errorLineNumber = this.parser.getCurrentLineNumber();
                throw new RuntimeException(e);
            }
        }

        @Override
        public Long getErrorLineNumber() {
            return this.errorLineNumber;
        }
    }
}

