/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.naming;

import com.senzing.util.AccessToken;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NoPermissionException;

public class Registry<T> {
    private Map<String, T> bindingMap = new LinkedHashMap<String, T>();
    private Map<String, AccessToken> tokenMap = new LinkedHashMap<String, AccessToken>();
    private boolean allowNull;

    public Registry() {
        this(false);
    }

    public Registry(boolean allowNull) {
        this.allowNull = allowNull;
    }

    public boolean isAllowingNull() {
        return this.allowNull;
    }

    public synchronized AccessToken bind(String name, T object) throws NameAlreadyBoundException, NullPointerException {
        Objects.requireNonNull(name, "The bound name cannot be null");
        if (!this.isAllowingNull()) {
            Objects.requireNonNull(object, "The bound object cannot be null");
        }
        if (this.bindingMap.containsKey(name)) {
            throw new NameAlreadyBoundException("The specified name is already bound: " + name);
        }
        AccessToken token = new AccessToken();
        this.bindingMap.put(name, object);
        this.tokenMap.put(name, token);
        return token;
    }

    public synchronized T lookup(String name) throws NullPointerException, NameNotFoundException {
        if (!this.bindingMap.containsKey(name)) {
            throw new NameNotFoundException("The specified name is not bound: " + name);
        }
        return this.bindingMap.get(name);
    }

    public synchronized boolean isBound(String name) throws NullPointerException {
        Objects.requireNonNull(name, "The specified name cannot be null");
        return this.bindingMap.containsKey(name);
    }

    public synchronized void unbind(String name, AccessToken token) throws NullPointerException, NameNotFoundException, NoPermissionException {
        Objects.requireNonNull(name, "The provider name cannot be null");
        Objects.requireNonNull(token, "The access token cannot be null");
        AccessToken expected = this.tokenMap.get(name);
        if (expected == null) {
            throw new NameNotFoundException("The specified provider name is not recognized: " + name);
        }
        if (token != expected) {
            throw new NoPermissionException("The specified token does not match the specified name: " + name);
        }
        this.bindingMap.remove(name);
        this.tokenMap.remove(name);
    }
}

