/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.sql;

import com.senzing.sql.Connector;
import com.senzing.sql.PooledConnectionHandler;
import com.senzing.sql.SQLUtilities;
import com.senzing.sql.TransactionIsolation;
import com.senzing.util.Quantified;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConnectionPool
implements Quantified {
    private static final long ONE_MILLION = 1000000L;
    private static final long WAIT_TIMEOUT = 2000L;
    private Connector connector = null;
    private TransactionIsolation isolationLevel = null;
    private IdentityHashMap<PooledConnection, Long> allConnections = null;
    private List<PooledConnection> availableConnections = null;
    private IdentityHashMap<Connection, PooledConnection> leasedMap;
    private int minPoolSize = 0;
    private int maxPoolSize = 1;
    private long expireTime = 0L;
    private int retireLimit = 0;
    private boolean shutdown = false;
    private int greatestPoolSize = 0;
    private long cumulativeLeaseCount = 0L;
    private long cumulativeLeaseChecks = 0L;
    private int greatestLeasedCount = -1;
    private long greatestLeaseTime = -1L;
    private long totalLeaseTime = 0L;
    private int expiredCount = 0;
    private int retiredCount = 0;
    private long totalLeaseCount = 0L;
    private long completedLeaseCount = 0L;
    private long totalAcquisitionTime = 0L;
    private long greatestAcquisitionTime = -1L;
    private long idleStartTimeNanos = -1L;
    private ConnectionExpireThread expireThread = null;
    private final Object statsMonitor = new Object();
    private static final String CONNECTION_UNITS = "connections";
    private static final String MILLISECOND_UNITS = "ms";
    private static final String LEASE_UNITS = "leases";

    public ConnectionPool(Connector connector, int poolSize) throws SQLException, IllegalArgumentException, NullPointerException {
        this(connector, null, poolSize);
    }

    public ConnectionPool(Connector connector, TransactionIsolation isolationLevel, int poolSize) throws SQLException, IllegalArgumentException, NullPointerException {
        this(connector, isolationLevel, poolSize, poolSize);
    }

    public ConnectionPool(Connector connector, int minPoolSize, int maxPoolSize) throws SQLException, IllegalArgumentException, NullPointerException {
        this(connector, null, minPoolSize, maxPoolSize);
    }

    public ConnectionPool(Connector connector, TransactionIsolation isolationLevel, int minPoolSize, int maxPoolSize) throws SQLException, IllegalArgumentException, NullPointerException {
        this(connector, isolationLevel, minPoolSize, maxPoolSize, 0, 0);
    }

    public ConnectionPool(Connector connector, int minPoolSize, int maxPoolSize, int expireTime, int retireLimit) throws SQLException, IllegalArgumentException, NullPointerException {
        this(connector, null, minPoolSize, maxPoolSize, expireTime, retireLimit);
    }

    public ConnectionPool(Connector connector, TransactionIsolation isolationLevel, int minPoolSize, int maxPoolSize, int expireTime, int retireLimit) throws SQLException, IllegalArgumentException, NullPointerException {
        Objects.requireNonNull(connector, "The specified connector cannot be null");
        if (minPoolSize < 0) {
            throw new IllegalArgumentException("The minimum pool size cannot be negative: " + minPoolSize);
        }
        if (maxPoolSize <= 0) {
            throw new IllegalArgumentException("The maximum pool size must be a positive number: " + maxPoolSize);
        }
        if (minPoolSize > maxPoolSize) {
            throw new IllegalArgumentException("Minimum pool size (" + minPoolSize + ") cannot exceed maximum poll size (" + maxPoolSize + ").");
        }
        if (expireTime < 0) {
            throw new IllegalArgumentException("The maximum connection lifespan (expire time) cannot be negative: " + expireTime);
        }
        if (expireTime < 0) {
            throw new IllegalArgumentException("The maximum connection leases (retire count) cannot be negative: " + retireLimit);
        }
        this.connector = connector;
        this.isolationLevel = isolationLevel;
        this.minPoolSize = minPoolSize;
        this.maxPoolSize = maxPoolSize;
        this.expireTime = expireTime * 1000;
        this.retireLimit = retireLimit;
        this.allConnections = new IdentityHashMap();
        for (int index = 0; index < this.minPoolSize; ++index) {
            PooledConnection pooledConnection = new PooledConnection(this.connector.openConnection());
            this.allConnections.put(pooledConnection, pooledConnection.getCreatedTimeNanos());
        }
        this.greatestPoolSize = this.allConnections.size();
        this.availableConnections = new LinkedList<PooledConnection>();
        for (PooledConnection conn : this.allConnections.keySet()) {
            this.availableConnections.add(conn);
        }
        this.leasedMap = new IdentityHashMap();
        if (this.expireTime > 0L) {
            this.expireThread = new ConnectionExpireThread();
            this.expireThread.start();
        } else {
            this.expireThread = null;
        }
        this.idleStartTimeNanos = System.nanoTime();
    }

    public TransactionIsolation getIsolationLevel() {
        return this.isolationLevel;
    }

    public synchronized String getDiagnosticLeaseInfo() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        this.leasedMap.values().forEach(pooledConnection -> {
            PooledConnectionHandler handler = pooledConnection.getCurrentLeaseHandler();
            pw.println();
            pw.println(handler.getDiagnosticInfo());
        });
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<Quantified.Statistic, Number> getStatistics() {
        LinkedHashMap<Quantified.Statistic, Number> result = new LinkedHashMap<Quantified.Statistic, Number>();
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ConnectionPool.putStat(result, Stat.minimumSize, this.getMinimumSize());
            ConnectionPool.putStat(result, Stat.maximumSize, this.getMaximumSize());
            ConnectionPool.putStat(result, Stat.expireTime, this.getExpireTime());
            ConnectionPool.putStat(result, Stat.retireLimit, this.getRetireLimit());
            ConnectionPool.putStat(result, Stat.greatestLeasedCount, this.getGreatestLeasedCount());
            ConnectionPool.putStat(result, Stat.averageLeasedCount, this.getAverageLeasedCount());
            ConnectionPool.putStat(result, Stat.greatestPoolSize, this.getGreatestPoolSize());
            ConnectionPool.putStat(result, Stat.expiredConnections, this.getExpiredConnectionCount());
            ConnectionPool.putStat(result, Stat.retiredConnections, this.getRetiredConnectionCount());
            ConnectionPool.putStat(result, Stat.averageAcquireTime, this.getAverageAcquisitionTime());
            ConnectionPool.putStat(result, Stat.greatestAcquireTime, this.getGreatestAcquisitionTime());
            ConnectionPool.putStat(result, Stat.greatestLeaseTime, this.getGreatestLeaseTime());
            ConnectionPool.putStat(result, Stat.averageLeaseTime, this.getAverageLeaseTime());
            ConnectionPool.putStat(result, Stat.lifetimeLeaseCount, this.getLifetimeLeaseCount());
            ConnectionPool.putStat(result, Stat.currentPoolSize, this.getCurrentPoolSize());
            ConnectionPool.putStat(result, Stat.availableConnections, this.getAvailableConnectionCount());
            ConnectionPool.putStat(result, Stat.outstandingLeases, this.getOutstandingLeaseCount());
            ConnectionPool.putStat(result, Stat.greatestOutstandingLeaseTime, this.getGreatestOutstandingLeaseTime());
            ConnectionPool.putStat(result, Stat.averageOutstandingLeaseTime, this.getAverageOutstandingLeaseTime());
            ConnectionPool.putStat(result, Stat.idleTime, this.getIdleTime());
        }
        return result;
    }

    private static void putStat(Map<Quantified.Statistic, Number> map, Stat key, Number value) {
        if (value == null) {
            return;
        }
        map.put(key, value);
    }

    private static long elapsed(long startNanos) {
        return (System.nanoTime() - startNanos) / 1000000L;
    }

    public Connection acquire() throws SQLException {
        return this.acquire(-1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection acquire(long maxWait) throws SQLException, IllegalArgumentException {
        long startTime = System.nanoTime();
        PooledConnection acquired = null;
        Integer newPoolSize = null;
        Integer leasedCount = null;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            while (!(acquired != null || this.isShutdown() || maxWait > 0L && ConnectionPool.elapsed(startTime) >= maxWait)) {
                while (!(this.isShutdown() || this.availableConnections.size() != 0 || this.allConnections.size() != this.getMaximumSize() || maxWait >= 0L && ConnectionPool.elapsed(startTime) >= maxWait)) {
                    if (maxWait == 0L) continue;
                    try {
                        long timeout;
                        long l = timeout = maxWait < 0L ? 2000L : Math.min(2000L, maxWait - ConnectionPool.elapsed(startTime));
                        if (timeout < 0L) break;
                        this.wait(timeout);
                    }
                    catch (InterruptedException timeout) {}
                }
                if (this.isShutdown()) {
                    throw new SQLException("Unable to obtain a connection because the connection pool was shutdown");
                }
                Long maxLifespan = this.getExpireTime();
                if (maxLifespan != null) {
                    this.expireConnections();
                    newPoolSize = this.allConnections.size();
                }
                if (this.availableConnections.size() == 0 && this.allConnections.size() < this.getMaximumSize()) {
                    acquired = new PooledConnection(this.connector.openConnection());
                    this.allConnections.put(acquired, acquired.getCreatedTimeNanos());
                    newPoolSize = this.allConnections.size();
                } else if (this.availableConnections.size() > 0) {
                    acquired = this.availableConnections.remove(0);
                }
                if (maxWait != 0L) continue;
                break;
            }
            if (acquired == null && this.isShutdown()) {
                throw new SQLException("Unable to obtain a connection because the connection pool was shutdown");
            }
            if (acquired == null && maxWait < 0L) {
                throw new IllegalStateException("Exited wait loop, but did not acquire a pooled connection.");
            }
            if (acquired != null) {
                PooledConnectionHandler handler = new PooledConnectionHandler(this, acquired.getConnection());
                acquired.setCurrentLeaseHandler(handler);
                this.leasedMap.put(handler.getProxiedConnection(), acquired);
            }
            leasedCount = this.leasedMap.size();
            this.notifyAll();
            if (acquired != null) {
                long acquisitionTime = (System.nanoTime() - startTime) / 1000000L;
                this.totalAcquisitionTime += acquisitionTime;
                if (acquisitionTime > this.greatestAcquisitionTime) {
                    this.greatestAcquisitionTime = acquisitionTime;
                }
            }
            if (newPoolSize != null && newPoolSize > this.greatestPoolSize) {
                this.greatestPoolSize = newPoolSize;
            }
            if (leasedCount != null) {
                this.cumulativeLeaseCount += (long)leasedCount.intValue();
                ++this.cumulativeLeaseChecks;
                if (leasedCount > this.greatestLeasedCount) {
                    this.greatestLeasedCount = leasedCount;
                }
            }
            if (acquired != null) {
                ++this.totalLeaseCount;
            }
            if (acquired != null) {
                this.idleStartTimeNanos = System.nanoTime();
            }
        }
        if (acquired == null) {
            return null;
        }
        Connection conn = acquired.getConnection();
        if (conn.getAutoCommit()) {
            conn.setAutoCommit(false);
        }
        if (this.getIsolationLevel() != null) {
            this.getIsolationLevel().applyTo(conn);
        }
        return acquired.getCurrentLeaseHandler().getProxiedConnection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release(Connection connection) throws SQLException {
        if (connection == null) {
            return;
        }
        Long leasedTime = null;
        Integer leasedCount = null;
        int retired = 0;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            this.notifyAll();
            InvocationHandler handler = null;
            try {
                handler = Proxy.getInvocationHandler(connection);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("The specified Connection is not from this pool instance (not a proxy).");
            }
            if (!(handler instanceof PooledConnectionHandler)) {
                throw new IllegalArgumentException("The specified Connection is not from this pool instance (wrong handler type): " + handler.getClass().getName());
            }
            PooledConnectionHandler pch = (PooledConnectionHandler)handler;
            if (pch.getPool() != this) {
                throw new IllegalArgumentException("The specified Connection is not from this pool instance (wrong pool instance).");
            }
            PooledConnection pooledConn = this.leasedMap.get(connection);
            if (pooledConn == null) {
                Exception exception = new Exception("WARNING: Connection released more than once");
                System.err.println();
                System.err.println("-------------------------------------------------");
                exception.printStackTrace();
                return;
            }
            this.leasedMap.remove(connection);
            Connection backingConn = pooledConn.getConnection();
            if (!backingConn.getAutoCommit()) {
                backingConn.rollback();
            }
            backingConn.setAutoCommit(false);
            leasedCount = this.leasedMap.size();
            pch.markClosed();
            leasedTime = pch.getLeaseTime();
            pooledConn.setCurrentLeaseHandler(null);
            if (this.getRetireLimit() != null && pooledConn.getLeaseCount() > this.getRetireLimit()) {
                this.allConnections.remove(pooledConn);
                SQLUtilities.close(pooledConn.getConnection());
                ++retired;
                if (this.allConnections.size() < this.getMinimumSize()) {
                    try {
                        PooledConnection refill = new PooledConnection(this.connector.openConnection());
                        this.allConnections.put(refill, refill.getCreatedTimeNanos());
                        this.availableConnections.add(refill);
                    }
                    catch (SQLException ignore) {
                        ignore.printStackTrace();
                    }
                }
            } else {
                this.availableConnections.add(pooledConn);
            }
            if (leasedTime != null) {
                if (leasedTime > this.greatestLeaseTime) {
                    this.greatestLeaseTime = leasedTime;
                }
                this.totalLeaseTime += leasedTime.longValue();
            }
            if (leasedCount != null) {
                this.cumulativeLeaseCount += (long)leasedCount.intValue();
                ++this.cumulativeLeaseChecks;
                if (leasedCount > this.greatestLeasedCount) {
                    this.greatestLeasedCount = leasedCount;
                }
            }
            this.retiredCount += retired;
            ++this.completedLeaseCount;
        }
    }

    public synchronized boolean isShutdown() {
        return this.shutdown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        Object object = this;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            this.notifyAll();
        }
        if (this.expireThread != null) {
            object = this.expireThread;
            synchronized (object) {
                this.expireThread.notifyAll();
            }
        }
        object = this;
        synchronized (object) {
            while (this.availableConnections.size() < this.allConnections.size()) {
                try {
                    this.wait(2000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            for (PooledConnection pooledConn : this.allConnections.keySet()) {
                SQLUtilities.close(pooledConn.getConnection());
            }
            this.availableConnections.clear();
            this.allConnections.clear();
            this.leasedMap.clear();
        }
        if (this.expireThread != null) {
            try {
                this.expireThread.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public int getMinimumSize() {
        return this.minPoolSize;
    }

    public int getMaximumSize() {
        return this.maxPoolSize;
    }

    public Long getExpireTime() {
        if (this.expireTime <= 0L) {
            return null;
        }
        return this.expireTime;
    }

    public Integer getRetireLimit() {
        if (this.retireLimit <= 0) {
            return null;
        }
        return this.retireLimit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGreatestLeasedCount() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.greatestLeasedCount < 0) {
                return null;
            }
            return this.greatestLeasedCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getAverageLeasedCount() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.totalLeaseCount <= 0L || this.cumulativeLeaseChecks <= 0L) {
                return null;
            }
            double acquireCount = this.cumulativeLeaseCount;
            double checkCount = this.cumulativeLeaseChecks;
            return acquireCount / checkCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getGreatestPoolSize() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return this.greatestPoolSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getExpiredConnectionCount() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.getExpireTime() == null) {
                return null;
            }
            return this.expiredCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer getRetiredConnectionCount() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.getRetireLimit() == null) {
                return null;
            }
            return this.retiredCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getAverageAcquisitionTime() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.totalAcquisitionTime < 0L || this.totalLeaseCount <= 0L) {
                return null;
            }
            double totalTime = this.totalAcquisitionTime;
            double totalCount = this.totalLeaseCount;
            return totalTime / totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getGreatestAcquisitionTime() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.totalLeaseCount == 0L || this.greatestAcquisitionTime < 0L) {
                return null;
            }
            return this.greatestAcquisitionTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getGreatestLeaseTime() {
        long greatestTime = -1L;
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            for (PooledConnection pooledConn : this.leasedMap.values()) {
                PooledConnectionHandler handler = pooledConn.getCurrentLeaseHandler();
                Long leaseTime = handler.getLeaseTime();
                if (leaseTime == null || leaseTime <= greatestTime) continue;
                greatestTime = leaseTime;
            }
            if (this.totalLeaseCount == 0L) {
                return null;
            }
            return Math.max(greatestTime, this.greatestLeaseTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getAverageLeaseTime() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.completedLeaseCount == 0L) {
                return null;
            }
            double totalTime = this.totalLeaseTime;
            double totalCount = this.totalLeaseCount;
            return totalTime / totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCurrentPoolSize() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return this.allConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getAvailableConnectionCount() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return this.availableConnections.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutstandingLeaseCount() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return this.leasedMap.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long getGreatestOutstandingLeaseTime() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.leasedMap.size() == 0) {
                return null;
            }
            long greatestTime = -1L;
            for (PooledConnection pooledConn : this.leasedMap.values()) {
                long leaseTime = pooledConn.getCurrentLeaseHandler().getLeaseTime();
                if (leaseTime <= greatestTime) continue;
                greatestTime = leaseTime;
            }
            return greatestTime;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Double getAverageOutstandingLeaseTime() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.leasedMap.size() == 0) {
                return null;
            }
            long totalTime = 0L;
            for (PooledConnection pooledConn : this.leasedMap.values()) {
                totalTime += pooledConn.getCurrentLeaseHandler().getLeaseTime().longValue();
            }
            double leaseCount = this.leasedMap.size();
            return (double)totalTime / leaseCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getIdleTime() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return (System.nanoTime() - this.idleStartTimeNanos) / 1000000L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLifetimeLeaseCount() {
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            return this.totalLeaseCount;
        }
    }

    protected synchronized void expireConnections() throws SQLException {
        if (this.getExpireTime() == null) {
            return;
        }
        int expired = 0;
        long maxLifespan = this.getExpireTime();
        Iterator<PooledConnection> iter = this.availableConnections.iterator();
        while (iter.hasNext()) {
            PooledConnection pooledConn = iter.next();
            if (pooledConn.getLifespan() <= maxLifespan) continue;
            SQLUtilities.close(pooledConn.getConnection());
            ++expired;
            iter.remove();
            this.allConnections.remove(pooledConn);
        }
        while (this.allConnections.size() < this.getMinimumSize()) {
            PooledConnection refill = new PooledConnection(this.connector.openConnection());
            this.allConnections.put(refill, refill.getCreatedTimeNanos());
            this.availableConnections.add(refill);
        }
        this.expiredCount += expired;
    }

    private class ConnectionExpireThread
    extends Thread {
        private ConnectionExpireThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ConnectionPool pool = ConnectionPool.this;
            long waitTime = pool.getExpireTime() / 2L;
            while (!pool.isShutdown()) {
                Object object = this;
                synchronized (object) {
                    try {
                        this.wait(waitTime);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                object = pool;
                synchronized (object) {
                    if (pool.isShutdown()) {
                        continue;
                    }
                    if (pool.getIdleTime() < waitTime) {
                        continue;
                    }
                    try {
                        pool.expireConnections();
                    }
                    catch (SQLException e) {
                        System.err.println("*** WARNING: Exception while expiring connections");
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    protected static class PooledConnection {
        private Connection connection = null;
        private long createdTimeNanos;
        private int leaseCount = 0;
        private PooledConnectionHandler currentLeaseHandler = null;

        public PooledConnection(Connection connection) {
            this.connection = connection;
            this.createdTimeNanos = System.nanoTime();
            this.leaseCount = 0;
            this.currentLeaseHandler = null;
        }

        public Connection getConnection() {
            return this.connection;
        }

        public long getCreatedTimeNanos() {
            return this.createdTimeNanos;
        }

        public long getLifespan() {
            return (System.nanoTime() - this.createdTimeNanos) / 1000000L;
        }

        public PooledConnectionHandler getCurrentLeaseHandler() {
            return this.currentLeaseHandler;
        }

        public void setCurrentLeaseHandler(PooledConnectionHandler handler) {
            if (handler != null && this.currentLeaseHandler != null) {
                throw new IllegalStateException("Setting a connection handler on a pooled connection that already has one set (i.e.: is already or still leased)");
            }
            this.currentLeaseHandler = handler;
            if (handler != null) {
                ++this.leaseCount;
            }
        }

        public int getLeaseCount() {
            return this.leaseCount;
        }
    }

    public static enum Stat implements Quantified.Statistic
    {
        minimumSize("connections"),
        maximumSize("connections"),
        currentPoolSize("connections"),
        availableConnections("connections"),
        outstandingLeases("leases"),
        greatestOutstandingLeaseTime("ms"),
        averageOutstandingLeaseTime("ms"),
        expireTime("ms"),
        retireLimit("leases"),
        greatestLeasedCount("connections"),
        averageLeasedCount("connections"),
        greatestPoolSize("connections"),
        expiredConnections("connections"),
        retiredConnections("connections"),
        averageAcquireTime("ms"),
        greatestAcquireTime("ms"),
        greatestLeaseTime("ms"),
        averageLeaseTime("ms"),
        lifetimeLeaseCount("leases"),
        idleTime("ms");

        private String units = null;

        private Stat(String units) {
            this.units = units;
        }

        @Override
        public String getUnits() {
            return this.units;
        }
    }
}

