/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.sql;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Objects;
import java.util.TimeZone;

public enum DatabaseType {
    GENERIC,
    SQLITE,
    POSTGRESQL,
    MYSQL,
    ORACLE,
    DB2;

    private static final Calendar UTC_CALENDAR;
    private static final String DATE_TIME_PATTERN = "yyyy-MM-dd HH:mm:ss.SSS";
    private static final ZoneId UTC_ZONE;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;

    public static DatabaseType detect(Connection conn) throws SQLException {
        if (conn == null) {
            return null;
        }
        String productName = conn.getMetaData().getDatabaseProductName();
        switch (productName.toUpperCase()) {
            case "SQLITE": {
                return SQLITE;
            }
            case "POSTGRESQL": {
                return POSTGRESQL;
            }
            case "MYSQL": {
                return MYSQL;
            }
            case "ORACLE": {
                return ORACLE;
            }
            case "DB2": {
                return DB2;
            }
        }
        return GENERIC;
    }

    public String getTimestampBindingSQL() {
        switch (this.ordinal()) {
            case 1: {
                return "(STRFTIME('%Y-%m-%d %H:%M:%f', ?))";
            }
        }
        return "?";
    }

    public void setTimestamp(PreparedStatement ps, int index, Timestamp value) throws SQLException {
        switch (this.ordinal()) {
            case 1: {
                Instant instant = Instant.ofEpochMilli(value.getTime());
                ZonedDateTime zonedDateTime = instant.atZone(UTC_ZONE);
                ps.setString(index, DATE_TIME_FORMATTER.format(zonedDateTime));
                break;
            }
            default: {
                ps.setTimestamp(index, value, UTC_CALENDAR);
            }
        }
    }

    public void setTimestamp(CallableStatement cs, int index, Timestamp value) throws SQLException {
        switch (this.ordinal()) {
            case 1: {
                Instant instant = Instant.ofEpochMilli(value.getTime());
                ZonedDateTime zonedDateTime = instant.atZone(UTC_ZONE);
                cs.setString(index, DATE_TIME_FORMATTER.format(zonedDateTime));
            }
        }
        cs.setTimestamp(index, value, UTC_CALENDAR);
    }

    public String sqlLeast(String first, String second, String ... other) throws NullPointerException {
        Objects.requireNonNull(first, "The first parameter to LEAST cannot be null");
        Objects.requireNonNull(first, "The second parameter to LEAST cannot be null");
        StringBuilder sb = new StringBuilder();
        switch (this.ordinal()) {
            case 1: {
                sb.append("MIN");
                break;
            }
            default: {
                sb.append("LEAST");
            }
        }
        sb.append("(").append(first).append(", ").append(second);
        if (other != null) {
            for (String param : other) {
                sb.append(", ").append(param);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    public String sqlGreatest(String first, String second, String ... other) throws NullPointerException {
        Objects.requireNonNull(first, "The first parameter to GREATEST cannot be null");
        Objects.requireNonNull(first, "The second parameter to GREATEST cannot be null");
        StringBuilder sb = new StringBuilder();
        switch (this.ordinal()) {
            case 1: {
                sb.append("MAX");
                break;
            }
            default: {
                sb.append("GREATEST");
            }
        }
        sb.append("(").append(first).append(", ").append(second);
        if (other != null) {
            for (String param : other) {
                sb.append(", ").append(param);
            }
        }
        sb.append(")");
        return sb.toString();
    }

    static {
        UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        UTC_ZONE = ZoneId.of("UTC");
        DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern(DATE_TIME_PATTERN);
    }
}

