/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.sql;

import com.senzing.sql.ConnectionPool;
import com.senzing.util.LoggingUtilities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.SQLException;

class PooledConnectionHandler
implements InvocationHandler {
    private static final long ONE_MILLION = 1000000L;
    private ConnectionPool pool = null;
    private final Connection backingConnection;
    private final Connection proxiedConnection;
    private final Object backingObject;
    private boolean closed = false;
    private long createdTimeNanos = 0L;
    private long closedTimeNanos = -1L;
    private Thread thread = null;
    private StackTraceElement[] stackTrace = null;

    PooledConnectionHandler(ConnectionPool pool, Connection backingConnection) {
        Class[] interfaces = new Class[]{Connection.class};
        this.createdTimeNanos = System.nanoTime();
        this.pool = pool;
        this.backingConnection = backingConnection;
        this.backingObject = backingConnection;
        this.closed = false;
        this.thread = Thread.currentThread();
        this.stackTrace = this.thread.getStackTrace();
        this.proxiedConnection = (Connection)Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)this);
    }

    private PooledConnectionHandler(PooledConnectionHandler parentHandler, Object backingObject) {
        Class[] interfaces = new Class[]{Connection.class};
        this.createdTimeNanos = System.nanoTime();
        this.pool = parentHandler.pool;
        this.backingConnection = parentHandler.backingConnection;
        this.proxiedConnection = parentHandler.proxiedConnection;
        this.closed = false;
        this.backingObject = backingObject;
        this.thread = Thread.currentThread();
        this.stackTrace = this.thread.getStackTrace();
    }

    ConnectionPool getPool() {
        return this.pool;
    }

    Connection getProxiedConnection() {
        return this.proxiedConnection;
    }

    synchronized boolean isClosed() {
        return this.closed;
    }

    synchronized void markClosed() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.closedTimeNanos = System.nanoTime();
    }

    synchronized Long getLeaseTime() {
        if (this.closedTimeNanos > 0L) {
            return (this.closedTimeNanos - this.createdTimeNanos) / 1000000L;
        }
        if (this.backingConnection == this.backingObject) {
            return (System.nanoTime() - this.createdTimeNanos) / 1000000L;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object result = null;
        if (proxy == this.proxiedConnection) {
            String methodName;
            boolean open = !this.isClosed();
            switch (methodName = method.getName()) {
                case "close": {
                    if (!open) {
                        return null;
                    }
                    this.pool.release(this.proxiedConnection);
                    this.markClosed();
                    break;
                }
                case "isClosed": {
                    PooledConnectionHandler pooledConnectionHandler = this;
                    synchronized (pooledConnectionHandler) {
                        return this.closed;
                    }
                }
                default: {
                    if (open) {
                        try {
                            result = method.invoke(this.backingObject, args);
                            break;
                        }
                        catch (InvocationTargetException e) {
                            throw e.getTargetException();
                        }
                    }
                    throw new SQLException("Connection already closed.");
                }
            }
        } else {
            try {
                result = method.invoke(this.backingObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        if (result == this.backingConnection) {
            return this.proxiedConnection;
        }
        Class<?> returnType = method.getReturnType();
        if (returnType.isInterface() && "java.sql".equals(returnType.getPackageName())) {
            PooledConnectionHandler subHandler = new PooledConnectionHandler(this, result);
            Class[] interfaces = new Class[]{method.getReturnType()};
            return Proxy.newProxyInstance(this.getClass().getClassLoader(), interfaces, (InvocationHandler)subHandler);
        }
        return result;
    }

    public String getDiagnosticInfo() {
        long duration = (System.nanoTime() - this.createdTimeNanos) / 1000000L;
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("-----------------------------------------------------------");
        pw.println("LEASE DURATION: " + duration + "ms");
        pw.println();
        pw.println("LEASE OBTAINED AT: ");
        pw.println(LoggingUtilities.formatStackTrace(this.stackTrace));
        pw.println("- - - - - - - - - - - - - - - - - - - - - - - - - - - - - -");
        pw.println("LEASE-HOLDER CURRENT STACK TRACE: ");
        pw.println(LoggingUtilities.formatStackTrace(this.thread.getStackTrace()));
        return sw.toString();
    }
}

