/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.sql;

import java.math.BigDecimal;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.TimeZone;

public class SQLUtilities {
    public static final Calendar UTC_CALENDAR = Calendar.getInstance(TimeZone.getTimeZone("UTC"));

    private SQLUtilities() {
    }

    public static void rollback(Connection conn) {
        if (conn == null) {
            return;
        }
        try {
            conn.rollback();
        }
        catch (SQLException e) {
            System.err.println();
            System.err.println("***************************************************");
            System.err.println("Exception caught when rolling back transaction:");
            e.printStackTrace();
        }
    }

    public static Connection close(Connection conn) {
        if (conn == null) {
            return null;
        }
        try {
            if (conn.isClosed()) {
                return null;
            }
            conn.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static Statement close(Statement stmt) {
        if (stmt == null) {
            return null;
        }
        try {
            if (stmt.isClosed()) {
                return null;
            }
            stmt.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static PreparedStatement close(PreparedStatement ps) {
        if (ps == null) {
            return null;
        }
        try {
            if (ps.isClosed()) {
                return null;
            }
            ps.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static CallableStatement close(CallableStatement cs) {
        if (cs == null) {
            return null;
        }
        try {
            if (cs.isClosed()) {
                return null;
            }
            cs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static ResultSet close(ResultSet rs) {
        if (rs == null) {
            return null;
        }
        try {
            if (rs.isClosed()) {
                return null;
            }
            rs.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public static BigDecimal getBigDecimal(ResultSet rs, int index) throws SQLException {
        BigDecimal result = rs.getBigDecimal(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Boolean getBoolean(ResultSet rs, int index) throws SQLException {
        boolean result = rs.getBoolean(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Byte getByte(ResultSet rs, int index) throws SQLException {
        byte result = rs.getByte(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Date getDate(ResultSet rs, int index) throws SQLException {
        Date result = rs.getDate(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Date getDate(ResultSet rs, int index, Calendar calendar) throws SQLException {
        Date result = rs.getDate(index, calendar);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Double getDouble(ResultSet rs, int index) throws SQLException {
        double result = rs.getDouble(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Float getFloat(ResultSet rs, int index) throws SQLException {
        float result = rs.getFloat(index);
        if (rs.wasNull()) {
            return null;
        }
        return Float.valueOf(result);
    }

    public static Integer getInt(ResultSet rs, int index) throws SQLException {
        int result = rs.getInt(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Long getLong(ResultSet rs, int index) throws SQLException {
        long result = rs.getLong(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Short getShort(ResultSet rs, int index) throws SQLException {
        short result = rs.getShort(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static String getString(ResultSet rs, int index) throws SQLException {
        String result = rs.getString(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Time getTime(ResultSet rs, int index) throws SQLException {
        Time result = rs.getTime(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Time getTime(ResultSet rs, int index, Calendar calendar) throws SQLException {
        Time result = rs.getTime(index, calendar);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Timestamp getTimestamp(ResultSet rs, int index) throws SQLException {
        Timestamp result = rs.getTimestamp(index);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Timestamp getTimestamp(ResultSet rs, int index, Calendar calendar) throws SQLException {
        Timestamp result = rs.getTimestamp(index, calendar);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static BigDecimal getBigDecimal(ResultSet rs, String columnName) throws SQLException {
        BigDecimal result = rs.getBigDecimal(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Boolean getBoolean(ResultSet rs, String columnName) throws SQLException {
        boolean result = rs.getBoolean(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Byte getByte(ResultSet rs, String columnName) throws SQLException {
        byte result = rs.getByte(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Date getDate(ResultSet rs, String columnName) throws SQLException {
        Date result = rs.getDate(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Date getDate(ResultSet rs, String columnName, Calendar calendar) throws SQLException {
        Date result = rs.getDate(columnName, calendar);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Double getDouble(ResultSet rs, String columnName) throws SQLException {
        double result = rs.getDouble(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Float getFloat(ResultSet rs, String columnName) throws SQLException {
        float result = rs.getFloat(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return Float.valueOf(result);
    }

    public static Integer getInt(ResultSet rs, String columnName) throws SQLException {
        int result = rs.getInt(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Long getLong(ResultSet rs, String columnName) throws SQLException {
        long result = rs.getLong(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Short getShort(ResultSet rs, String columnName) throws SQLException {
        short result = rs.getShort(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static String getString(ResultSet rs, String columnName) throws SQLException {
        String result = rs.getString(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Time getTime(ResultSet rs, String columnName) throws SQLException {
        Time result = rs.getTime(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Time getTime(ResultSet rs, String columnName, Calendar calendar) throws SQLException {
        Time result = rs.getTime(columnName, calendar);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Timestamp getTimestamp(ResultSet rs, String columnName) throws SQLException {
        Timestamp result = rs.getTimestamp(columnName);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static Timestamp getTimestamp(ResultSet rs, String columnName, Calendar calendar) throws SQLException {
        Timestamp result = rs.getTimestamp(columnName, calendar);
        if (rs.wasNull()) {
            return null;
        }
        return result;
    }

    public static void main(String[] args) {
        try {
            for (String jdbcUrl : args) {
                Connection conn = DriverManager.getConnection(jdbcUrl);
                System.out.println(jdbcUrl + " : " + conn.getMetaData().getDatabaseProductName());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

