/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.sql;

import com.senzing.sql.Connector;
import com.senzing.sql.SQLUtilities;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;
import java.util.Objects;

public class SQLiteConnector
implements Connector {
    public static final List<String> DEFAULT_PRAGMA_FEATURES_LIST = List.of("PRAGMA foreign_keys = ON;", "PRAGMA journal_mode = WAL;", "PRAGMA synchronous = 0;", "PRAGMA secure_delete = 0;", "PRAGMA automatic_index = 0;");
    private File sqliteFile = null;

    private static File createTempFile() {
        try {
            File file = File.createTempFile("sqlite-", ".db");
            file.deleteOnExit();
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static File newFile(String filePath) {
        Objects.requireNonNull(filePath, "The specified file path cannot be null");
        File file = new File(filePath);
        if (file.exists() && file.isDirectory()) {
            throw new IllegalArgumentException("The specified file path exists and is a directory: " + filePath);
        }
        return file;
    }

    public SQLiteConnector() {
        this(SQLiteConnector.createTempFile());
    }

    public SQLiteConnector(String filePath) {
        this(SQLiteConnector.newFile(filePath));
    }

    public SQLiteConnector(File sqliteFile) {
        Objects.requireNonNull(sqliteFile, "The specified file cannot be null");
        this.sqliteFile = sqliteFile;
    }

    public File getSqliteFile() {
        return this.sqliteFile;
    }

    @Override
    public Connection openConnection() throws SQLException {
        String jdbcUrl = "jdbc:sqlite:" + this.sqliteFile.getPath();
        Connection conn = null;
        Statement statement = null;
        try {
            conn = DriverManager.getConnection(jdbcUrl);
            statement = conn.createStatement();
            for (String sql : this.getPragmaFeatureStatements()) {
                statement.execute(sql);
            }
        }
        catch (SQLException e) {
            try {
                statement = SQLUtilities.close(statement);
                conn = SQLUtilities.close(conn);
                throw e;
            }
            catch (Throwable throwable) {
                statement = SQLUtilities.close(statement);
                throw throwable;
            }
        }
        statement = SQLUtilities.close(statement);
        conn.setAutoCommit(false);
        return conn;
    }

    protected List<String> getPragmaFeatureStatements() {
        return DEFAULT_PRAGMA_FEATURES_LIST;
    }
}

