/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class AsyncWorkerPool<T> {
    private final List<AsyncWorker<T>> available = new LinkedList<AsyncWorker<T>>();
    private List<AsyncWorker<T>> allThreads = new LinkedList<AsyncWorker<T>>();
    private boolean closed = false;

    public AsyncWorkerPool(int size) {
        this("AsyncWorker", size);
    }

    public AsyncWorkerPool(String baseName, int size) {
        if (baseName.endsWith("-")) {
            baseName = baseName.substring(0, baseName.length() - 1);
        }
        int identityHashCode = System.identityHashCode(this);
        for (int index = 0; index < size; ++index) {
            AsyncWorker aw = new AsyncWorker();
            aw.setName(baseName + "-" + identityHashCode + "-" + index);
            this.available.add(aw);
            this.allThreads.add(aw);
            aw.start();
        }
        this.allThreads = Collections.unmodifiableList(this.allThreads);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBusy() {
        List<AsyncWorker<T>> list = this.available;
        synchronized (list) {
            if (this.isClosed()) {
                return false;
            }
            return this.available.size() < this.allThreads.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AsyncResult<T> execute(Task<T> task) {
        List<AsyncWorker<T>> list = this.available;
        synchronized (list) {
            AsyncWorker<T> worker = null;
            while (worker == null && !this.isClosed()) {
                if (this.available.size() == 0) {
                    try {
                        this.available.wait(10000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (this.available.size() <= 0) continue;
                worker = this.available.remove(0);
            }
            if (worker == null || this.isClosed()) {
                throw new IllegalStateException("Pool closed while attempting to execute a task.");
            }
            return worker.enlist(task);
        }
    }

    public int size() {
        return this.allThreads.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        List<AsyncWorker<T>> list = this.available;
        synchronized (list) {
            return this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AsyncResult<T>> close() {
        List<AsyncWorker<T>> list = this.available;
        synchronized (list) {
            this.closed = true;
            this.available.notifyAll();
        }
        ArrayList<AsyncResult<T>> results = new ArrayList<AsyncResult<T>>(this.allThreads.size());
        for (AsyncWorker<T> thread : this.allThreads) {
            AsyncResult<T> result = thread.retire();
            if (result == null) continue;
            results.add(result);
        }
        return results;
    }

    private class AsyncWorker<T>
    extends Thread {
        private boolean complete = false;
        private Task<T> currentTask = null;
        private AsyncResult<T> previousResult = null;

        private AsyncWorker() {
        }

        private synchronized AsyncResult<T> reset() {
            AsyncResult<T> prevResult = this.previousResult;
            this.currentTask = null;
            this.previousResult = null;
            return prevResult;
        }

        private synchronized AsyncResult<T> enlist(Task<T> task) {
            AsyncResult<T> prevResult = this.reset();
            this.currentTask = task;
            this.notifyAll();
            return prevResult;
        }

        private synchronized boolean isComplete() {
            return this.complete;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private AsyncResult<T> retire() {
            AsyncWorker asyncWorker = this;
            synchronized (asyncWorker) {
                while (this.isBusy()) {
                    try {
                        this.wait(2000L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.complete = true;
                this.notifyAll();
            }
            try {
                this.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return this.reset();
        }

        private synchronized boolean isBusy() {
            return this.currentTask != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            AsyncWorkerPool pool = AsyncWorkerPool.this;
            while (!this.isComplete() && !pool.isClosed()) {
                Object object;
                Task<T> task = null;
                AsyncWorker asyncWorker = this;
                synchronized (asyncWorker) {
                    while (this.currentTask == null && !this.isComplete()) {
                        try {
                            this.wait(10000L);
                        }
                        catch (InterruptedException interruptedException) {}
                    }
                    task = this.currentTask;
                }
                AsyncResult<Object> result = null;
                if (task != null) {
                    try {
                        result = new AsyncResult<T>(this.currentTask.execute(), null);
                    }
                    catch (Exception e) {
                        result = new AsyncResult<Object>(null, e);
                    }
                    object = this;
                    synchronized (object) {
                        this.currentTask = null;
                        this.previousResult = result;
                        this.notifyAll();
                    }
                }
                object = pool.available;
                synchronized (object) {
                    if (!pool.isClosed()) {
                        pool.available.add(this);
                        pool.available.notifyAll();
                    }
                }
            }
        }
    }

    public static interface Task<T> {
        public T execute() throws Exception;
    }

    public static class AsyncResult<T> {
        private T value;
        private Exception failure;

        private AsyncResult(T value, Exception failure) {
            this.value = value;
            this.failure = failure;
        }

        public T getValue() throws Exception {
            if (this.failure != null) {
                throw this.failure;
            }
            return this.value;
        }

        public String toString() {
            return "{ value=[ " + String.valueOf(this.value) + " ]" + (String)(this.failure != null ? ", failure=[ " + String.valueOf(this.failure) + " ]" : "") + " }";
        }
    }
}

