/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import java.util.Objects;

public class ErrorLogSuppressor {
    private static final long DEFAULT_TIME_WINDOW = 5000L;
    private static final long DEFAULT_SUPPRESS_DURATION = 60000L;
    private static final int DEFAULT_ERROR_LIMIT = 10;
    private int errorCount = 0;
    private int periodCount = 0;
    private int suppressedCount = 0;
    private long lastReportTime = 0L;
    private boolean suppressing = false;
    private long timeWindow = 5000L;
    private long nanoWindow = 5000000000L;
    private long suppressDuration = 60000L;
    private long nanoDuration = 60000000000L;
    private int errorLimit = 10;

    public ErrorLogSuppressor() {
        this(10, 5000L, 60000L);
    }

    public ErrorLogSuppressor(int errorLimit, long timeWindow, long suppressDuration) {
        if (errorLimit <= 0) {
            throw new IllegalArgumentException("Error limit must be a positive number: " + errorLimit);
        }
        if (timeWindow <= 0L) {
            throw new IllegalArgumentException("Time window must be a positive number: " + timeWindow);
        }
        if (suppressDuration <= 0L) {
            throw new IllegalArgumentException("Suppress duration must be a positive number: " + suppressDuration);
        }
        this.errorLimit = errorLimit;
        this.timeWindow = timeWindow;
        this.suppressDuration = suppressDuration;
        this.nanoWindow = this.timeWindow * 1000000L;
        this.nanoDuration = this.suppressDuration * 1000000L;
    }

    public synchronized int getErrorCount() {
        return this.errorCount;
    }

    public synchronized boolean isSuppressing() {
        return this.suppressing;
    }

    public synchronized int getSuppressedCount() {
        return this.suppressedCount;
    }

    public synchronized int getPeriodCount() {
        return this.periodCount;
    }

    public int getErrorLimit() {
        return this.errorLimit;
    }

    public long getTimeWindow() {
        return this.timeWindow;
    }

    public long getSuppressDuration() {
        return this.suppressDuration;
    }

    public synchronized Result updateOnError() {
        long now = System.nanoTime();
        State state = null;
        int count = 0;
        ++this.errorCount;
        if (this.suppressing) {
            if (now - this.lastReportTime > this.nanoDuration) {
                count = this.suppressedCount;
                state = State.REACTIVATED;
                this.lastReportTime = now;
                this.suppressedCount = 0;
                this.suppressing = false;
                this.periodCount = 1;
            } else {
                ++this.suppressedCount;
                ++this.periodCount;
                this.suppressing = true;
                count = this.suppressedCount;
                state = State.SUPPRESSED;
            }
        } else if (now - this.lastReportTime > this.nanoWindow) {
            this.periodCount = 1;
            this.suppressedCount = 0;
            this.lastReportTime = now;
            this.suppressing = false;
            state = State.ACTIVE;
            count = 0;
        } else {
            ++this.periodCount;
            if (this.periodCount > this.errorLimit) {
                this.suppressedCount = 1;
                this.lastReportTime = now;
                this.suppressing = true;
                state = State.SUPPRESSED;
                count = 1;
            } else {
                this.suppressedCount = 0;
                this.lastReportTime = now;
                this.suppressing = false;
                state = State.ACTIVE;
                count = 0;
            }
        }
        return new Result(state, count);
    }

    public static enum State {
        SUPPRESSED,
        REACTIVATED,
        ACTIVE;

    }

    public static class Result {
        private State state;
        private int suppressedCount;

        public Result(State state, int suppressedCount) {
            this.state = state;
            this.suppressedCount = suppressedCount;
        }

        public State getState() {
            return this.state;
        }

        public int getSuppressedCount() {
            return this.suppressedCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.getSuppressedCount() == result.getSuppressedCount() && this.getState() == result.getState();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.getState(), this.getSuppressedCount()});
        }

        public String toString() {
            return String.valueOf((Object)this.getState()) + "(" + this.getSuppressedCount() + ")";
        }
    }
}

