/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import com.senzing.g2.engine.G2Fallible;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import java.util.Map;

public class LoggingUtilities {
    private static final Object STDOUT_MONITOR = new Object();
    private static final Object STDERR_MONITOR = new Object();
    private static final String LOG_DATE_PATTERN = "yyyy-MM-dd HH:mm:ss,SSS";
    private static final ZoneId LOG_DATE_ZONE = ZoneId.of("UTC");
    private static final DateTimeFormatter LOG_DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss,SSS").withZone(LOG_DATE_ZONE);
    public static final String BASE_PRODUCT_ID = "5025";
    public static final String DEBUG_SYSTEM_PROPERTY = "com.senzing.debug";
    private static final ThreadLocal<Long> LAST_LOGGED_EXCEPTION = new ThreadLocal();
    private static final Map<String, String> PRODUCT_ID_MAP = new LinkedHashMap<String, String>();

    private LoggingUtilities() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setProductIdForPackage(String packageName, String productId) {
        Map<String, String> map = PRODUCT_ID_MAP;
        synchronized (map) {
            PRODUCT_ID_MAP.put(packageName, productId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProductIdForPackage(String packageName) {
        Map<String, String> map = PRODUCT_ID_MAP;
        synchronized (map) {
            int index;
            do {
                if (PRODUCT_ID_MAP.containsKey(packageName)) {
                    return PRODUCT_ID_MAP.get(packageName);
                }
                int prefixLength = "com.senzing.".length();
                if (!packageName.startsWith("com.senzing.") || packageName.length() <= prefixLength) continue;
                index = packageName.indexOf(".", prefixLength);
                if (index < 0) {
                    index = packageName.length();
                }
                return packageName.substring(prefixLength, index);
            } while ((index = packageName.lastIndexOf(46)) > 0 && index != packageName.length() - 1 && (packageName = packageName.substring(0, index)).length() > 0 && !packageName.equals("com.senzing"));
            return BASE_PRODUCT_ID;
        }
    }

    public static boolean isDebugLogging() {
        String value = System.getProperty(DEBUG_SYSTEM_PROPERTY);
        if (value == null) {
            return false;
        }
        return value.trim().equalsIgnoreCase(Boolean.TRUE.toString());
    }

    public static void logError(Object ... lines) {
        LoggingUtilities.log(System.err, STDERR_MONITOR, "ERROR", lines, null);
    }

    public static void logError(Throwable throwable, Object ... lines) {
        LoggingUtilities.log(System.err, STDERR_MONITOR, "ERROR", lines, throwable);
    }

    public static void logWarning(Object ... lines) {
        LoggingUtilities.log(System.err, STDERR_MONITOR, "WARNING", lines, null);
    }

    public static void logWarning(Throwable throwable, Object ... lines) {
        LoggingUtilities.log(System.err, STDERR_MONITOR, "WARNING", lines, throwable);
    }

    public static void logInfo(Object ... lines) {
        LoggingUtilities.log(System.out, STDOUT_MONITOR, "INFO", lines, null);
    }

    public static void logDebug(Object ... lines) {
        if (!LoggingUtilities.isDebugLogging()) {
            return;
        }
        LoggingUtilities.log(System.out, STDOUT_MONITOR, "DEBUG", lines, null);
    }

    public static void debugLog(String ... lines) {
        if (!LoggingUtilities.isDebugLogging()) {
            return;
        }
        LoggingUtilities.log(System.out, STDOUT_MONITOR, "DEBUG", lines, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(PrintStream ps, Object monitor, String logType, Object[] lines, Throwable throwable) {
        Thread currentThread = Thread.currentThread();
        StackTraceElement[] stackTrace = currentThread.getStackTrace();
        StackTraceElement caller = stackTrace[3];
        String callingClass = caller.getClassName();
        int index = callingClass.lastIndexOf(".");
        String packageName = callingClass.substring(0, index);
        callingClass = callingClass.substring(index + 1);
        String productId = LoggingUtilities.getProductIdForPackage(packageName);
        StringBuilder sb = new StringBuilder();
        String timestamp = LOG_DATE_FORMATTER.format(Instant.now().atZone(LOG_DATE_ZONE));
        sb.append(timestamp).append(" senzing-").append(productId).append(" (").append(logType).append(")").append(" [").append(Thread.currentThread().getId()).append("|").append(callingClass).append(".").append(caller.getMethodName()).append(":").append(caller.getLineNumber()).append("] ").append(LoggingUtilities.multilineFormat(lines));
        if (throwable != null) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            throwable.printStackTrace(pw);
            sb.append(sw.toString());
        }
        Object object = monitor;
        synchronized (object) {
            ps.print(sb);
            ps.flush();
        }
    }

    public static String formatStackTrace(StackTraceElement[] stackTrace) {
        if (stackTrace == null) {
            return null;
        }
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (StackTraceElement elem : stackTrace) {
            pw.println(LoggingUtilities.formatStackTrace(elem));
        }
        return sw.toString();
    }

    public static String formatStackTrace(StackTraceElement elem) {
        StringBuilder sb = new StringBuilder();
        sb.append("        at ");
        if (elem == null) {
            sb.append("[unknown: null]");
            return sb.toString();
        }
        String moduleName = elem.getModuleName();
        if (moduleName != null && moduleName.length() > 0) {
            sb.append(moduleName).append("/");
        }
        sb.append(elem.getClassName());
        sb.append(".");
        sb.append(elem.getMethodName());
        sb.append("(");
        String fileName = elem.getFileName();
        sb.append(fileName == null ? "[unknown file]" : fileName);
        sb.append(":");
        int lineNumber = elem.getLineNumber();
        if (lineNumber < 0) {
            sb.append("[unknown line]");
        } else {
            sb.append(lineNumber);
        }
        sb.append(")");
        return sb.toString();
    }

    public static String multilineFormat(Object ... lines) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        for (Object line : lines) {
            pw.println(String.valueOf(line));
        }
        pw.flush();
        return sw.toString();
    }

    public static String formatError(String operation, G2Fallible fallible) {
        return LoggingUtilities.formatError(operation, fallible, true);
    }

    public static String formatError(String operation, G2Fallible fallible, boolean includeDetails) {
        int errorCode = fallible.getLastExceptionCode();
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println();
        pw.println("Operation Failed : " + operation);
        pw.println("Error Code       : " + errorCode);
        if (includeDetails) {
            String message = fallible.getLastException();
            pw.println("Reason           : " + message);
        }
        pw.println();
        pw.flush();
        return sw.toString();
    }

    public static void logError(String operation, G2Fallible fallible) {
        LoggingUtilities.logError(operation, fallible, true);
    }

    public static void logError(String operation, G2Fallible fallible, boolean includeDetails) {
        String message = LoggingUtilities.formatError(operation, fallible, includeDetails);
        System.err.println(message);
    }

    private static Long throwableToLong(Throwable t) {
        if (t == null) {
            return null;
        }
        if (t.getClass() == RuntimeException.class && t.getCause() != null) {
            t = t.getCause();
        }
        long hash1 = System.identityHashCode(t);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.flush();
        long hash2 = sw.toString().hashCode();
        return hash1 << 32 | hash2;
    }

    public static boolean isLastLoggedException(Throwable t) {
        if (t == null) {
            return false;
        }
        if (LAST_LOGGED_EXCEPTION.get() == null) {
            return false;
        }
        long value = LoggingUtilities.throwableToLong(t);
        return LAST_LOGGED_EXCEPTION.get() == value;
    }

    public static void setLastLoggedException(Throwable t) {
        LAST_LOGGED_EXCEPTION.set(LoggingUtilities.throwableToLong(t));
    }

    public static <T extends Throwable> void setLastLoggedAndThrow(T t) throws T {
        LoggingUtilities.setLastLoggedException(t);
        throw t;
    }

    public static <T extends Throwable> T logOnceAndThrow(T t) throws T {
        if (!LoggingUtilities.isLastLoggedException(t)) {
            t.printStackTrace();
        }
        LoggingUtilities.setLastLoggedAndThrow(t);
        return null;
    }
}

