/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

public enum OperatingSystemFamily {
    WINDOWS,
    MAC_OS,
    UNIX;

    public static final OperatingSystemFamily RUNTIME_OS_FAMILY;

    public boolean isWindows() {
        return this == WINDOWS;
    }

    public boolean isMacOS() {
        return this == MAC_OS;
    }

    public boolean isUnix() {
        return this == UNIX;
    }

    static {
        try {
            OperatingSystemFamily osFamily = null;
            String osName = System.getProperty("os.name");
            String lowerOSName = osName.toLowerCase().trim();
            osFamily = lowerOSName.startsWith("windows") ? WINDOWS : (lowerOSName.startsWith("mac") || lowerOSName.indexOf("darwin") >= 0 ? MAC_OS : UNIX);
            RUNTIME_OS_FAMILY = osFamily;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new ExceptionInInitializerError(e);
        }
    }
}

