/*
 * Decompiled with CFR 0.152.
 */
package com.senzing.util;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

public class ThreadJoinerPool
implements AutoCloseable {
    private final List<Joiner> joiners = new LinkedList<Joiner>();
    private final List<Joiner> allJoiners;
    private boolean closed;

    public ThreadJoinerPool(int poolSize) {
        this.allJoiners = new ArrayList<Joiner>(poolSize);
        this.closed = false;
        for (int index = 0; index < poolSize; ++index) {
            Joiner joiner = new Joiner();
            this.joiners.add(joiner);
            this.allJoiners.add(joiner);
            joiner.start();
        }
    }

    public void join(Thread thread) {
        this.join(thread, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join(Thread thread, PostJoinCallback callback) {
        Joiner joiner = null;
        List<Joiner> list = this.joiners;
        synchronized (list) {
            while (this.joiners.size() == 0 && !this.closed) {
                try {
                    this.joiners.wait(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.joiners.size() > 0) {
                joiner = this.joiners.remove(0);
            }
        }
        if (joiner == null) {
            throw new IllegalStateException("This instance already destroyed -- cannot join thread.");
        }
        joiner.join(thread, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doClose() {
        List<Joiner> list = this.joiners;
        synchronized (list) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.joiners.notifyAll();
        }
        this.allJoiners.forEach(joiner -> {
            Joiner joiner2 = joiner;
            synchronized (joiner2) {
                joiner.notifyAll();
            }
        });
    }

    public void joinAndClose() {
        this.doClose();
        this.allJoiners.forEach(joiner -> {
            try {
                joiner.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        });
    }

    @Override
    public void close() {
        this.doClose();
        this.allJoiners.forEach(joiner -> {
            if (joiner.isAlive()) {
                joiner.interrupt();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosed() {
        List<Joiner> list = this.joiners;
        synchronized (list) {
            return this.closed;
        }
    }

    private class Joiner
    extends Thread {
        private Thread currentThread = null;
        private PostJoinCallback callback = null;

        private Joiner() {
        }

        private synchronized void join(Thread thread, PostJoinCallback callback) {
            if (this.currentThread != null) {
                throw new IllegalStateException("Cannot join a thread while one is pending.");
            }
            this.currentThread = thread;
            this.callback = callback;
            this.notifyAll();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ThreadJoinerPool pool = ThreadJoinerPool.this;
            while (!pool.isClosed()) {
                block14: {
                    Joiner joiner = this;
                    synchronized (joiner) {
                        if (this.currentThread == null) {
                            try {
                                this.wait(15000L);
                            }
                            catch (InterruptedException ignore) {
                                continue;
                            }
                        }
                        if (this.currentThread == null) {
                            continue;
                        }
                    }
                    Thread thread = this.currentThread;
                    PostJoinCallback postJoin = this.callback;
                    this.currentThread = null;
                    this.callback = null;
                    try {
                        thread.join();
                        if (postJoin != null) {
                            postJoin.onJoined(thread);
                        }
                    }
                    catch (InterruptedException e) {
                        if (!pool.isClosed()) break block14;
                        return;
                    }
                }
                List<Joiner> list = pool.joiners;
                synchronized (list) {
                    pool.joiners.add(this);
                    pool.joiners.notifyAll();
                }
            }
        }
    }

    public static interface PostJoinCallback<T extends Thread> {
        public void onJoined(T var1);
    }
}

