/*
 * Decompiled with CFR 0.152.
 */
package com.seoduct.logging;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.seoduct.logging.Attachment;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Message {
    private String text;
    private String username;
    private String channel;
    @JsonProperty(value="icon_emoji")
    private String iconEmoji;
    private List<Attachment> attachments = Collections.EMPTY_LIST;

    public static MessageBuilder builder() {
        return new MessageBuilder();
    }

    private Message() {
    }

    private Message(String text, String username, String channel, String iconEmoji, List<Attachment> attachments) {
        this.text = text;
        this.username = username;
        this.channel = channel;
        this.iconEmoji = iconEmoji;
        this.attachments = attachments;
    }

    public String getText() {
        return this.text;
    }

    public String getUsername() {
        return this.username;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public List<Attachment> getAttachments() {
        return this.attachments;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Message)) {
            return false;
        }
        Message other = (Message)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$text = this.getText();
        String other$text = other.getText();
        if (this$text == null ? other$text != null : !this$text.equals(other$text)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        String this$iconEmoji = this.getIconEmoji();
        String other$iconEmoji = other.getIconEmoji();
        if (this$iconEmoji == null ? other$iconEmoji != null : !this$iconEmoji.equals(other$iconEmoji)) {
            return false;
        }
        List<Attachment> this$attachments = this.getAttachments();
        List<Attachment> other$attachments = other.getAttachments();
        return !(this$attachments == null ? other$attachments != null : !((Object)this$attachments).equals(other$attachments));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Message;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $text = this.getText();
        result = result * 59 + ($text == null ? 43 : $text.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        String $iconEmoji = this.getIconEmoji();
        result = result * 59 + ($iconEmoji == null ? 43 : $iconEmoji.hashCode());
        List<Attachment> $attachments = this.getAttachments();
        result = result * 59 + ($attachments == null ? 43 : ((Object)$attachments).hashCode());
        return result;
    }

    public String toString() {
        return "Message(text=" + this.getText() + ", username=" + this.getUsername() + ", channel=" + this.getChannel() + ", iconEmoji=" + this.getIconEmoji() + ", attachments=" + this.getAttachments() + ")";
    }

    public static class MessageBuilder {
        private String text;
        private String username;
        private String channel;
        private String iconEmoji;
        private ArrayList<Attachment> attachments;

        MessageBuilder() {
        }

        public MessageBuilder text(String text) {
            this.text = text;
            return this;
        }

        public MessageBuilder username(String username) {
            this.username = username;
            return this;
        }

        public MessageBuilder channel(String channel) {
            this.channel = channel;
            return this;
        }

        public MessageBuilder iconEmoji(String iconEmoji) {
            this.iconEmoji = iconEmoji;
            return this;
        }

        public MessageBuilder attachment(Attachment attachment) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.add(attachment);
            return this;
        }

        public MessageBuilder attachments(Collection<? extends Attachment> attachments) {
            if (this.attachments == null) {
                this.attachments = new ArrayList();
            }
            this.attachments.addAll(attachments);
            return this;
        }

        public MessageBuilder clearAttachments() {
            if (this.attachments != null) {
                this.attachments.clear();
            }
            return this;
        }

        public Message build() {
            List<Object> attachments;
            switch (this.attachments == null ? 0 : this.attachments.size()) {
                case 0: {
                    attachments = Collections.emptyList();
                    break;
                }
                case 1: {
                    attachments = Collections.singletonList(this.attachments.get(0));
                    break;
                }
                default: {
                    attachments = Collections.unmodifiableList(new ArrayList<Attachment>(this.attachments));
                }
            }
            return new Message(this.text, this.username, this.channel, this.iconEmoji, attachments);
        }

        public String toString() {
            return "Message.MessageBuilder(text=" + this.text + ", username=" + this.username + ", channel=" + this.channel + ", iconEmoji=" + this.iconEmoji + ", attachments=" + this.attachments + ")";
        }
    }
}

