/*
 * Decompiled with CFR 0.152.
 */
package com.seoduct.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Layout;
import ch.qos.logback.core.UnsynchronizedAppenderBase;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.seoduct.logging.Attachment;
import com.seoduct.logging.Color;
import com.seoduct.logging.DefaultSlackLayout;
import com.seoduct.logging.Message;
import java.io.IOException;
import okhttp3.Call;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class SlackAppender
extends UnsynchronizedAppenderBase<ILoggingEvent> {
    private String webhookUri;
    private String username;
    private String channel;
    private String iconEmoji;
    private Layout<ILoggingEvent> layout = new DefaultSlackLayout();

    protected void append(ILoggingEvent event) {
        try {
            RequestBody request = this.convertToRequestBody(event);
            this.executeRequest(request);
        }
        catch (IOException e) {
            this.addError("Error posting log to Slack: " + event, e);
        }
    }

    private Response executeRequest(RequestBody request) throws IOException {
        OkHttpClient okHttpClient = new OkHttpClient();
        Call call = okHttpClient.newCall(new Request.Builder().url(this.webhookUri).post(request).build());
        Response response = call.execute();
        response.close();
        return response;
    }

    private RequestBody convertToRequestBody(ILoggingEvent event) throws JsonProcessingException {
        String text = this.layout.doLayout((Object)event);
        Message.MessageBuilder message = Message.builder().username(this.username).channel(this.channel).iconEmoji(this.iconEmoji).attachment(new Attachment(text, this.getColor(event.getLevel())));
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (byte[])new ObjectMapper().writeValueAsBytes((Object)message.build()));
    }

    private Color getColor(Level level) {
        switch (level.levelInt) {
            case 40000: {
                return Color.RED;
            }
            case 30000: {
                return Color.YELLOW;
            }
        }
        return Color.GREEN;
    }

    public void setWebhookUri(String webhookUri) {
        this.webhookUri = webhookUri;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setChannel(String channel) {
        this.channel = channel;
    }

    public void setIconEmoji(String iconEmoji) {
        this.iconEmoji = iconEmoji;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public String getWebhookUri() {
        return this.webhookUri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getChannel() {
        return this.channel;
    }

    public String getIconEmoji() {
        return this.iconEmoji;
    }

    public Layout<ILoggingEvent> getLayout() {
        return this.layout;
    }
}

