/*
 * Decompiled with CFR 0.152.
 */
package com.seomse.crypto;

import com.seomse.crypto.HashConfusionString;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class StringCrypto {
    private static final char[] KEY_CHAR_ARRAY = new char[]{'x', 'y', '2', 'Z', 'a', 'C', 'D', 'I', 'J', 'K', 'L', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', '6', '5', 'v', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', '9', '8', '7', '4', '0', '1', 'b', 'c', 'd', 'e', 'f', 'w', 'z', 'H', 'B', 'M', 'N', 'O', 'P', 'A', 'E', 'F', 'G'};
    private static final StringCrypto DEFAULT_INSTANCE = new StringCrypto(KEY_CHAR_ARRAY);
    private final char[] keyCharArray;
    private Map<Character, Integer> lengthMap;
    private Map<Integer, char[]> charMap;
    private final int minLength;
    private final int maxLength;
    private int keyRandomLength;

    public static String encryption(String str) {
        return DEFAULT_INSTANCE.enc(str);
    }

    public static String decryption(String str) {
        return DEFAULT_INSTANCE.dec(str);
    }

    public StringCrypto(char[] keyCharArray) {
        this.keyCharArray = keyCharArray;
        this.minLength = Math.min(keyCharArray.length, 3);
        this.maxLength = Math.min(keyCharArray.length, 16);
        this.init();
    }

    public StringCrypto(char[] keyCharArray, int min, int max) {
        this.keyCharArray = keyCharArray;
        this.minLength = min;
        this.maxLength = max;
        this.init();
    }

    private void init() {
        int i;
        this.lengthMap = new HashMap<Character, Integer>();
        this.charMap = new HashMap<Integer, char[]>();
        HashMap tempMap = new HashMap();
        for (int i2 = this.minLength; i2 <= this.maxLength; ++i2) {
            tempMap.put(i2, new ArrayList());
        }
        int length = this.minLength;
        for (i = 0; i < this.keyCharArray.length; ++i) {
            this.lengthMap.put(Character.valueOf(this.keyCharArray[i]), length);
            ((List)tempMap.get(length)).add(Character.valueOf(this.keyCharArray[i]));
            if (++length <= this.maxLength) continue;
            length = this.minLength;
        }
        for (i = this.minLength; i <= this.maxLength; ++i) {
            List list = (List)tempMap.get(i);
            char[] array = new char[list.size()];
            for (int j = 0; j < array.length; ++j) {
                array[j] = ((Character)list.get(j)).charValue();
            }
            this.charMap.put(i, array);
            list.clear();
        }
        tempMap.clear();
        this.keyRandomLength = this.maxLength - this.minLength;
    }

    public String enc(String str) {
        try {
            Random random = new Random();
            int keyLength = random.nextInt(this.keyRandomLength) + this.minLength;
            StringBuilder keyBuilder = new StringBuilder();
            for (int i = 0; i < keyLength; ++i) {
                keyBuilder.append(this.keyCharArray[random.nextInt(this.keyCharArray.length)]);
            }
            StringBuilder result = new StringBuilder();
            char[] lengthCharArray = this.charMap.get(keyLength);
            result.append(lengthCharArray[random.nextInt(lengthCharArray.length)]);
            result.append((CharSequence)keyBuilder);
            String key = HashConfusionString.get("MD5", keyBuilder.toString());
            result.append(StringCrypto.enc(key, str));
            return result.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String dec(String str) {
        try {
            char lengthChar = str.charAt(0);
            int length = this.lengthMap.get(Character.valueOf(lengthChar));
            int next = length + 1;
            String keyData = str.substring(1, next);
            String key = HashConfusionString.get("MD5", keyData);
            String encData = str.substring(next);
            return StringCrypto.dec(key, encData);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String enc(String key, String value) {
        try {
            byte[] keyBytes = StringCrypto.makeKeyByte(key);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(keyBytes);
            cipher.init(1, (Key)keySpec, ivSpec);
            byte[] results = cipher.doFinal(value.getBytes(StandardCharsets.UTF_8));
            Base64.Encoder encoder = Base64.getEncoder();
            return new String(encoder.encode(results));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String dec(String key, String enc) {
        try {
            byte[] keyBytes = StringCrypto.makeKeyByte(key);
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            SecretKeySpec keySpec = new SecretKeySpec(keyBytes, "AES");
            IvParameterSpec ivSpec = new IvParameterSpec(keyBytes);
            cipher.init(2, (Key)keySpec, ivSpec);
            Base64.Decoder decoder = Base64.getDecoder();
            byte[] encByte = decoder.decode(enc);
            byte[] results = cipher.doFinal(encByte);
            return new String(results, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static byte[] makeKeyByte(String key) {
        byte[] keyBytes = new byte[16];
        byte[] b = key.getBytes(StandardCharsets.UTF_8);
        int len = b.length;
        if (len > keyBytes.length) {
            len = keyBytes.length;
        }
        System.arraycopy(b, 0, keyBytes, 0, len);
        return keyBytes;
    }

    public static char[] makeRandomCharArray() {
        char[] sortChars = Arrays.copyOf(KEY_CHAR_ARRAY, KEY_CHAR_ARRAY.length);
        Arrays.sort(sortChars);
        Random random = new Random();
        LinkedList<Character> list = new LinkedList<Character>();
        for (char ch : sortChars) {
            list.add(Character.valueOf(ch));
        }
        for (int i = 0; i < sortChars.length; ++i) {
            sortChars[i] = ((Character)list.remove(random.nextInt(list.size()))).charValue();
        }
        return sortChars;
    }
}

