/*
 * Decompiled with CFR 0.152.
 */
package com.seovic.pof;

import com.seovic.pof.PofUtil;
import com.seovic.pof.PortableTypeLoader;
import com.seovic.pof.PortableTypeSerializer;
import com.seovic.pof.TestBinaryEntry;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.EnumPofSerializer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.io.pof.SimplePofContext;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.Color;

public class PofUtilTest {
    private SimplePofContext ctx;
    private ClassLoader loader = new PortableTypeLoader();

    @Before
    public void setup() throws Exception {
        this.ctx = new SimplePofContext();
        this.ctx.registerUserType(1, this.loader.loadClass("test.v3.Pet"), (PofSerializer)new PortableTypeSerializer(1, this.loader.loadClass("test.v3.Pet")));
        this.ctx.registerUserType(2, this.loader.loadClass("test.v3.Dog"), (PofSerializer)new PortableTypeSerializer(2, this.loader.loadClass("test.v3.Dog")));
        this.ctx.registerUserType(3, this.loader.loadClass("test.v3.Animal"), (PofSerializer)new PortableTypeSerializer(3, this.loader.loadClass("test.v3.Animal")));
        this.ctx.registerUserType(4, this.loader.loadClass("test.v3.Zoo"), (PofSerializer)new PortableTypeSerializer(4, this.loader.loadClass("test.v3.Zoo")));
        this.ctx.registerUserType(5, this.loader.loadClass("test.Color"), (PofSerializer)new EnumPofSerializer());
        this.ctx.registerUserType(10, this.loader.loadClass("test.v3.Address"), (PofSerializer)new PortableTypeSerializer(10, this.loader.loadClass("test.v3.Address")));
        this.ctx.registerUserType(11, this.loader.loadClass("test.Person"), (PofSerializer)new PortableObjectSerializer(11));
    }

    @Test
    public void testSimplePath() throws Exception {
        Class<?> dogClass = this.loader.loadClass("test.v3.Dog");
        Constructor<?> dogCtor = dogClass.getConstructor(String.class, Integer.TYPE, String.class, Color.class);
        Object dog = dogCtor.newInstance(new Object[]{"Nadia", 10, "Boxer", Color.BRINDLE});
        Binary binDog = ExternalizableHelper.toBinary(dog, (Serializer)this.ctx);
        TestBinaryEntry entry = new TestBinaryEntry(null, binDog, (PofContext)this.ctx);
        Assert.assertEquals((Object)"Nadia", (Object)PofUtil.getPofExtractor(dogClass, (String)"name").extractFromEntry((Map.Entry)((Object)entry)));
        Assert.assertEquals((Object)10, (Object)PofUtil.getPofExtractor(dogClass, (String)"age").extractFromEntry((Map.Entry)((Object)entry)));
        PofUtil.getPofUpdater(dogClass, (String)"age").updateEntry((Map.Entry)((Object)entry), (Object)9);
        Object dog2 = ExternalizableHelper.fromBinary((Binary)entry.getBinaryValue(), (Serializer)this.ctx);
        Method getAge = this.loader.loadClass("test.v3.Pet").getDeclaredMethod("getAge", new Class[0]);
        Assert.assertEquals((Object)9, (Object)getAge.invoke(dog2, new Object[0]));
    }

    @Test
    public void testComplexPath() throws Exception {
        Class<?> addressClass = this.loader.loadClass("test.v3.Address");
        Constructor<?> addressCtor = addressClass.getConstructor(String.class, String.class, String.class);
        Object address = addressCtor.newInstance("123 Main St", "Portland", "Oregon");
        Class<?> zooClass = this.loader.loadClass("test.v3.Zoo");
        Constructor<?> zooCtor = zooClass.getConstructor(addressClass);
        Object zoo = zooCtor.newInstance(address);
        Binary binZoo = ExternalizableHelper.toBinary(zoo, (Serializer)this.ctx);
        TestBinaryEntry entry = new TestBinaryEntry(null, binZoo, (PofContext)this.ctx);
        Assert.assertEquals((Object)"Portland", (Object)PofUtil.getPofExtractor(zooClass, (String)"address.city").extractFromEntry((Map.Entry)((Object)entry)));
        Assert.assertEquals((Object)"Oregon", (Object)PofUtil.getPofExtractor(zooClass, (String)"address.state").extractFromEntry((Map.Entry)((Object)entry)));
        PofUtil.getPofUpdater(zooClass, (String)"address.state").updateEntry((Map.Entry)((Object)entry), (Object)"OR");
        Object zoo2 = ExternalizableHelper.fromBinary((Binary)entry.getBinaryValue(), (Serializer)this.ctx);
        Method getAddress = zooClass.getDeclaredMethod("getAddress", new Class[0]);
        Method getState = addressClass.getDeclaredMethod("getState", new Class[0]);
        Assert.assertEquals((Object)"OR", (Object)getState.invoke(getAddress.invoke(zoo2, new Object[0]), new Object[0]));
    }
}

