/*
 * Decompiled with CFR 0.152.
 */
package com.seovic.pof;

import com.seovic.pof.EvolvableObject;
import com.seovic.pof.PortableTypeLoader;
import com.seovic.pof.PortableTypeSerializer;
import com.seovic.pof.TestBinaryEntry;
import com.tangosol.io.ReadBuffer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.EnumPofSerializer;
import com.tangosol.io.pof.PofContext;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.SimplePofContext;
import com.tangosol.io.pof.reflect.PofValue;
import com.tangosol.io.pof.reflect.PofValueParser;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.lang.reflect.Constructor;
import java.util.Date;
import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.Color;
import test.DateTypes;

public class PortableTypeGeneratorTest {
    private SimplePofContext ctx;
    private ClassLoader loader = new PortableTypeLoader();
    private Constructor allTypesCtor;
    private Constructor dogCtor;

    @Before
    public void setup() throws Exception {
        Class<?> allTypes = this.loader.loadClass("test.AllTypes");
        this.allTypesCtor = allTypes.getConstructor(new Class[0]);
        Class<?> dog = this.loader.loadClass("test.v3.Dog");
        this.dogCtor = dog.getConstructor(String.class, Integer.TYPE, String.class, Color.class);
        this.ctx = new SimplePofContext();
        this.ctx.registerUserType(1, this.loader.loadClass("test.v3.Pet"), (PofSerializer)new PortableTypeSerializer(1, this.loader.loadClass("test.v3.Pet")));
        this.ctx.registerUserType(2, dog, (PofSerializer)new PortableTypeSerializer(2, dog));
        this.ctx.registerUserType(3, this.loader.loadClass("test.v3.Animal"), (PofSerializer)new PortableTypeSerializer(3, this.loader.loadClass("test.v3.Animal")));
        this.ctx.registerUserType(5, Color.class, (PofSerializer)new EnumPofSerializer());
        this.ctx.registerUserType(10, allTypes, (PofSerializer)new PortableTypeSerializer(10, allTypes));
    }

    @Test
    public void testAllTypesRoundTrip() throws Exception {
        DateTypes expected = (DateTypes)this.allTypesCtor.newInstance(new Object[0]);
        Binary binObj = ExternalizableHelper.toBinary((Object)expected, (Serializer)this.ctx);
        DateTypes actual = (DateTypes)ExternalizableHelper.fromBinary((Binary)binObj, (Serializer)this.ctx);
        System.out.println("Expected: " + expected);
        System.out.println("Actual:   " + actual);
        Assert.assertEquals((Object)expected, (Object)actual);
        PortableTypeGeneratorTest.assertDateEquals(expected.getDate(), actual.getDate());
        PortableTypeGeneratorTest.assertTimeEquals(expected.getTime(), actual.getTime());
        PortableTypeGeneratorTest.assertTimeEquals(expected.getTimeWithZone(), actual.getTimeWithZone());
    }

    @Test
    public void testPofNavigator() throws Exception {
        EvolvableObject dog = (EvolvableObject)this.dogCtor.newInstance(new Object[]{"Nadia", 10, "Boxer", Color.BRINDLE});
        System.out.println(dog);
        Binary binDog = ExternalizableHelper.toBinary((Object)dog, (Serializer)this.ctx);
        PofValue pofDog = PofValueParser.parse((ReadBuffer)binDog, (PofContext)this.ctx);
        Assert.assertEquals((Object)"Nadia", (Object)dog.getPofNavigator("name").navigate(pofDog).getString());
        Assert.assertEquals((Object)"Boxer", (Object)dog.getPofNavigator("breed").navigate(pofDog).getString());
        Assert.assertEquals((long)10L, (long)dog.getPofNavigator("age").navigate(pofDog).getInt());
        Assert.assertEquals((Object)((Object)Color.BRINDLE), (Object)dog.getPofNavigator("color").navigate(pofDog).getValue());
    }

    @Test
    public void testPofExtractor() throws Exception {
        EvolvableObject dog = (EvolvableObject)this.dogCtor.newInstance(new Object[]{"Nadia", 10, "Boxer", Color.BRINDLE});
        System.out.println(dog);
        Binary binDog = ExternalizableHelper.toBinary((Object)dog, (Serializer)this.ctx);
        TestBinaryEntry binEntry = new TestBinaryEntry(null, binDog, (PofContext)this.ctx);
        Assert.assertEquals((Object)"Nadia", (Object)dog.getPofExtractor("name").extractFromEntry((Map.Entry)((Object)binEntry)));
        Assert.assertEquals((Object)"Boxer", (Object)dog.getPofExtractor("breed").extractFromEntry((Map.Entry)((Object)binEntry)));
        Assert.assertEquals((Object)10, (Object)dog.getPofExtractor("age").extractFromEntry((Map.Entry)((Object)binEntry)));
        Assert.assertEquals((Object)((Object)Color.BRINDLE), (Object)dog.getPofExtractor("color").extractFromEntry((Map.Entry)((Object)binEntry)));
    }

    private static void assertDateEquals(Date expected, Date actual) {
        Assert.assertEquals((long)expected.getYear(), (long)actual.getYear());
        Assert.assertEquals((long)expected.getMonth(), (long)actual.getMonth());
        Assert.assertEquals((long)expected.getDate(), (long)actual.getDate());
    }

    private static void assertTimeEquals(Date expected, Date actual) {
        Assert.assertEquals((long)expected.getHours(), (long)actual.getHours());
        Assert.assertEquals((long)expected.getMinutes(), (long)actual.getMinutes());
        Assert.assertEquals((long)expected.getSeconds(), (long)actual.getSeconds());
        Assert.assertEquals((long)(expected.getTime() % 1000L), (long)(actual.getTime() % 1000L));
        Assert.assertEquals((long)expected.getTimezoneOffset(), (long)actual.getTimezoneOffset());
    }
}

