/*
 * Decompiled with CFR 0.152.
 */
package com.seovic.pof;

import com.seovic.pof.PortableTypeLoader;
import com.seovic.pof.PortableTypeSerializer;
import com.tangosol.io.DefaultSerializer;
import com.tangosol.io.Serializer;
import com.tangosol.io.pof.EnumPofSerializer;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PortableObjectSerializer;
import com.tangosol.io.pof.SimplePofContext;
import com.tangosol.util.Binary;
import com.tangosol.util.ExternalizableHelper;
import java.lang.reflect.Constructor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import test.Color;
import test.portable.Animal;
import test.v1.Dog;
import test.v1.Pet;

public class PortableTypeSerializerTest {
    private SimplePofContext portable;
    private SimplePofContext v1;
    private SimplePofContext v2;
    private SimplePofContext v3;
    private ClassLoader v3loader = new PortableTypeLoader();
    private Constructor v3DogCtor;
    private Constructor emptyClassCtor;

    @Before
    public void setup() throws Exception {
        this.portable = new SimplePofContext();
        this.portable.registerUserType(1, test.portable.Pet.class, (PofSerializer)new PortableObjectSerializer(1));
        this.portable.registerUserType(2, test.portable.Dog.class, (PofSerializer)new PortableObjectSerializer(2));
        this.portable.registerUserType(3, Animal.class, (PofSerializer)new PortableObjectSerializer(3));
        this.portable.registerUserType(5, Color.class, (PofSerializer)new EnumPofSerializer());
        this.v1 = new SimplePofContext();
        this.v1.registerUserType(1, Pet.class, (PofSerializer)new PortableTypeSerializer(1, Pet.class));
        this.v1.registerUserType(2, Dog.class, (PofSerializer)new PortableTypeSerializer(2, Dog.class));
        this.v2 = new SimplePofContext();
        this.v2.registerUserType(1, test.v2.Pet.class, (PofSerializer)new PortableTypeSerializer(1, test.v2.Pet.class));
        this.v2.registerUserType(2, test.v2.Dog.class, (PofSerializer)new PortableTypeSerializer(2, test.v2.Dog.class));
        this.v2.registerUserType(3, test.v2.Animal.class, (PofSerializer)new PortableTypeSerializer(3, test.v2.Animal.class));
        this.v2.registerUserType(5, Color.class, (PofSerializer)new EnumPofSerializer());
        this.v3 = new SimplePofContext();
        Class<?> v3Dog = this.v3loader.loadClass("test.v3.Dog");
        this.v3DogCtor = v3Dog.getConstructor(String.class, Integer.TYPE, String.class, Color.class);
        this.v3.registerUserType(1, this.v3loader.loadClass("test.v3.Pet"), (PofSerializer)new PortableTypeSerializer(1, this.v3loader.loadClass("test.v3.Pet")));
        this.v3.registerUserType(2, v3Dog, (PofSerializer)new PortableTypeSerializer(2, v3Dog));
        this.v3.registerUserType(3, this.v3loader.loadClass("test.v3.Animal"), (PofSerializer)new PortableTypeSerializer(3, this.v3loader.loadClass("test.v3.Animal")));
        this.v3.registerUserType(5, Color.class, (PofSerializer)new EnumPofSerializer());
        Class<?> emptyClass = this.v3loader.loadClass("test.EmptyClass");
        this.emptyClassCtor = emptyClass.getConstructor(new Class[0]);
        this.v3.registerUserType(6, emptyClass, (PofSerializer)new PortableTypeSerializer(6, emptyClass));
    }

    @Test
    public void testRoundTripV1() throws Exception {
        Dog dog = new Dog("Nadia", "Boxer");
        System.out.println((Object)dog);
        Binary binDog = ExternalizableHelper.toBinary((Object)((Object)dog), (Serializer)this.v1);
        Assert.assertEquals((Object)((Object)dog), (Object)ExternalizableHelper.fromBinary((Binary)binDog, (Serializer)this.v1));
    }

    @Test
    public void testRoundTripV2() throws Exception {
        test.v2.Dog dog = new test.v2.Dog("Nadia", 10, "Boxer", Color.BRINDLE);
        System.out.println((Object)dog);
        Binary binDog = ExternalizableHelper.toBinary((Object)((Object)dog), (Serializer)this.v2);
        Assert.assertEquals((Object)((Object)dog), (Object)ExternalizableHelper.fromBinary((Binary)binDog, (Serializer)this.v2));
    }

    @Test
    public void testRoundTripV3() throws Exception {
        Object dog = this.v3DogCtor.newInstance(new Object[]{"Nadia", 10, "Boxer", Color.BRINDLE});
        System.out.println(dog);
        Binary binDog = ExternalizableHelper.toBinary(dog, (Serializer)this.v3);
        Assert.assertEquals(dog, (Object)ExternalizableHelper.fromBinary((Binary)binDog, (Serializer)this.v3));
    }

    @Test
    public void testEvolution() throws Exception {
        test.v2.Dog dogV2 = new test.v2.Dog("Nadia", 10, "Boxer", Color.BRINDLE);
        System.out.println((Object)dogV2);
        Binary binDogV2 = ExternalizableHelper.toBinary((Object)((Object)dogV2), (Serializer)this.v2);
        Dog dogV1 = (Dog)((Object)ExternalizableHelper.fromBinary((Binary)binDogV2, (Serializer)this.v1));
        System.out.println((Object)dogV1);
        Binary binDogV1 = ExternalizableHelper.toBinary((Object)((Object)dogV1), (Serializer)this.v1);
        Object dog = ExternalizableHelper.fromBinary((Binary)binDogV1, (Serializer)this.v2);
        System.out.println(dog);
        Assert.assertEquals((Object)((Object)dogV2), (Object)dog);
    }

    @Test
    public void testRoundTripEmptyClass() throws Exception {
        Object ec = this.emptyClassCtor.newInstance(new Object[0]);
        Binary bin = ExternalizableHelper.toBinary(ec, (Serializer)this.v3);
        Assert.assertNotNull((Object)ExternalizableHelper.fromBinary((Binary)bin, (Serializer)this.v3));
    }

    @Test
    public void testPerformance() throws Exception {
        Binary binary;
        int i;
        int ITERATIONS = 100000;
        test.portable.Dog expected = new test.portable.Dog("Nadia", 10, "Boxer", Color.BRINDLE);
        Object actual = null;
        for (int i2 = 0; i2 < 100000; ++i2) {
            Binary binary2 = ExternalizableHelper.toBinary((Object)expected, (Serializer)this.portable);
            actual = ExternalizableHelper.fromBinary((Binary)binary2, (Serializer)this.portable);
        }
        long start = System.currentTimeMillis();
        for (int i3 = 0; i3 < 100000; ++i3) {
            Binary binary3 = ExternalizableHelper.toBinary((Object)expected, (Serializer)this.portable);
            actual = ExternalizableHelper.fromBinary((Binary)binary3, (Serializer)this.portable);
        }
        long duration = System.currentTimeMillis() - start;
        System.out.println("PortableObjectSerializer took " + duration + "ms for " + 100000 + " iterations (" + 1.0 * (double)duration / 100000.0 + "ms per object)");
        Assert.assertEquals((Object)expected, (Object)actual);
        DefaultSerializer java = new DefaultSerializer();
        for (i = 0; i < 100000; ++i) {
            binary = ExternalizableHelper.toBinary((Object)expected, (Serializer)java);
            actual = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)java);
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            binary = ExternalizableHelper.toBinary((Object)expected, (Serializer)java);
            actual = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)java);
        }
        duration = System.currentTimeMillis() - start;
        System.out.println("Java serialization took " + duration + "ms for " + 100000 + " iterations (" + 1.0 * (double)duration / 100000.0 + "ms per object)");
        Assert.assertEquals((Object)expected, (Object)actual);
        expected = this.v3DogCtor.newInstance(new Object[]{"Nadia", 10, "Boxer", Color.BRINDLE});
        actual = null;
        for (i = 0; i < 100000; ++i) {
            binary = ExternalizableHelper.toBinary((Object)expected, (Serializer)this.v3);
            actual = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.v3);
        }
        start = System.currentTimeMillis();
        for (i = 0; i < 100000; ++i) {
            binary = ExternalizableHelper.toBinary((Object)expected, (Serializer)this.v3);
            actual = ExternalizableHelper.fromBinary((Binary)binary, (Serializer)this.v3);
        }
        duration = System.currentTimeMillis() - start;
        System.out.println("PortableTypeSerializer took " + duration + "ms for " + 100000 + " iterations (" + 1.0 * (double)duration / 100000.0 + "ms per object)");
        Assert.assertEquals((Object)expected, (Object)actual);
    }
}

