/*
 * Decompiled with CFR 0.152.
 */
package com.seovic.pof;

import com.tangosol.io.Evolvable;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofSerializer;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.util.Binary;
import java.io.IOException;

public abstract class AbstractPofSerializer<T>
implements PofSerializer {
    protected abstract void serializeAttributes(T var1, PofWriter var2) throws IOException;

    protected abstract T createInstance(PofReader var1) throws IOException;

    protected void deserializeAttributes(T obj, PofReader reader) throws IOException {
    }

    public void serialize(PofWriter writer, Object obj) throws IOException {
        Object instance = obj;
        boolean isEvolvable = obj instanceof Evolvable;
        Evolvable evolvable = null;
        if (isEvolvable) {
            evolvable = (Evolvable)obj;
            int dataVersion = Math.max(evolvable.getImplVersion(), evolvable.getDataVersion());
            writer.setVersionId(dataVersion);
        }
        this.serializeAttributes(instance, writer);
        Binary futureData = isEvolvable ? evolvable.getFutureData() : null;
        writer.writeRemainder(futureData);
    }

    public Object deserialize(PofReader reader) throws IOException {
        T instance = this.createInstance(reader);
        boolean isEvolvable = instance instanceof Evolvable;
        Evolvable evolvable = null;
        if (isEvolvable) {
            evolvable = (Evolvable)instance;
            evolvable.setDataVersion(reader.getVersionId());
        }
        this.deserializeAttributes(instance, reader);
        Binary futureData = reader.readRemainder();
        if (isEvolvable) {
            evolvable.setFutureData(futureData);
        }
        return instance;
    }
}

