/*
 * Decompiled with CFR 0.152.
 */
package com.seovic.pof;

import com.seovic.pof.annotations.PortableType;
import com.seovic.pof.annotations.internal.PofIndex;
import com.tangosol.io.pof.reflect.PofNavigator;
import com.tangosol.io.pof.reflect.SimplePofPath;
import com.tangosol.util.Base;
import com.tangosol.util.extractor.PofExtractor;
import com.tangosol.util.extractor.PofUpdater;
import java.lang.reflect.Field;

public abstract class PofUtil {
    public static PofNavigator getPofNavigator(Class clazz, String fieldPath) {
        return PofUtil.getNavigatorAndType(clazz, fieldPath).navigator;
    }

    public static PofExtractor getPofExtractor(Class clazz, String fieldPath) {
        NavigatorAndType nt = PofUtil.getNavigatorAndType(clazz, fieldPath);
        return new PofExtractor(nt.type, nt.navigator);
    }

    public static PofUpdater getPofUpdater(Class clazz, String fieldPath) {
        NavigatorAndType nt = PofUtil.getNavigatorAndType(clazz, fieldPath);
        return new PofUpdater(nt.navigator);
    }

    private static Field findField(Class clazz, String name) {
        while (clazz.isAnnotationPresent(PortableType.class)) {
            try {
                return clazz.getDeclaredField(name);
            }
            catch (NoSuchFieldException e) {
                clazz = clazz.getSuperclass();
            }
        }
        return null;
    }

    private static NavigatorAndType getNavigatorAndType(Class clazz, String fieldPath) {
        String[] fieldNames = Base.parseDelimitedString((String)fieldPath, (char)'.');
        int[] indexes = new int[fieldNames.length * 2];
        int n = 0;
        for (String fieldName : fieldNames) {
            Field field = PofUtil.findField(clazz, fieldName);
            if (field == null) {
                throw new IllegalArgumentException("Class [" + clazz.getName() + "] is not portable type, or the field [" + fieldName + "] does not exist in its hierarchy");
            }
            PofIndex index = field.getAnnotation(PofIndex.class);
            if (index == null) {
                throw new IllegalArgumentException("Field [" + fieldName + "] is not a portable field (@Portable is missing) or the class hasn't been instrumented");
            }
            Class<?> declaringClass = field.getDeclaringClass();
            PortableType type = declaringClass.getAnnotation(PortableType.class);
            indexes[n++] = type.id();
            indexes[n++] = index.value();
            clazz = field.getType();
        }
        return new NavigatorAndType((PofNavigator)new SimplePofPath(indexes), clazz);
    }

    private static class NavigatorAndType {
        private PofNavigator navigator;
        private Class type;

        private NavigatorAndType(PofNavigator navigator, Class type) {
            this.navigator = navigator;
            this.type = type;
        }
    }
}

