/*
 * Decompiled with CFR 0.152.
 */
package com.seovic.pof;

import com.seovic.asm.ClassReader;
import com.seovic.asm.ClassVisitor;
import com.seovic.asm.ClassWriter;
import com.seovic.asm.Label;
import com.seovic.asm.Type;
import com.seovic.asm.commons.Method;
import com.seovic.asm.tree.AnnotationNode;
import com.seovic.asm.tree.ClassNode;
import com.seovic.asm.tree.FieldNode;
import com.seovic.asm.tree.MemberNode;
import com.seovic.asm.tree.MethodNode;
import com.seovic.core.Factory;
import com.seovic.core.io.JAXBMarshaller;
import com.seovic.pof.DateMode;
import com.seovic.pof.PortableTypeSerializer;
import com.seovic.pof.annotations.Portable;
import com.seovic.pof.annotations.PortableArray;
import com.seovic.pof.annotations.PortableDate;
import com.seovic.pof.annotations.PortableList;
import com.seovic.pof.annotations.PortableMap;
import com.seovic.pof.annotations.PortableSet;
import com.seovic.pof.annotations.PortableType;
import com.seovic.pof.annotations.internal.Instrumented;
import com.seovic.pof.annotations.internal.PofIndex;
import com.seovic.pof.internal.PofConfig;
import com.seovic.pof.internal.SerializerType;
import com.seovic.pof.internal.UserType;
import com.seovic.pof.internal.UserTypeList;
import com.seovic.pof.util.AsmUtils;
import com.tangosol.util.Binary;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.lang.instrument.Instrumentation;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.security.ProtectionDomain;
import java.sql.Timestamp;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.PriorityQueue;
import java.util.Queue;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingDeque;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import org.apache.maven.plugin.logging.Log;
import org.slf4j.LoggerFactory;

public class PortableTypeGenerator {
    public static Logger LOG = new ConsoleLogger();
    private static final Type OBJECT_TYPE = Type.getType(Object.class);
    protected static final Class[] PORTABLE_ANNOTATIONS = new Class[]{Portable.class, PortableArray.class, PortableDate.class, PortableList.class, PortableMap.class, PortableSet.class};
    private static final Set<String> MAP_CLASSES = new HashSet<String>(Arrays.asList(Map.class.getName(), ConcurrentMap.class.getName(), ConcurrentNavigableMap.class.getName(), NavigableMap.class.getName(), SortedMap.class.getName(), ConcurrentHashMap.class.getName(), ConcurrentSkipListMap.class.getName(), HashMap.class.getName(), IdentityHashMap.class.getName(), LinkedHashMap.class.getName(), TreeMap.class.getName(), WeakHashMap.class.getName(), Hashtable.class.getName()));
    private static final Set<String> SET_CLASSES = new HashSet<String>(Arrays.asList(Set.class.getName(), SortedSet.class.getName(), NavigableSet.class.getName(), ConcurrentSkipListSet.class.getName(), CopyOnWriteArraySet.class.getName(), HashSet.class.getName(), LinkedHashSet.class.getName(), TreeSet.class.getName()));
    private static final Set<String> LIST_CLASSES = new HashSet<String>(Arrays.asList(List.class.getName(), ArrayList.class.getName(), CopyOnWriteArrayList.class.getName(), LinkedList.class.getName()));
    private static final Set<String> COLLECTION_CLASSES = PortableTypeGenerator.merge(new HashSet<String>(Arrays.asList(Collection.class.getName(), Queue.class.getName(), Deque.class.getName(), BlockingQueue.class.getName(), BlockingDeque.class.getName(), ArrayDeque.class.getName(), ArrayBlockingQueue.class.getName(), ConcurrentLinkedQueue.class.getName(), DelayQueue.class.getName(), LinkedBlockingQueue.class.getName(), LinkedBlockingDeque.class.getName(), PriorityBlockingQueue.class.getName(), PriorityQueue.class.getName(), Stack.class.getName(), SynchronousQueue.class.getName(), Vector.class.getName())), SET_CLASSES, LIST_CLASSES);
    public static boolean DEBUG = false;
    private ClassNode cn;
    private TreeMap<Integer, SortedSet<FieldNode>> properties = new TreeMap();

    private static <T> Set<T> merge(Set<T> ... sets) {
        HashSet<T> result = new HashSet<T>();
        for (Set<T> set : sets) {
            result.addAll(set);
        }
        return result;
    }

    public PortableTypeGenerator(InputStream in) throws IOException {
        ClassReader reader = new ClassReader(in);
        this.cn = new ClassNode();
        reader.accept((ClassVisitor)this.cn, 0);
    }

    public UserType instrumentClass() {
        if (this.isPortableType() && !this.isEnum() && !this.isInstrumented()) {
            LOG.info("Instrumenting portable type " + this.cn.name);
            this.populatePropertyMap();
            this.implementDefaultConstructor();
            this.implementReadExternal();
            this.implementWriteExternal();
            this.cn.visibleAnnotations.add(new AnnotationNode(Type.getDescriptor(Instrumented.class)));
            Type serializerClass = this.getPofSerializer();
            SerializerType serializerType = serializerClass.getClassName().equals(PortableTypeSerializer.class.getName()) ? null : new SerializerType(serializerClass.getClassName(), null);
            return new UserType(BigInteger.valueOf(this.getTypeId()), this.cn.name.replace("/", "."), serializerType);
        }
        return null;
    }

    private int getTypeId() {
        return (Integer)this.getAnnotationAttribute(this.getAnnotation((MemberNode)this.cn, PortableType.class), "id");
    }

    private Type getPofSerializer() {
        return (Type)this.getAnnotationAttribute(this.getAnnotation((MemberNode)this.cn, PortableType.class), "serializer");
    }

    public byte[] getClassBytes() {
        ClassWriter writer = new ClassWriter(1);
        this.cn.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    public void writeClass(OutputStream out) throws IOException {
        out.write(this.getClassBytes());
    }

    private void populatePropertyMap() {
        int count = 0;
        for (FieldNode fn : this.cn.fields) {
            AnnotationNode an = this.getAnnotation((MemberNode)fn, PORTABLE_ANNOTATIONS);
            if (an == null) continue;
            this.addProperty((Integer)this.getAnnotationAttribute(an, "since"), fn);
            ++count;
        }
        LOG.debug("Found " + count + " fields across " + this.properties.size() + " class version(s)");
    }

    private void addProperty(int version, FieldNode property) {
        SortedSet<FieldNode> nodes = this.properties.get(version);
        if (nodes == null) {
            nodes = new TreeSet<FieldNode>(new FieldNodeComparator());
            this.properties.put(version, nodes);
        }
        nodes.add(property);
    }

    private boolean isPortableType() {
        return this.hasAnnotation((MemberNode)this.cn, PortableType.class);
    }

    private boolean isEnum() {
        return (this.cn.access & 0x4000) == 16384;
    }

    private boolean isInstrumented() {
        return this.hasAnnotation((MemberNode)this.cn, Instrumented.class);
    }

    private boolean hasAnnotation(MemberNode node, Class annotationClass) {
        return this.getAnnotation(node, annotationClass) != null;
    }

    private AnnotationNode getAnnotation(MemberNode node, Class ... annotationClasses) {
        if (node.visibleAnnotations != null) {
            for (Class annotationClass : annotationClasses) {
                String desc = Type.getDescriptor((Class)annotationClass);
                for (AnnotationNode an : node.visibleAnnotations) {
                    if (!desc.equals(an.desc)) continue;
                    return an;
                }
            }
        }
        return null;
    }

    private Object getAnnotationAttribute(AnnotationNode an, String name) {
        if (an.values != null) {
            for (int i = 0; i < an.values.size(); i += 2) {
                if (!name.equals(an.values.get(i))) continue;
                Object value = an.values.get(i + 1);
                if (value.getClass().isArray()) {
                    String[] dateMode = (String[])value;
                    return DateMode.valueOf(dateMode[1]);
                }
                return value;
            }
        }
        try {
            Class<?> clazz = this.getClass().getClassLoader().loadClass(an.desc.substring(1, an.desc.length() - 1).replace('/', '.'));
            Object defaultValue = clazz.getMethod(name, new Class[0]).getDefaultValue();
            return defaultValue instanceof Class ? Type.getType((Class)((Class)defaultValue)) : defaultValue;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void implementDefaultConstructor() {
        MethodNode ctor = this.findMethod("<init>", "()V");
        if (ctor == null) {
            ctor = new MethodNode(1, "<init>", "()V", null, null);
            ctor.visitCode();
            ctor.visitVarInsn(25, 0);
            ctor.visitMethodInsn(183, this.cn.superName, "<init>", "()V");
            ctor.visitInsn(177);
            ctor.visitMaxs(1, 1);
            ctor.visitEnd();
            this.cn.methods.add(ctor);
        } else if ((ctor.access & 1) == 0) {
            LOG.info("Class " + this.cn.name + " has a non-public default constructor. Making it public.");
            ctor.access = 1;
        }
    }

    private void implementReadExternal() {
        int index = 0;
        MethodNode mn = new MethodNode(2, "readExternal", "(Lcom/tangosol/io/pof/PofReader;)V", null, new String[]{"java/io/IOException"});
        mn.visitCode();
        for (int version : this.properties.keySet()) {
            mn.visitVarInsn(25, 1);
            mn.visitMethodInsn(185, "com/tangosol/io/pof/PofReader", "getVersionId", "()I");
            mn.visitIntInsn(16, version);
            Label l = new Label();
            mn.visitJumpInsn(161, l);
            SortedSet<FieldNode> fields = this.properties.get(version);
            for (FieldNode fn : fields) {
                Type type = Type.getType((String)fn.desc);
                if (this.isDebugEnabled()) {
                    mn.visitLdcInsn((Object)("reading attribute " + index + " (" + fn.name + ") from POF stream"));
                    mn.visitIntInsn(16, 7);
                    mn.visitMethodInsn(184, "com/tangosol/net/CacheFactory", "log", "(Ljava/lang/String;I)V");
                }
                mn.visitVarInsn(25, 0);
                mn.visitVarInsn(25, 1);
                mn.visitIntInsn(16, index++);
                ReadMethod readMethod = this.getReadMethod(fn, type);
                readMethod.createTemplate(mn, fn, type);
                mn.visitMethodInsn(185, "com/tangosol/io/pof/PofReader", readMethod.getName(), readMethod.getDescriptor());
                if (type.getSort() == 10 || "readObjectArray".equals(readMethod.getName())) {
                    mn.visitTypeInsn(192, type.getInternalName());
                }
                mn.visitFieldInsn(181, this.cn.name, fn.name, fn.desc);
            }
            mn.visitLabel(l);
            mn.visitFrame(3, 0, null, 0, null);
        }
        mn.visitInsn(177);
        mn.visitMaxs(0, 0);
        mn.visitEnd();
        if (!this.hasMethod(mn)) {
            this.cn.methods.add(mn);
        }
        LOG.debug("Implemented method: " + mn.name);
    }

    private Type getFactoryType(AnnotationNode an) {
        Type factoryClass = (Type)this.getAnnotationAttribute(an, "factory");
        return !factoryClass.equals((Object)Type.getType(Factory.class)) ? factoryClass : null;
    }

    private ReadMethod getReadMethod(FieldNode field, Type type) {
        switch (type.getSort()) {
            case 1: {
                return new ReadMethod("readBoolean", "(I)Z");
            }
            case 3: {
                return new ReadMethod("readByte", "(I)B");
            }
            case 2: {
                return new ReadMethod("readChar", "(I)C");
            }
            case 4: {
                return new ReadMethod("readShort", "(I)S");
            }
            case 5: {
                return new ReadMethod("readInt", "(I)I");
            }
            case 7: {
                return new ReadMethod("readLong", "(I)J");
            }
            case 6: {
                return new ReadMethod("readFloat", "(I)F");
            }
            case 8: {
                return new ReadMethod("readDouble", "(I)D");
            }
            case 9: {
                if ("[Z".equals(type.getDescriptor())) {
                    return new ReadMethod("readBooleanArray", "(I)[Z");
                }
                if ("[B".equals(type.getDescriptor())) {
                    return new ReadMethod("readByteArray", "(I)[B");
                }
                if ("[C".equals(type.getDescriptor())) {
                    return new ReadMethod("readCharArray", "(I)[C");
                }
                if ("[S".equals(type.getDescriptor())) {
                    return new ReadMethod("readShortArray", "(I)[S");
                }
                if ("[I".equals(type.getDescriptor())) {
                    return new ReadMethod("readIntArray", "(I)[I");
                }
                if ("[J".equals(type.getDescriptor())) {
                    return new ReadMethod("readLongArray", "(I)[J");
                }
                if ("[F".equals(type.getDescriptor())) {
                    return new ReadMethod("readFloatArray", "(I)[F");
                }
                if ("[D".equals(type.getDescriptor())) {
                    return new ReadMethod("readDoubleArray", "(I)[D");
                }
                return new ObjectArrayReadMethod();
            }
        }
        if (type.getClassName().equals(String.class.getName())) {
            return new ReadMethod("readString", "(I)Ljava/lang/String;");
        }
        if (type.getClassName().equals(Date.class.getName())) {
            return new ReadMethod("readDate", "(I)Ljava/util/Date;");
        }
        if (type.getClassName().equals(BigDecimal.class.getName())) {
            return new ReadMethod("readBigDecimal", "(I)Ljava/math/BigDecimal;");
        }
        if (type.getClassName().equals(BigInteger.class.getName())) {
            return new ReadMethod("readBigInteger", "(I)Ljava/math/BigInteger;");
        }
        if (type.getClassName().equals(Binary.class.getName())) {
            return new ReadMethod("readBinary", "(I)Lcom/tangosol/util/Binary;");
        }
        if (this.isCollection(field, type)) {
            return new CollectionReadMethod();
        }
        if (this.isMap(field, type)) {
            return new MapReadMethod();
        }
        return new ReadMethod("readObject", "(I)Ljava/lang/Object;");
    }

    private void implementWriteExternal() {
        int index = 0;
        MethodNode mn = new MethodNode(2, "writeExternal", "(Lcom/tangosol/io/pof/PofWriter;)V", null, new String[]{"java/io/IOException"});
        mn.visitCode();
        for (int version : this.properties.keySet()) {
            SortedSet<FieldNode> fields = this.properties.get(version);
            for (FieldNode fn : fields) {
                this.addPofIndex(fn, index);
                Type type = Type.getType((String)fn.desc);
                if (this.isDebugEnabled()) {
                    mn.visitLdcInsn((Object)("writing attribute " + index + " (" + fn.name + ") to POF stream"));
                    mn.visitIntInsn(16, 7);
                    mn.visitMethodInsn(184, "com/tangosol/net/CacheFactory", "log", "(Ljava/lang/String;I)V");
                }
                mn.visitVarInsn(25, 1);
                mn.visitIntInsn(16, index++);
                mn.visitVarInsn(25, 0);
                mn.visitFieldInsn(180, this.cn.name, fn.name, fn.desc);
                WriteMethod writeMethod = this.getWriteMethod(fn, type);
                writeMethod.pushUniformTypes(mn);
                mn.visitMethodInsn(185, "com/tangosol/io/pof/PofWriter", writeMethod.getName(), writeMethod.getDescriptor());
            }
        }
        mn.visitInsn(177);
        mn.visitMaxs(0, 0);
        mn.visitEnd();
        if (!this.hasMethod(mn)) {
            this.cn.methods.add(mn);
        }
        LOG.debug("Implemented method: " + mn.name);
    }

    private MethodNode findMethod(String name, String desc) {
        for (MethodNode node : this.cn.methods) {
            if (!node.name.equals(name) || !node.desc.equals(desc)) continue;
            return node;
        }
        return null;
    }

    private boolean hasMethod(MethodNode mn) {
        for (MethodNode node : this.cn.methods) {
            if (!mn.name.equals(node.name) || !mn.desc.equals(node.desc)) continue;
            return true;
        }
        return false;
    }

    private boolean isDebugEnabled() {
        return DEBUG;
    }

    private void addPofIndex(FieldNode fn, int index) {
        AnnotationNode an = new AnnotationNode(Type.getDescriptor(PofIndex.class));
        an.values = Arrays.asList("value", index);
        fn.visibleAnnotations.add(an);
    }

    private WriteMethod getWriteMethod(FieldNode field, Type type) {
        switch (type.getSort()) {
            case 1: {
                return new WriteMethod("writeBoolean", "(IZ)V");
            }
            case 3: {
                return new WriteMethod("writeByte", "(IB)V");
            }
            case 2: {
                return new WriteMethod("writeChar", "(IC)V");
            }
            case 8: {
                return new WriteMethod("writeDouble", "(ID)V");
            }
            case 6: {
                return new WriteMethod("writeFloat", "(IF)V");
            }
            case 5: {
                return new WriteMethod("writeInt", "(II)V");
            }
            case 7: {
                return new WriteMethod("writeLong", "(IJ)V");
            }
            case 4: {
                return new WriteMethod("writeShort", "(IS)V");
            }
            case 9: {
                if ("[Z".equals(type.getDescriptor())) {
                    return new WriteMethod("writeBooleanArray", "(I[Z)V");
                }
                if ("[B".equals(type.getDescriptor())) {
                    return new WriteMethod("writeByteArray", "(I[B)V");
                }
                if ("[C".equals(type.getDescriptor())) {
                    return new WriteMethod("writeCharArray", "(I[C)V");
                }
                if ("[D".equals(type.getDescriptor())) {
                    return new WriteMethod("writeDoubleArray", "(I[D)V");
                }
                if ("[F".equals(type.getDescriptor())) {
                    return new WriteMethod("writeFloatArray", "(I[F)V");
                }
                if ("[I".equals(type.getDescriptor())) {
                    return new WriteMethod("writeIntArray", "(I[I)V");
                }
                if ("[J".equals(type.getDescriptor())) {
                    return new WriteMethod("writeLongArray", "(I[J)V");
                }
                if ("[S".equals(type.getDescriptor())) {
                    return new WriteMethod("writeShortArray", "(I[S)V");
                }
                return this.getObjectArrayWriteMethod(field, type);
            }
        }
        if (type.getClassName().equals(String.class.getName())) {
            return new WriteMethod("writeString", "(ILjava/lang/String;)V");
        }
        if (type.getClassName().equals(BigDecimal.class.getName())) {
            return new WriteMethod("writeBigDecimal", "(ILjava/math/BigDecimal;)V");
        }
        if (type.getClassName().equals(BigInteger.class.getName())) {
            return new WriteMethod("writeBigInteger", "(ILjava/math/BigInteger;)V");
        }
        if (type.getClassName().equals(Binary.class.getName())) {
            return new WriteMethod("writeBinary", "(ILcom/tangosol/util/Binary;)V");
        }
        if (type.getClassName().equals(Date.class.getName())) {
            return this.getDateWriteMethod(field, type);
        }
        if (type.getClassName().equals(Timestamp.class.getName())) {
            return this.getDateWriteMethod(field, type);
        }
        if (this.isCollection(field, type)) {
            return this.getCollectionWriteMethod(field, type);
        }
        if (this.isMap(field, type)) {
            return this.getMapWriteMethod(field, type);
        }
        return new WriteMethod("writeObject", "(ILjava/lang/Object;)V");
    }

    private WriteMethod getDateWriteMethod(FieldNode field, Type type) {
        String name = "writeDateTime";
        String desc = "(I" + type.getDescriptor() + ")V";
        AnnotationNode an = this.getAnnotation((MemberNode)field, PortableDate.class);
        if (an != null) {
            boolean includeTimezone;
            DateMode mode = (DateMode)((Object)this.getAnnotationAttribute(an, "mode"));
            switch (mode) {
                case DATE: {
                    name = "writeDate";
                    break;
                }
                case TIME: {
                    name = "writeTime";
                    break;
                }
                case DATE_TIME: {
                    name = "writeDateTime";
                }
            }
            if (mode != DateMode.DATE && (includeTimezone = ((Boolean)this.getAnnotationAttribute(an, "includeTimezone")).booleanValue())) {
                name = name + "WithZone";
            }
        }
        return new WriteMethod(name, desc);
    }

    private WriteMethod getCollectionWriteMethod(FieldNode field, Type type) {
        Type elementClass = OBJECT_TYPE;
        AnnotationNode an = this.getAnnotation((MemberNode)field, PortableList.class, PortableSet.class);
        if (an != null) {
            elementClass = (Type)this.getAnnotationAttribute(an, "elementClass");
        }
        return new CollectionWriteMethod(elementClass);
    }

    private WriteMethod getMapWriteMethod(FieldNode field, Type type) {
        Type keyClass = OBJECT_TYPE;
        Type valueClass = OBJECT_TYPE;
        AnnotationNode an = this.getAnnotation((MemberNode)field, PortableMap.class);
        if (an != null && !OBJECT_TYPE.equals((Object)(keyClass = (Type)this.getAnnotationAttribute(an, "keyClass")))) {
            valueClass = (Type)this.getAnnotationAttribute(an, "valueClass");
        }
        return new MapWriteMethod(keyClass, valueClass);
    }

    private WriteMethod getObjectArrayWriteMethod(FieldNode field, Type type) {
        Type elementClass = OBJECT_TYPE;
        AnnotationNode an = this.getAnnotation((MemberNode)field, PortableArray.class);
        if (an != null) {
            elementClass = (Type)this.getAnnotationAttribute(an, "elementClass");
        }
        return new ObjectArrayWriteMethod(elementClass);
    }

    private boolean isCollection(FieldNode field, Type type) {
        return COLLECTION_CLASSES.contains(type.getClassName()) || this.hasAnnotation((MemberNode)field, PortableList.class) || this.hasAnnotation((MemberNode)field, PortableSet.class);
    }

    private boolean isList(FieldNode field, Type type) {
        return LIST_CLASSES.contains(type.getClassName()) || this.hasAnnotation((MemberNode)field, PortableList.class);
    }

    private boolean isSet(FieldNode field, Type type) {
        return SET_CLASSES.contains(type.getClassName()) || this.hasAnnotation((MemberNode)field, PortableSet.class);
    }

    private boolean isMap(FieldNode field, Type type) {
        return MAP_CLASSES.contains(type.getClassName()) || this.hasAnnotation((MemberNode)field, PortableMap.class);
    }

    public static void instrumentClasses(File classDir) throws IOException {
        if (!classDir.exists()) {
            throw new IllegalArgumentException("Specified path [" + classDir.getAbsolutePath() + "] does not exist");
        }
        if (!classDir.isDirectory()) {
            throw new IllegalArgumentException("Specified path [" + classDir.getAbsolutePath() + "] is not a directory");
        }
        File[] files = classDir.listFiles();
        if (files != null) {
            PofConfig cfg = null;
            for (File file : files) {
                if (file.isDirectory()) {
                    PortableTypeGenerator.instrumentClasses(file);
                    continue;
                }
                if (!file.getName().endsWith(".class")) continue;
                FileInputStream in = new FileInputStream(file);
                PortableTypeGenerator gen = new PortableTypeGenerator(in);
                in.close();
                UserType type = gen.instrumentClass();
                if (type != null) {
                    if (cfg == null) {
                        cfg = new PofConfig();
                        cfg.setUserTypeList(new UserTypeList());
                        cfg.setDefaultSerializer(new SerializerType("com.seovic.pof.PortableTypeSerializer", null));
                    }
                    cfg.getUserTypeList().getUserTypeOrInclude().add(type);
                }
                FileOutputStream out = new FileOutputStream(file);
                gen.writeClass(out);
                out.flush();
                out.close();
            }
            if (cfg != null) {
                File pofConfig = new File(classDir, "pof-config.xml");
                JAXBMarshaller marshaller = new JAXBMarshaller(PofConfig.class, true);
                marshaller.marshal(cfg, (OutputStream)new FileOutputStream(pofConfig));
                LOG.info("Created " + pofConfig.getAbsolutePath());
            }
        }
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage: PortableTypeGenerator <classDir>");
            System.exit(0);
        }
        try {
            PortableTypeGenerator.instrumentClasses(new File(args[0]));
        }
        catch (Exception e) {
            System.out.println("ERROR:" + e.getMessage());
        }
    }

    public static void premain(String agentArguments, Instrumentation instrumentation) {
        instrumentation.addTransformer(new PortableTypeTransformer());
    }

    private static class PortableTypeTransformer
    implements ClassFileTransformer {
        private PortableTypeTransformer() {
        }

        @Override
        public byte[] transform(ClassLoader classLoader, String s, Class<?> aClass, ProtectionDomain protectionDomain, byte[] bytes) throws IllegalClassFormatException {
            try {
                PortableTypeGenerator gen = new PortableTypeGenerator(new ByteArrayInputStream(bytes));
                gen.instrumentClass();
                return gen.getClassBytes();
            }
            catch (IOException e) {
                throw new IllegalClassFormatException(e.getMessage());
            }
        }
    }

    public static class MavenLogger
    implements Logger {
        private Log log;

        public MavenLogger(Log log) {
            this.log = log;
        }

        @Override
        public void debug(String message) {
            this.log.debug((CharSequence)message);
        }

        @Override
        public void info(String message) {
            this.log.info((CharSequence)message);
        }
    }

    public static class SLF4JLogger
    implements Logger {
        private org.slf4j.Logger log = LoggerFactory.getLogger(PortableTypeGenerator.class);

        @Override
        public void debug(String message) {
            this.log.debug(message);
        }

        @Override
        public void info(String message) {
            this.log.info(message);
        }
    }

    public static class ConsoleLogger
    implements Logger {
        @Override
        public void debug(String message) {
            System.out.println("[DEBUG] " + message);
        }

        @Override
        public void info(String message) {
            System.out.println("[INFO] " + message);
        }
    }

    public static interface Logger {
        public void debug(String var1);

        public void info(String var1);
    }

    private static class ObjectArrayWriteMethod
    extends CollectionWriteMethod {
        private ObjectArrayWriteMethod(Type elementClass) {
            super("writeObjectArray", ObjectArrayWriteMethod.createDescriptor(elementClass), elementClass);
        }

        private static String createDescriptor(Type elementClass) {
            String desc = "(I[Ljava/lang/Object;";
            if (ObjectArrayWriteMethod.isUniform(elementClass)) {
                desc = desc + "Ljava/lang/Class;";
            }
            return desc + ")V";
        }
    }

    private static class ObjectArrayReadMethod
    extends ReadMethod {
        public ObjectArrayReadMethod() {
            super("readObjectArray", "(I[Ljava/lang/Object;)[Ljava/lang/Object;");
        }

        @Override
        public void createTemplate(MethodNode mn, FieldNode field, Type type) {
            mn.visitInsn(3);
            mn.visitTypeInsn(189, type.getElementType().getInternalName());
        }
    }

    private static class MapWriteMethod
    extends WriteMethod {
        private Type keyClass;
        private Type valueClass;

        public MapWriteMethod(Type keyClass, Type valueClass) {
            super("writeMap", MapWriteMethod.createDescriptor(keyClass, valueClass));
            this.keyClass = keyClass;
            this.valueClass = valueClass;
        }

        private static String createDescriptor(Type keyClass, Type valueClass) {
            String desc = "(ILjava/util/Map;";
            if (MapWriteMethod.isUniform(keyClass)) {
                desc = desc + "Ljava/lang/Class;";
                if (MapWriteMethod.isUniform(valueClass)) {
                    desc = desc + "Ljava/lang/Class;";
                }
            }
            return desc + ")V";
        }

        protected static boolean isUniform(Type elementClass) {
            return !OBJECT_TYPE.equals((Object)elementClass);
        }

        @Override
        public void pushUniformTypes(MethodNode mn) {
            if (MapWriteMethod.isUniform(this.keyClass)) {
                mn.visitLdcInsn((Object)this.keyClass);
                if (MapWriteMethod.isUniform(this.valueClass)) {
                    mn.visitLdcInsn((Object)this.valueClass);
                }
            }
        }
    }

    private class MapReadMethod
    extends CollectionReadMethod {
        public MapReadMethod() {
            super("readMap", "(ILjava/util/Map;)Ljava/util/Map;");
        }
    }

    private static class CollectionWriteMethod
    extends WriteMethod {
        private Type elementClass;

        public CollectionWriteMethod(Type elementClass) {
            this("writeCollection", CollectionWriteMethod.createDescriptor(elementClass), elementClass);
        }

        protected CollectionWriteMethod(String name, String desc, Type elementClass) {
            super(name, desc);
            this.elementClass = elementClass;
        }

        private static String createDescriptor(Type elementClass) {
            String desc = "(ILjava/util/Collection;";
            if (CollectionWriteMethod.isUniform(elementClass)) {
                desc = desc + "Ljava/lang/Class;";
            }
            return desc + ")V";
        }

        protected static boolean isUniform(Type elementClass) {
            return !OBJECT_TYPE.equals((Object)elementClass);
        }

        @Override
        public void pushUniformTypes(MethodNode mn) {
            if (CollectionWriteMethod.isUniform(this.elementClass)) {
                mn.visitLdcInsn((Object)this.elementClass);
            }
        }
    }

    private class CollectionReadMethod
    extends ReadMethod {
        public CollectionReadMethod() {
            this("readCollection", "(ILjava/util/Collection;)Ljava/util/Collection;");
        }

        protected CollectionReadMethod(String name, String desc) {
            super(name, desc);
        }

        @Override
        public void createTemplate(MethodNode mn, FieldNode field, Type type) {
            AnnotationNode an = PortableTypeGenerator.this.getAnnotation((MemberNode)field, new Class[]{PortableSet.class, PortableList.class, PortableMap.class, Portable.class});
            Type factory = PortableTypeGenerator.this.getFactoryType(an);
            if (factory != null) {
                mn.visitTypeInsn(187, factory.getInternalName());
                mn.visitInsn(89);
                mn.visitMethodInsn(183, factory.getInternalName(), "<init>", "()V");
                mn.visitMethodInsn(182, factory.getInternalName(), "create", "()Ljava/lang/Object;");
            } else {
                Type clazz = (Type)PortableTypeGenerator.this.getAnnotationAttribute(an, "clazz");
                if (clazz.equals((Object)Type.getType(Object.class))) {
                    clazz = this.getDefaultClass(field, type);
                }
                mn.visitLdcInsn((Object)clazz);
                mn.visitMethodInsn(184, Type.getInternalName(AsmUtils.class), "createInstance", "(Ljava/lang/Class;)Ljava/lang/Object;");
            }
        }

        private Type getDefaultClass(FieldNode fn, Type type) {
            if (PortableTypeGenerator.this.isSet(fn, type)) {
                return Type.getType(HashSet.class);
            }
            if (PortableTypeGenerator.this.isList(fn, type)) {
                return Type.getType(ArrayList.class);
            }
            if (PortableTypeGenerator.this.isMap(fn, type)) {
                return Type.getType(HashMap.class);
            }
            throw new IllegalStateException("Property " + ((PortableTypeGenerator)PortableTypeGenerator.this).cn.name + "." + fn.name + " must have explicitly defined class or factory");
        }
    }

    private static class WriteMethod
    extends Method {
        public WriteMethod(String name, String desc) {
            super(name, desc);
        }

        public void pushUniformTypes(MethodNode mn) {
        }
    }

    private static class ReadMethod
    extends Method {
        public ReadMethod(String name, String desc) {
            super(name, desc);
        }

        public void createTemplate(MethodNode mn, FieldNode field, Type type) {
        }
    }

    private class FieldNodeComparator
    implements Comparator<FieldNode> {
        private FieldNodeComparator() {
        }

        @Override
        public int compare(FieldNode f1, FieldNode f2) {
            Integer idx2;
            Integer idx1 = (Integer)PortableTypeGenerator.this.getAnnotationAttribute(PortableTypeGenerator.this.getAnnotation((MemberNode)f1, PORTABLE_ANNOTATIONS), "order");
            int cmp = idx1.compareTo(idx2 = (Integer)PortableTypeGenerator.this.getAnnotationAttribute(PortableTypeGenerator.this.getAnnotation((MemberNode)f2, PORTABLE_ANNOTATIONS), "order"));
            return cmp == 0 ? f1.name.compareTo(f2.name) : cmp;
        }
    }
}

