/*
 * Decompiled with CFR 0.152.
 */
package com.seovic.pof.xjc;

import com.seovic.core.io.JAXBMarshaller;
import com.seovic.pof.internal.PofConfig;
import com.seovic.pof.internal.SerializerType;
import com.seovic.pof.internal.UserType;
import com.seovic.pof.internal.UserTypeList;
import com.seovic.pof.util.PofHelper;
import com.sun.codemodel.JBlock;
import com.sun.codemodel.JClass;
import com.sun.codemodel.JDefinedClass;
import com.sun.codemodel.JExpr;
import com.sun.codemodel.JExpression;
import com.sun.codemodel.JInvocation;
import com.sun.codemodel.JMethod;
import com.sun.codemodel.JStatement;
import com.sun.codemodel.JType;
import com.sun.codemodel.JVar;
import com.sun.tools.xjc.BadCommandLineException;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.Plugin;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.EnumOutline;
import com.sun.tools.xjc.outline.FieldOutline;
import com.sun.tools.xjc.outline.Outline;
import com.tangosol.io.pof.EnumPofSerializer;
import com.tangosol.io.pof.PofReader;
import com.tangosol.io.pof.PofWriter;
import com.tangosol.io.pof.PortableObject;
import com.tangosol.io.pof.RawDate;
import com.tangosol.io.pof.RawDateTime;
import com.tangosol.io.pof.RawTime;
import com.tangosol.io.pof.annotation.Portable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PofXjcPlugin
extends Plugin {
    private static final JType[] NONE = new JType[0];
    private long typeId = 1000L;

    public String getOptionName() {
        return "Xpof";
    }

    public String getUsage() {
        return "  -Xpof              :  implement Portable Object Format (POF) serialization in generated classes\n  -Xpof:typeId=<id>  :  start type identifier for the generated POF types";
    }

    public int parseArgument(Options opt, String[] args, int i) throws BadCommandLineException, IOException {
        int ret = 0;
        if (args[i].startsWith("-Xpof")) {
            ret = 1;
            if (args[i].startsWith("-Xpof:typeId=")) {
                String sTypeId = args[i].substring("-Xpof:typeId=".length());
                try {
                    this.typeId = Long.parseLong(sTypeId);
                    if (this.typeId < 0L) {
                        throw new BadCommandLineException("Initial POF type ID must be a positive integer");
                    }
                }
                catch (NumberFormatException e) {
                    throw new BadCommandLineException("Initial POF type ID must be a positive integer");
                }
            }
        }
        return ret;
    }

    public boolean run(Outline outline, Options options, ErrorHandler handler) throws SAXException {
        PofConfig cfg = new PofConfig();
        UserTypeList userTypes = new UserTypeList();
        cfg.setUserTypeList(userTypes);
        for (Object co : outline.getClasses()) {
            JDefinedClass c = ((ClassOutline)co).implClass;
            c._implements(PortableObject.class);
            c.annotate(Portable.class);
            new ReadExternalCreator((ClassOutline)co, "readExternal", PofReader.class, "reader").createMethod();
            new WriteExternalCreator((ClassOutline)co, "writeExternal", PofWriter.class, "writer").createMethod();
            userTypes.getUserTypeOrInclude().add(new UserType(BigInteger.valueOf(this.typeId++), c.fullName(), null));
        }
        SerializerType enumSerializer = new SerializerType().withClassName(EnumPofSerializer.class.getName());
        for (EnumOutline eo : outline.getEnums()) {
            JDefinedClass c = eo.clazz;
            userTypes.getUserTypeOrInclude().add(new UserType(BigInteger.valueOf(this.typeId++), c.fullName(), enumSerializer));
        }
        try {
            File targetDir = new File(options.targetDir, options.defaultPackage.replace('.', File.separatorChar));
            targetDir.mkdirs();
            File pofConfig = new File(targetDir, "pof-config.xml");
            JAXBMarshaller marshaller = new JAXBMarshaller(PofConfig.class, true);
            marshaller.marshal((Object)cfg, (OutputStream)new FileOutputStream(pofConfig));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return false;
    }

    class WriteExternalCreator
    extends MethodCreator {
        WriteExternalCreator(ClassOutline classOutline, String name, Class argType, String argName) {
            super(classOutline, name, argType, argName);
        }

        public void createMethod() {
            JBlock body = this.method.body();
            int n = 0;
            List<FieldOutline> fields = this.getAllDeclaredAndInheritedFields();
            for (FieldOutline fo : fields) {
                JType fieldType = fo.getRawType();
                String t = fieldType.name();
                JInvocation invocation = null;
                if (t.equals("XMLGregorianCalendar")) {
                    String st;
                    JClass pofHelper = this.classOutline.implClass.owner().ref(PofHelper.class);
                    QName qName = fo.getPropertyInfo().getSchemaType();
                    String string = st = qName == null ? "dateTime" : qName.getLocalPart();
                    if (st.equals("date")) {
                        invocation = this.arg.invoke("writeRawDate").arg(JExpr.lit((int)n++)).arg((JExpression)pofHelper.staticInvoke("toRawDate").arg((JExpression)JExpr.invoke((JMethod)this.getter(fo))));
                    }
                    if (st.equals("dateTime")) {
                        invocation = this.arg.invoke("writeRawDateTime").arg(JExpr.lit((int)n++)).arg((JExpression)pofHelper.staticInvoke("toRawDateTime").arg((JExpression)JExpr.invoke((JMethod)this.getter(fo))));
                    }
                    if (st.equals("time")) {
                        invocation = this.arg.invoke("writeRawTime").arg(JExpr.lit((int)n++)).arg((JExpression)pofHelper.staticInvoke("toRawTime").arg((JExpression)JExpr.invoke((JMethod)this.getter(fo))));
                    }
                } else {
                    invocation = this.arg.invoke(this.getWriteMethod(fo)).arg(JExpr.lit((int)n++)).arg((JExpression)JExpr.invoke((JMethod)this.getter(fo)));
                }
                body.add((JStatement)invocation);
            }
        }

        private String getWriteMethod(FieldOutline field) {
            JType fieldType = field.getRawType();
            String t = fieldType.name();
            if (t.equals("boolean")) {
                return "writeBoolean";
            }
            if (t.equals("byte")) {
                return "writeByte";
            }
            if (t.equals("double")) {
                return "writeDouble";
            }
            if (t.equals("float")) {
                return "writeFloat";
            }
            if (t.equals("int")) {
                return "writeInt";
            }
            if (t.equals("long")) {
                return "writeLong";
            }
            if (t.equals("short")) {
                return "writeShort";
            }
            if (t.equals("BigDecimal")) {
                return "writeBigDecimal";
            }
            if (t.equals("BigInteger")) {
                return "writeBigInteger";
            }
            if (t.equals("String")) {
                return "writeString";
            }
            return field.getPropertyInfo().isCollection() ? "writeCollection" : "writeObject";
        }
    }

    class ReadExternalCreator
    extends MethodCreator {
        ReadExternalCreator(ClassOutline classOutline, String name, Class argType, String argName) {
            super(classOutline, name, argType, argName);
        }

        public void createMethod() {
            JBlock body = this.method.body();
            int n = 0;
            List<FieldOutline> fields = this.getAllDeclaredAndInheritedFields();
            for (FieldOutline fo : fields) {
                JMethod setter = this.setter(fo);
                JType fieldType = fo.getRawType();
                String t = fieldType.name();
                if (setter != null) {
                    String methodName = this.getReadMethod(fo);
                    JInvocation invocation = this.arg.invoke(methodName).arg(JExpr.lit((int)n++));
                    if (t.equals("XMLGregorianCalendar")) {
                        String st;
                        JClass pofHelper = this.classOutline.implClass.owner().ref(PofHelper.class);
                        JClass TRawDate = this.classOutline.implClass.owner().ref(RawDate.class);
                        JClass TRawDateTime = this.classOutline.implClass.owner().ref(RawDateTime.class);
                        JClass TRawTime = this.classOutline.implClass.owner().ref(RawTime.class);
                        QName qName = fo.getPropertyInfo().getSchemaType();
                        String string = st = qName == null ? "dateTime" : qName.getLocalPart();
                        if (st.equals("date")) {
                            invocation = pofHelper.staticInvoke("fromRawDate").arg((JExpression)JExpr.cast((JType)TRawDate, (JExpression)invocation));
                        }
                        if (st.equals("dateTime")) {
                            invocation = pofHelper.staticInvoke("fromRawDateTime").arg((JExpression)JExpr.cast((JType)TRawDateTime, (JExpression)invocation));
                        }
                        if (st.equals("time")) {
                            invocation = pofHelper.staticInvoke("fromRawTime").arg((JExpression)JExpr.cast((JType)TRawTime, (JExpression)invocation));
                        }
                    }
                    body.invoke(setter).arg((JExpression)("readObject".equals(methodName) ? JExpr.cast((JType)fo.getRawType(), (JExpression)invocation) : invocation));
                    continue;
                }
                if (!fo.getPropertyInfo().isCollection()) continue;
                JInvocation readMethod = this.arg.invoke("readCollection").arg(JExpr.lit((int)n++)).arg((JExpression)JExpr.invoke((JMethod)this.getter(fo)));
                body.add((JStatement)readMethod);
            }
        }

        private String getReadMethod(FieldOutline field) {
            JType fieldType = field.getRawType();
            String t = fieldType.name();
            if (t.equals("boolean")) {
                return "readBoolean";
            }
            if (t.equals("byte")) {
                return "readByte";
            }
            if (t.equals("double")) {
                return "readDouble";
            }
            if (t.equals("float")) {
                return "readFloat";
            }
            if (t.equals("int")) {
                return "readInt";
            }
            if (t.equals("long")) {
                return "readLong";
            }
            if (t.equals("short")) {
                return "readShort";
            }
            if (t.equals("BigDecimal")) {
                return "readBigDecimal";
            }
            if (t.equals("BigInteger")) {
                return "readBigInteger";
            }
            if (t.equals("String")) {
                return "readString";
            }
            if (t.equals("XMLGregorianCalendar")) {
                String st;
                QName qName = field.getPropertyInfo().getSchemaType();
                String string = st = qName == null ? "readRawDateTime" : qName.getLocalPart();
                if (st.equals("date")) {
                    return "readRawDate";
                }
                if (st.equals("dateTime")) {
                    return "readRawDateTime";
                }
                if (st.equals("time")) {
                    return "readRawTime";
                }
            }
            return "readObject";
        }
    }

    abstract class MethodCreator {
        protected ClassOutline classOutline;
        protected String name;
        protected Class argType;
        protected String argName;
        protected JMethod method;
        protected JVar arg;

        protected MethodCreator(ClassOutline classOutline, String name, Class argType, String argName) {
            this.classOutline = classOutline;
            this.name = name;
            this.argType = argType;
            this.argName = argName;
            JDefinedClass cls = classOutline.implClass;
            this.method = cls.method(1, (JType)cls.owner().VOID, name)._throws(IOException.class);
            this.arg = this.method.param(argType, argName);
        }

        protected List<FieldOutline> getAllDeclaredAndInheritedFields() {
            LinkedList<FieldOutline> fields = new LinkedList<FieldOutline>();
            for (ClassOutline currentClassOutline = this.classOutline; currentClassOutline != null; currentClassOutline = currentClassOutline.getSuperClass()) {
                fields.addAll(Arrays.asList(currentClassOutline.getDeclaredFields()));
            }
            return fields;
        }

        protected JMethod getter(FieldOutline fieldOutline) {
            JDefinedClass theClass = fieldOutline.parent().implClass;
            String publicName = fieldOutline.getPropertyInfo().getName(true);
            JMethod getter = theClass.getMethod("get" + publicName, NONE);
            if (getter == null) {
                getter = theClass.getMethod("is" + publicName, NONE);
            }
            return getter;
        }

        protected JMethod setter(FieldOutline fieldOutline) {
            JDefinedClass theClass = fieldOutline.parent().implClass;
            String publicName = fieldOutline.getPropertyInfo().getName(true);
            return theClass.getMethod("set" + publicName, new JType[]{fieldOutline.getRawType()});
        }
    }
}

