/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.DBCollection;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.response.SdbReply;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;

public class CollectionSpace {
    private String name;
    private Sequoiadb sequoiadb;

    public String getName() {
        return this.name;
    }

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    CollectionSpace(Sequoiadb sequoiadb, String name) {
        this.name = name;
        this.sequoiadb = sequoiadb;
    }

    public DBCollection getCollection(String collectionName) throws BaseException {
        String collectionFullName = this.name + "." + collectionName;
        if (this.sequoiadb.fetchCache(collectionFullName)) {
            return new DBCollection(this.sequoiadb, this, collectionName);
        }
        if (this.isCollectionExist(collectionName)) {
            return new DBCollection(this.sequoiadb, this, collectionName);
        }
        throw new BaseException(SDBError.SDB_DMS_NOTEXIST, collectionName);
    }

    public boolean isCollectionExist(String collectionName) throws BaseException {
        String collectionFullName = this.name + "." + collectionName;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)collectionFullName);
        AdminRequest request = new AdminRequest("$test collection", obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag == 0) {
            this.sequoiadb.upsertCache(collectionFullName);
            return true;
        }
        if (flag == SDBError.SDB_DMS_NOTEXIST.getErrorCode()) {
            this.sequoiadb.removeCache(collectionFullName);
            return false;
        }
        this.sequoiadb.throwIfError(response);
        return false;
    }

    public List<String> getCollectionNames() throws BaseException {
        ArrayList<String> collectionNames = new ArrayList<String>();
        ArrayList<String> colNames = this.sequoiadb.getCollectionNames();
        if (colNames != null && colNames.size() != 0) {
            for (String col : colNames) {
                if (!col.startsWith(this.name + ".")) continue;
                collectionNames.add(col);
            }
        }
        return collectionNames;
    }

    public DBCollection createCollection(String collectionName) throws BaseException {
        return this.createCollection(collectionName, null);
    }

    public DBCollection createCollection(String collectionName, BSONObject options) {
        if (this.isCollectionExist(collectionName)) {
            throw new BaseException(SDBError.SDB_DMS_EXIST, collectionName);
        }
        String collectionFullName = this.name + "." + collectionName;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)collectionFullName);
        if (options != null) {
            obj.putAll(options);
        }
        AdminRequest request = new AdminRequest("$create collection", obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        String msg = "collection = " + collectionFullName + ", options = " + options;
        this.sequoiadb.throwIfError(response, msg);
        this.sequoiadb.upsertCache(collectionFullName);
        return new DBCollection(this.sequoiadb, this, collectionName);
    }

    public void drop() throws BaseException {
        this.sequoiadb.dropCollectionSpace(this.name);
    }

    public void dropCollection(String collectionName) throws BaseException {
        if (!this.isCollectionExist(collectionName)) {
            throw new BaseException(SDBError.SDB_DMS_NOTEXIST, collectionName);
        }
        String collectionFullName = this.name + "." + collectionName;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)collectionFullName);
        AdminRequest request = new AdminRequest("$drop collection", obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, collectionName);
        this.sequoiadb.removeCache(collectionFullName);
    }

    private void alterInternal(String taskName, BSONObject options, boolean allowNullArgs) throws BaseException {
        if (null == options && !allowNullArgs) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        BasicBSONObject argumentObj = new BasicBSONObject();
        argumentObj.put("Name", (Object)taskName);
        argumentObj.put("Args", (Object)options);
        BasicBSONObject alterObject = new BasicBSONObject();
        alterObject.put("Alter", (Object)argumentObj);
        this.alterCollectionSpace(alterObject);
    }

    public void alterCollectionSpace(BSONObject options) throws BaseException {
        if (null == options) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        BasicBSONObject newObj = new BasicBSONObject();
        if (!options.containsField("Alter")) {
            newObj.put("Name", (Object)this.name);
            newObj.put("Options", (Object)options);
        } else {
            Object tmpAlter = options.get("Alter");
            if (!(tmpAlter instanceof BasicBSONObject) && !(tmpAlter instanceof BasicBSONList)) {
                throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
            }
            newObj.put("Alter", tmpAlter);
            newObj.put("AlterType", (Object)"collection space");
            newObj.put("Version", (Object)1);
            newObj.put("Name", (Object)this.name);
            if (options.containsField("Options")) {
                Object tmpOptions = options.get("Options");
                if (tmpOptions instanceof BasicBSONObject) {
                    newObj.put("Options", tmpOptions);
                } else {
                    throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
                }
            }
        }
        AdminRequest request = new AdminRequest("$alter collectionspace", newObj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response);
    }

    public void setDomain(BSONObject options) throws BaseException {
        this.alterInternal("set domain", options, false);
    }

    public void removeDomain() throws BaseException {
        this.alterInternal("remove domain", null, true);
    }

    public void enableCapped() throws BaseException {
        this.alterInternal("enable capped", null, true);
    }

    public void disableCapped() throws BaseException {
        this.alterInternal("disable capped", null, true);
    }

    public void setAttributes(BSONObject options) throws BaseException {
        this.alterInternal("set attributes", options, false);
    }
}

