/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;

public class ConfigOptions {
    private long maxAutoConnectRetryTime = 15000L;
    private int connectTimeout = 10000;
    private int socketTimeout = 0;
    private boolean socketKeepAlive = false;
    private boolean useNagle = false;
    private boolean useSSL = false;

    public void setMaxAutoConnectRetryTime(long maxRetryTimeMillis) {
        if (maxRetryTimeMillis < 0L) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "should not less than 0");
        }
        this.maxAutoConnectRetryTime = maxRetryTimeMillis;
    }

    public void setConnectTimeout(int connectTimeoutMillis) {
        if (connectTimeoutMillis < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "should not less than 0");
        }
        this.connectTimeout = connectTimeoutMillis;
    }

    public void setSocketTimeout(int socketTimeoutMillis) {
        if (socketTimeoutMillis < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "should not less than 0");
        }
        this.socketTimeout = socketTimeoutMillis;
    }

    public void setSocketKeepAlive(boolean on) {
        this.socketKeepAlive = on;
    }

    public void setUseNagle(boolean on) {
        this.useNagle = on;
    }

    public void setUseSSL(boolean on) {
        this.useSSL = on;
    }

    public long getMaxAutoConnectRetryTime() {
        return this.maxAutoConnectRetryTime;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getSocketTimeout() {
        return this.socketTimeout;
    }

    public boolean getSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public boolean getUseNagle() {
        return this.useNagle;
    }

    public boolean getUseSSL() {
        return this.useSSL;
    }
}

