/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.CollectionSpace;
import com.sequoiadb.base.DBCursor;
import com.sequoiadb.base.DBLob;
import com.sequoiadb.base.DBLobImpl;
import com.sequoiadb.base.DBQuery;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.request.AggregateRequest;
import com.sequoiadb.message.request.DeleteRequest;
import com.sequoiadb.message.request.InsertRequest;
import com.sequoiadb.message.request.LobRemoveRequest;
import com.sequoiadb.message.request.LobTruncateRequest;
import com.sequoiadb.message.request.QueryRequest;
import com.sequoiadb.message.request.UpdateRequest;
import com.sequoiadb.message.response.SdbReply;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;
import org.bson.types.ObjectId;
import org.bson.util.JSON;

public class DBCollection {
    private String name;
    private Sequoiadb sequoiadb;
    private CollectionSpace collectionSpace;
    private String csName;
    private String collectionFullName;
    private Set<String> mainKeys;
    private boolean ensureOID;
    public static final int FLG_INSERT_CONTONDUP = 1;
    public static final int FLG_UPDATE_KEEP_SHARDINGKEY = 32768;

    public String getName() {
        return this.name;
    }

    public String getFullName() {
        return this.collectionFullName;
    }

    public String getCSName() {
        return this.csName;
    }

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    public CollectionSpace getCollectionSpace() {
        return this.collectionSpace;
    }

    public void setMainKeys(String[] keys) throws BaseException {
        if (keys == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "keys is null");
        }
        this.mainKeys.clear();
        if (keys.length == 0) {
            return;
        }
        for (String k : keys) {
            this.mainKeys.add(k);
        }
    }

    DBCollection(Sequoiadb sequoiadb, CollectionSpace cs, String name) {
        this.name = name;
        this.sequoiadb = sequoiadb;
        this.collectionSpace = cs;
        this.csName = cs.getName();
        this.collectionFullName = this.csName + "." + name;
        this.mainKeys = new HashSet<String>();
        this.ensureOID = true;
    }

    public Object insert(BSONObject insertor) throws BaseException {
        if (insertor == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        Object retObj = insertor.get("_id");
        if (retObj == null) {
            ObjectId objId = ObjectId.get();
            insertor.put("_id", objId);
            retObj = objId;
        }
        InsertRequest request = new InsertRequest(this.collectionFullName, insertor);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, insertor);
        this.sequoiadb.upsertCache(this.collectionFullName);
        return retObj;
    }

    public Object insert(String insertor) throws BaseException {
        BSONObject in = null;
        if (insertor != null) {
            in = (BSONObject)JSON.parse(insertor);
        }
        return this.insert(in);
    }

    public void insert(List<BSONObject> insertor, int flag) throws BaseException {
        if (flag != 0 && flag != 1) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        if (insertor == null || insertor.size() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        InsertRequest request = new InsertRequest(this.collectionFullName, insertor, flag, this.ensureOID);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void insert(List<BSONObject> insertor) throws BaseException {
        this.insert(insertor, 0);
    }

    public <T> void save(T type, Boolean ignoreNullValue, int flag) throws BaseException {
        BSONObject obj;
        try {
            obj = BasicBSONObject.typeToBson(type, ignoreNullValue);
        }
        catch (Exception e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, type.toString(), e);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        BasicBSONObject modifer = new BasicBSONObject();
        if (this.mainKeys.isEmpty()) {
            Object id = obj.get("_id");
            if (id == null || id instanceof ObjectId && ((ObjectId)id).isNew()) {
                if (id != null && id instanceof ObjectId) {
                    ((ObjectId)id).notNew();
                }
                this.insert(obj);
            } else {
                matcher.put("_id", id);
                modifer.put("$set", (Object)obj);
                this.upsert(matcher, modifer, null, null, flag);
            }
        } else {
            for (String key : this.mainKeys) {
                if (!obj.containsField(key)) continue;
                matcher.put(key, obj.get(key));
            }
            if (!matcher.isEmpty()) {
                modifer.put("$set", (Object)obj);
                this.upsert(matcher, modifer, null, null, flag);
            } else {
                this.insert(obj);
            }
        }
    }

    public <T> void save(T type, Boolean ignoreNullValue) throws BaseException {
        this.save(type, ignoreNullValue, 0);
    }

    public <T> void save(T type) throws BaseException {
        this.save(type, (Boolean)false);
    }

    public <T> void save(List<T> type, Boolean ignoreNullValue, int flag) throws BaseException {
        if (type == null || type.size() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "type is empty or null");
        }
        ArrayList<BSONObject> objs = new ArrayList<BSONObject>();
        try {
            Iterator<T> it = type.iterator();
            while (it != null && it.hasNext()) {
                objs.add(BasicBSONObject.typeToBson(it.next(), ignoreNullValue));
            }
        }
        catch (Exception e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, type.toString(), e);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        BasicBSONObject modifer = new BasicBSONObject();
        BSONObject obj = null;
        Iterator ite = objs.iterator();
        if (this.mainKeys.isEmpty()) {
            while (ite != null && ite.hasNext()) {
                obj = (BSONObject)ite.next();
                Object id = obj.get("_id");
                if (id == null || id instanceof ObjectId && ((ObjectId)id).isNew()) {
                    if (id != null && id instanceof ObjectId) {
                        ((ObjectId)id).notNew();
                    }
                    this.insert(obj);
                    continue;
                }
                matcher.put("_id", id);
                modifer.put("$set", (Object)obj);
                this.upsert(matcher, modifer, null, null, flag);
            }
        } else {
            while (ite != null && ite.hasNext()) {
                obj = (BSONObject)ite.next();
                for (String key : this.mainKeys) {
                    if (!obj.containsField(key)) continue;
                    matcher.put(key, obj.get(key));
                }
                if (!matcher.isEmpty()) {
                    modifer.put("$set", (Object)obj);
                    this.upsert(matcher, modifer, null, null, flag);
                    continue;
                }
                this.insert(obj);
            }
        }
    }

    public <T> void save(List<T> type, Boolean ignoreNullValue) throws BaseException {
        this.save(type, ignoreNullValue, 0);
    }

    public <T> void save(List<T> type) throws BaseException {
        this.save(type, (Boolean)false);
    }

    public void ensureOID(boolean flag) {
        this.ensureOID = flag;
    }

    public boolean isOIDEnsured() {
        return this.ensureOID;
    }

    @Deprecated
    public void bulkInsert(List<BSONObject> insertor, int flag) throws BaseException {
        this.insert(insertor, flag);
    }

    public void delete(BSONObject matcher) throws BaseException {
        this.delete(matcher, null);
    }

    public void delete(String matcher) throws BaseException {
        BSONObject ma = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        this.delete(ma, null);
    }

    public void delete(String matcher, String hint) throws BaseException {
        BSONObject ma = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        this.delete(ma, hi);
    }

    public void delete(BSONObject matcher, BSONObject hint) throws BaseException {
        DeleteRequest request = new DeleteRequest(this.collectionFullName, matcher, hint);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        if (response.getFlag() != 0) {
            String msg = "matcher = " + matcher + ", hint = " + hint;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void update(DBQuery query) throws BaseException {
        this._update(query.getFlag(), query.getMatcher(), query.getModifier(), query.getHint());
    }

    public void update(BSONObject matcher, BSONObject modifier, BSONObject hint) throws BaseException {
        this._update(0, matcher, modifier, hint);
    }

    public void update(BSONObject matcher, BSONObject modifier, BSONObject hint, int flag) throws BaseException {
        this._update(flag, matcher, modifier, hint);
    }

    public void update(String matcher, String modifier, String hint) throws BaseException {
        BSONObject ma = null;
        BSONObject mo = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (modifier != null) {
            mo = (BSONObject)JSON.parse(modifier);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        this._update(0, ma, mo, hi);
    }

    public void update(String matcher, String modifier, String hint, int flag) throws BaseException {
        BSONObject ma = null;
        BSONObject mo = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (modifier != null) {
            mo = (BSONObject)JSON.parse(modifier);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        this._update(flag, ma, mo, hi);
    }

    public void upsert(BSONObject matcher, BSONObject modifier, BSONObject hint) throws BaseException {
        this._update(1, matcher, modifier, hint);
    }

    public void upsert(BSONObject matcher, BSONObject modifier, BSONObject hint, BSONObject setOnInsert) throws BaseException {
        this.upsert(matcher, modifier, hint, setOnInsert, 0);
    }

    public void upsert(BSONObject matcher, BSONObject modifier, BSONObject hint, BSONObject setOnInsert, int flag) throws BaseException {
        BSONObject newHint;
        if (setOnInsert != null) {
            newHint = new BasicBSONObject();
            if (hint != null) {
                newHint.putAll(hint);
            }
            newHint.put("$SetOnInsert", setOnInsert);
        } else {
            newHint = hint;
        }
        this._update(flag |= 1, matcher, modifier, newHint);
    }

    public DBCursor explain(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flag, BSONObject options) throws BaseException {
        flag |= 0x400;
        BasicBSONObject innerHint = new BasicBSONObject();
        if (null != hint) {
            innerHint.put("Hint", (Object)hint);
        }
        if (null != options) {
            innerHint.put("Options", (Object)options);
        }
        return this._query(matcher, selector, orderBy, innerHint, skipRows, returnRows, flag);
    }

    public DBCursor query() throws BaseException {
        return this.query("", "", "", "", 0L, -1L);
    }

    public DBCursor query(DBQuery matcher) throws BaseException {
        if (matcher == null) {
            return this.query();
        }
        return this.query(matcher.getMatcher(), matcher.getSelector(), matcher.getOrderBy(), matcher.getHint(), matcher.getSkipRowsCount(), matcher.getReturnRowsCount(), matcher.getFlag());
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, 0L, -1L, 0);
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, int flag) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, 0L, -1L, flag);
    }

    public DBCursor query(String matcher, String selector, String orderBy, String hint) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, 0);
    }

    public DBCursor query(String matcher, String selector, String orderBy, String hint, int flag) throws BaseException {
        BSONObject ma = null;
        BSONObject se = null;
        BSONObject or = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (selector != null) {
            se = (BSONObject)JSON.parse(selector);
        }
        if (orderBy != null && !orderBy.equals("")) {
            or = (BSONObject)JSON.parse(orderBy);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        return this.query(ma, se, or, hi, 0L, -1L, flag);
    }

    public DBCursor query(String matcher, String selector, String orderBy, String hint, long skipRows, long returnRows) throws BaseException {
        BSONObject ma = null;
        BSONObject se = null;
        BSONObject or = null;
        BSONObject hi = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (selector != null) {
            se = (BSONObject)JSON.parse(selector);
        }
        if (orderBy != null) {
            or = (BSONObject)JSON.parse(orderBy);
        }
        if (hint != null) {
            hi = (BSONObject)JSON.parse(hint);
        }
        return this.query(ma, se, or, hi, skipRows, returnRows, 0);
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows) throws BaseException {
        return this.query(matcher, selector, orderBy, hint, skipRows, returnRows, 0);
    }

    public DBCursor query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flags) throws BaseException {
        if (flags != 0) {
            flags = DBQuery.eraseSingleFlag(flags, 1024);
        }
        return this._query(matcher, selector, orderBy, hint, skipRows, returnRows, flags);
    }

    private DBCursor _query(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flags) throws BaseException {
        QueryRequest request;
        SdbReply response;
        int flag;
        int newFlags = DBQuery.regulateFlags(flags);
        if (returnRows < 0L) {
            returnRows = -1L;
        }
        if (returnRows == 1L) {
            newFlags |= 0x200;
        }
        if ((flag = (response = this.sequoiadb.requestAndResponse(request = new QueryRequest(this.collectionFullName, matcher, selector, orderBy, hint, skipRows, returnRows, newFlags))).getFlag()) != 0) {
            if (flag == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            String msg = "matcher = " + matcher + ", selector = " + selector + ", orderBy = " + orderBy + ", hint = " + hint + ", skipRows = " + skipRows + ", returnRows = " + returnRows;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        return cursor;
    }

    public BSONObject queryOne(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, int flag) throws BaseException {
        DBCursor cursor = this.query(matcher, selector, orderBy, hint, 0L, 1L, flag |= 0x200);
        return cursor.getNext();
    }

    public BSONObject queryOne() throws BaseException {
        return this.queryOne(null, null, null, null, 0);
    }

    public DBCursor getIndexes() throws BaseException {
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Collection", (Object)this.collectionFullName);
        AdminRequest request = new AdminRequest("$get indexes", null, obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        int flags = response.getFlag();
        if (flags != 0) {
            if (flags == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            this.sequoiadb.throwIfError(response);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        return cursor;
    }

    private DBCursor _queryAndModify(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, BSONObject update, long skipRows, long returnRows, int flag, boolean isUpdate, boolean returnNew) throws BaseException {
        BasicBSONObject modify = new BasicBSONObject();
        if (isUpdate) {
            if (update == null || update.isEmpty()) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "update can't be empty");
            }
            modify.put("OP", (Object)"update");
            modify.put("Update", (Object)update);
            modify.put("ReturnNew", (Object)returnNew);
        } else {
            modify.put("OP", (Object)"remove");
            modify.put("Remove", (Object)true);
        }
        BasicBSONObject newHint = new BasicBSONObject();
        if (hint != null) {
            newHint.putAll(hint);
        }
        newHint.put("$Modify", (Object)modify);
        return this.query(matcher, selector, orderBy, newHint, skipRows, returnRows, flag |= 0x1000);
    }

    public DBCursor queryAndUpdate(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, BSONObject update, long skipRows, long returnRows, int flag, boolean returnNew) throws BaseException {
        return this._queryAndModify(matcher, selector, orderBy, hint, update, skipRows, returnRows, flag, true, returnNew);
    }

    public DBCursor queryAndRemove(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flag) throws BaseException {
        return this._queryAndModify(matcher, selector, orderBy, hint, null, skipRows, returnRows, flag, false, false);
    }

    public DBCursor getIndex(String name) throws BaseException {
        if (name == null) {
            return this.getIndexes();
        }
        BasicBSONObject condition = new BasicBSONObject();
        condition.put("IndexDef.name", (Object)name);
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Collection", (Object)this.collectionFullName);
        AdminRequest request = new AdminRequest("$get indexes", condition, obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        int flags = response.getFlag();
        if (flags != 0) {
            if (flags == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            this.sequoiadb.throwIfError(response);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        return new DBCursor(response, this.sequoiadb);
    }

    public BSONObject getIndexInfo(String name) throws BaseException {
        if (name == null || name.isEmpty()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "index name can not be null or empty");
        }
        BasicBSONObject condition = new BasicBSONObject();
        condition.put("IndexDef.name", (Object)name);
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Collection", (Object)this.collectionFullName);
        AdminRequest request = new AdminRequest("$get indexes", condition, obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        if (response.getFlag() != 0) {
            this.sequoiadb.throwIfError(response);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        try {
            if (cursor.hasNext()) {
                BSONObject retObj;
                BSONObject bSONObject = retObj = cursor.getNext();
                return bSONObject;
            }
            throw new BaseException(SDBError.SDB_IXM_NOTEXIST, "the specified index[" + name + "] does not exist");
        }
        finally {
            cursor.close();
        }
    }

    public boolean isIndexExist(String name) {
        BSONObject indexObj;
        if (name == null || name.isEmpty()) {
            return false;
        }
        try {
            indexObj = this.getIndexInfo(name);
        }
        catch (Exception e) {
            return false;
        }
        return indexObj != null;
    }

    public void createIndex(String name, BSONObject key, boolean isUnique, boolean enforced, int sortBufferSize) throws BaseException {
        if (sortBufferSize < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "sortBufferSize less than 0");
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("key", (Object)key);
        obj.put("name", (Object)name);
        obj.put("unique", (Object)isUnique);
        obj.put("enforced", (Object)enforced);
        BasicBSONObject createObj = new BasicBSONObject();
        createObj.put("Collection", (Object)this.collectionFullName);
        createObj.put("Index", (Object)obj);
        BasicBSONObject hint = new BasicBSONObject();
        hint.put("SortBufferSize", (Object)sortBufferSize);
        AdminRequest request = new AdminRequest("$create index", createObj, hint);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        if (response.getFlag() != 0) {
            String msg = "name = " + name + ", key = " + key + ", isUnique = " + isUnique;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void createIndex(String name, String key, boolean isUnique, boolean enforced, int sortBufferSize) throws BaseException {
        BSONObject k = null;
        if (key != null) {
            k = (BSONObject)JSON.parse(key);
        }
        this.createIndex(name, k, isUnique, enforced, sortBufferSize);
    }

    public void createIndex(String name, BSONObject key, boolean isUnique, boolean enforced) throws BaseException {
        this.createIndex(name, key, isUnique, enforced, 64);
    }

    public void createIndex(String name, String key, boolean isUnique, boolean enforced) throws BaseException {
        BSONObject k = null;
        if (key != null) {
            k = (BSONObject)JSON.parse(key);
        }
        this.createIndex(name, k, isUnique, enforced, 64);
    }

    public void dropIndex(String name) throws BaseException {
        BasicBSONObject index = new BasicBSONObject();
        index.put("", (Object)name);
        BasicBSONObject dropObj = new BasicBSONObject();
        dropObj.put("Collection", (Object)this.collectionFullName);
        dropObj.put("Index", (Object)index);
        AdminRequest request = new AdminRequest("$drop index", dropObj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, name);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public long getCount() throws BaseException {
        return this.getCount("");
    }

    public long getCount(String matcher) throws BaseException {
        BSONObject con = null;
        if (matcher != null) {
            con = (BSONObject)JSON.parse(matcher);
        }
        return this.getCount(con);
    }

    public long getCount(BSONObject matcher) throws BaseException {
        return this.getCount(matcher, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCount(BSONObject matcher, BSONObject hint) throws BaseException {
        BSONObject object;
        AdminRequest request;
        SdbReply response;
        BasicBSONObject newHint = new BasicBSONObject();
        newHint.put("Collection", (Object)this.collectionFullName);
        if (null != hint) {
            newHint.put("Hint", (Object)hint);
        }
        if ((response = this.sequoiadb.requestAndResponse(request = new AdminRequest("$get count", matcher, newHint))).getFlag() != 0) {
            String msg = "condition = " + matcher + ", hint = " + hint;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        try {
            object = cursor.getNext();
        }
        finally {
            cursor.close();
        }
        return (Long)object.get("Total");
    }

    public void split(String sourceGroupName, String destGroupName, BSONObject splitCondition, BSONObject splitEndCondition) throws BaseException {
        AdminRequest request;
        SdbReply response;
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || null == splitCondition) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "null parameter");
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitQuery", (Object)splitCondition);
        if (null != splitEndCondition) {
            obj.put("SplitEndQuery", (Object)splitEndCondition);
        }
        if ((response = this.sequoiadb.requestAndResponse(request = new AdminRequest("$split", obj))).getFlag() != 0) {
            String msg = "sourceGroupName = " + sourceGroupName + ", destGroupName = " + destGroupName + ", splitCondition = " + splitCondition + ", splitEndCondition = " + splitEndCondition;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void split(String sourceGroupName, String destGroupName, double percent) throws BaseException {
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || percent <= 0.0 || percent > 100.0) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitPercent", (Object)percent);
        AdminRequest request = new AdminRequest("$split", obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        if (response.getFlag() != 0) {
            String msg = "sourceGroupName = " + sourceGroupName + ", destGroupName = " + destGroupName + ", percent = " + percent;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long splitAsync(String sourceGroupName, String destGroupName, BSONObject splitCondition, BSONObject splitEndCondition) throws BaseException {
        BSONObject result;
        AdminRequest request;
        SdbReply response;
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || null == splitCondition) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Async", (Object)true);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitQuery", (Object)splitCondition);
        if (null != splitEndCondition) {
            obj.put("SplitEndQuery", (Object)splitEndCondition);
        }
        if ((response = this.sequoiadb.requestAndResponse(request = new AdminRequest("$split", obj))).getFlag() != 0) {
            String msg = "sourceGroupName = " + sourceGroupName + ", destGroupName = " + destGroupName + ", splitCondition = " + splitCondition + ", splitEndCondition = " + splitEndCondition;
            this.sequoiadb.throwIfError(response, msg);
        }
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        try {
            if (!cursor.hasNext()) {
                throw new BaseException(SDBError.SDB_CAT_TASK_NOTFOUND);
            }
            result = cursor.getNext();
        }
        finally {
            cursor.close();
        }
        boolean flag = result.containsField("TaskID");
        if (!flag) {
            throw new BaseException(SDBError.SDB_CAT_TASK_NOTFOUND);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        long taskid = (Long)result.get("TaskID");
        return taskid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long splitAsync(String sourceGroupName, String destGroupName, double percent) throws BaseException {
        BSONObject result;
        if (null == sourceGroupName || sourceGroupName.equals("") || null == destGroupName || destGroupName.equals("") || percent <= 0.0 || percent > 100.0) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)this.collectionFullName);
        obj.put("Async", (Object)true);
        obj.put("Source", (Object)sourceGroupName);
        obj.put("Target", (Object)destGroupName);
        obj.put("SplitPercent", (Object)percent);
        AdminRequest request = new AdminRequest("$split", obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        if (response.getFlag() != 0) {
            String msg = "sourceGroupName = " + sourceGroupName + ", destGroupName = " + destGroupName + ", percent = " + percent;
            this.sequoiadb.throwIfError(response, msg);
        }
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        try {
            if (!cursor.hasNext()) {
                throw new BaseException(SDBError.SDB_CAT_TASK_NOTFOUND);
            }
            result = cursor.getNext();
        }
        finally {
            cursor.close();
        }
        boolean flag = result.containsField("TaskID");
        if (!flag) {
            throw new BaseException(SDBError.SDB_CAT_TASK_NOTFOUND);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        long taskid = (Long)result.get("TaskID");
        return taskid;
    }

    public DBCursor aggregate(List<BSONObject> objs) throws BaseException {
        if (objs == null || objs.size() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        AggregateRequest request = new AggregateRequest(this.collectionFullName, objs);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        int flags = response.getFlag();
        if (flags != 0) {
            if (flags == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            this.sequoiadb.throwIfError(response, objs);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        return cursor;
    }

    public DBCursor getQueryMeta(BSONObject matcher, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows, int flag) throws BaseException {
        BasicBSONObject newHint = new BasicBSONObject();
        newHint.put("Collection", (Object)this.collectionFullName);
        if (null == hint || hint.isEmpty()) {
            BasicBSONObject empty = new BasicBSONObject();
            newHint.put("Hint", (Object)empty);
        } else {
            newHint.put("Hint", (Object)hint);
        }
        QueryRequest request = new QueryRequest("$get querymeta", matcher, null, orderBy, newHint, skipRows, returnRows, flag);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        int flags = response.getFlag();
        if (flags != 0) {
            if (flags == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            String msg = "query = " + matcher + ", hint = " + hint + ", orderBy = " + orderBy + ", skipRows = " + skipRows + ", returnRows = " + returnRows;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        return cursor;
    }

    public void attachCollection(String subClFullName, BSONObject options) throws BaseException {
        if (null == subClFullName || subClFullName.equals("") || null == options || null == this.collectionFullName || this.collectionFullName.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "sub collection name or options is empty or null");
        }
        BasicBSONObject newOptions = new BasicBSONObject();
        newOptions.put("Name", (Object)this.collectionFullName);
        newOptions.put("SubCLName", (Object)subClFullName);
        newOptions.putAll(options);
        AdminRequest request = new AdminRequest("$link collection", newOptions);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        if (response.getFlag() != 0) {
            String msg = "subCollectionName = " + subClFullName + ", options = " + options;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void detachCollection(String subClFullName) throws BaseException {
        if (null == subClFullName || subClFullName.equals("") || null == this.collectionFullName || this.collectionFullName.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG, subClFullName);
        }
        BasicBSONObject options = new BasicBSONObject();
        options.put("Name", (Object)this.collectionFullName);
        options.put("SubCLName", (Object)subClFullName);
        AdminRequest request = new AdminRequest("$unlink collection", options);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, subClFullName);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    private void alterInternal(String taskName, BSONObject options, boolean allowNullArgs) throws BaseException {
        if (null == options && !allowNullArgs) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        BasicBSONObject argumentObj = new BasicBSONObject();
        argumentObj.put("Name", (Object)taskName);
        argumentObj.put("Args", (Object)options);
        BasicBSONObject alterObject = new BasicBSONObject();
        alterObject.put("Alter", (Object)argumentObj);
        this.alterCollection(alterObject);
    }

    public void alterCollection(BSONObject options) throws BaseException {
        if (null == options) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        BasicBSONObject newObj = new BasicBSONObject();
        if (!options.containsField("Alter")) {
            newObj.put("Name", (Object)this.collectionFullName);
            newObj.put("Options", (Object)options);
        } else {
            Object tmpAlter = options.get("Alter");
            if (!(tmpAlter instanceof BasicBSONObject) && !(tmpAlter instanceof BasicBSONList)) {
                throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
            }
            newObj.put("Alter", tmpAlter);
            newObj.put("AlterType", (Object)"collection");
            newObj.put("Version", (Object)1);
            newObj.put("Name", (Object)this.collectionFullName);
            if (options.containsField("Options")) {
                Object tmpOptions = options.get("Options");
                if (tmpOptions instanceof BasicBSONObject) {
                    newObj.put("Options", tmpOptions);
                } else {
                    throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
                }
            }
        }
        AdminRequest request = new AdminRequest("$alter collection", newObj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, options);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void createIdIndex(BSONObject options) throws BaseException {
        this.alterInternal("create id index", options, true);
    }

    public void dropIdIndex() throws BaseException {
        this.alterInternal("drop id index", null, true);
    }

    public void enableSharding(BSONObject options) throws BaseException {
        this.alterInternal("enable sharding", options, false);
    }

    public void disableSharding() throws BaseException {
        this.alterInternal("disable sharding", null, true);
    }

    public void enableCompression(BSONObject options) throws BaseException {
        this.alterInternal("enable compression", options, true);
    }

    public void disableCompression() throws BaseException {
        this.alterInternal("disable compression", null, true);
    }

    public void setAttributes(BSONObject options) throws BaseException {
        this.alterInternal("set attributes", options, false);
    }

    private void _update(int flag, BSONObject matcher, BSONObject modifier, BSONObject hint) throws BaseException {
        UpdateRequest request = new UpdateRequest(this.collectionFullName, matcher, modifier, hint, flag);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        if (response.getFlag() != 0) {
            String msg = "matcher = " + matcher + ", modifier = " + modifier + ", hint = " + hint;
            this.sequoiadb.throwIfError(response, msg);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public DBCursor listLobs() throws BaseException {
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Collection", (Object)this.collectionFullName);
        AdminRequest request = new AdminRequest("$list lobs", obj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag != 0) {
            if (flag == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            this.sequoiadb.throwIfError(response);
        }
        this.sequoiadb.upsertCache(this.collectionFullName);
        DBCursor cursor = new DBCursor(response, this.sequoiadb);
        return cursor;
    }

    public DBLob createLob() throws BaseException {
        return this.createLob(null);
    }

    public DBLob createLob(ObjectId id) throws BaseException {
        DBLobImpl lob = new DBLobImpl(this);
        lob.open(id, 1);
        this.sequoiadb.upsertCache(this.collectionFullName);
        return lob;
    }

    public DBLob openLob(ObjectId id, int mode) throws BaseException {
        if (mode != 4 && mode != 8) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "mode is unsupported: " + mode);
        }
        DBLobImpl lob = new DBLobImpl(this);
        lob.open(id, mode);
        this.sequoiadb.upsertCache(this.collectionFullName);
        return lob;
    }

    public DBLob openLob(ObjectId id) throws BaseException {
        return this.openLob(id, 4);
    }

    public void removeLob(ObjectId lobId) throws BaseException {
        BasicBSONObject removeObj = new BasicBSONObject();
        removeObj.put("Collection", (Object)this.collectionFullName);
        removeObj.put("Oid", (Object)lobId);
        LobRemoveRequest request = new LobRemoveRequest(removeObj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, removeObj);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void truncateLob(ObjectId lobId, long length) throws BaseException {
        if (length < 0L) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Invalid length");
        }
        BasicBSONObject truncateObj = new BasicBSONObject();
        truncateObj.put("Collection", (Object)this.collectionFullName);
        truncateObj.put("Oid", (Object)lobId);
        truncateObj.put("Length", (Object)length);
        LobTruncateRequest request = new LobTruncateRequest(truncateObj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, truncateObj);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void truncate() throws BaseException {
        BasicBSONObject options = new BasicBSONObject();
        options.put("Collection", (Object)this.collectionFullName);
        AdminRequest request = new AdminRequest("$truncate", options);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, options);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }

    public void pop(BSONObject options) throws BaseException {
        if (options == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("Collection", (Object)this.collectionFullName);
        Object lidObj = options.get("LogicalID");
        if (!(lidObj instanceof Integer) && !(lidObj instanceof Long)) {
            throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
        }
        newObj.put("LogicalID", lidObj);
        Object directObj = options.get("Direction");
        if (directObj == null) {
            newObj.put("Direction", (Object)1);
        } else if (directObj instanceof Integer) {
            newObj.put("Direction", directObj);
        } else {
            throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
        }
        AdminRequest request = new AdminRequest("$pop", newObj);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, newObj);
        this.sequoiadb.upsertCache(this.collectionFullName);
    }
}

