/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.ReplicaGroup;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.response.SdbReply;
import org.bson.BasicBSONObject;

public class Node {
    private String hostName;
    private int port;
    private String nodeName;
    private int id;
    private ReplicaGroup rg;
    private Sequoiadb sequoiadb;

    Node(String hostName, int port, int nodeId, ReplicaGroup rg) {
        this.rg = rg;
        this.hostName = hostName;
        this.port = port;
        this.nodeName = hostName + ":" + port;
        this.id = nodeId;
    }

    public int getNodeId() {
        return this.id;
    }

    public ReplicaGroup getReplicaGroup() {
        return this.rg;
    }

    public void disconnect() throws BaseException {
        this.sequoiadb.disconnect();
    }

    public Sequoiadb connect() throws BaseException {
        if (this.sequoiadb != null && !this.sequoiadb.isClosed()) {
            this.sequoiadb.close();
        }
        this.sequoiadb = new Sequoiadb(this.hostName, this.port, this.rg.getSequoiadb().getUserName(), this.rg.getSequoiadb().getPassword());
        return this.sequoiadb;
    }

    public Sequoiadb connect(String username, String password) throws BaseException {
        if (this.sequoiadb != null && !this.sequoiadb.isClosed()) {
            this.sequoiadb.close();
        }
        this.sequoiadb = new Sequoiadb(this.hostName, this.port, username, password);
        return this.sequoiadb;
    }

    public Sequoiadb getSdb() {
        return this.sequoiadb;
    }

    public String getHostName() {
        return this.hostName;
    }

    public int getPort() {
        return this.port;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public NodeStatus getStatus() throws BaseException {
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("GroupID", (Object)this.rg.getId());
        obj.put("NodeID", (Object)this.id);
        AdminRequest request = new AdminRequest("$snapshot database", obj);
        SdbReply response = this.rg.getSequoiadb().requestAndResponse(request);
        int flag = response.getFlag();
        if (flag != 0) {
            if (flag == SDBError.SDB_NET_CANNOT_CONNECT.getErrorCode()) {
                return NodeStatus.SDB_NODE_INACTIVE;
            }
            this.rg.getSequoiadb().throwIfError(response);
        }
        return NodeStatus.SDB_NODE_ACTIVE;
    }

    public void start() throws BaseException {
        this.startStop(true);
    }

    public void stop() throws BaseException {
        this.startStop(false);
    }

    private void startStop(boolean start) {
        BasicBSONObject config = new BasicBSONObject();
        config.put("HostName", (Object)this.hostName);
        config.put("svcname", (Object)Integer.toString(this.port));
        String cmd = start ? "$startup node" : "$shutdown node";
        AdminRequest request = new AdminRequest(cmd, config);
        SdbReply response = this.rg.getSequoiadb().requestAndResponse(request);
        String msg = "node = " + this.hostName + ":" + this.port;
        this.rg.getSequoiadb().throwIfError(response, msg);
    }

    public static enum NodeStatus {
        SDB_NODE_ALL(1),
        SDB_NODE_ACTIVE(2),
        SDB_NODE_INACTIVE(3),
        SDB_NODE_UNKNOWN(4);

        private final int key;

        private NodeStatus(int key) {
            this.key = key;
        }

        public int getKey() {
            return this.key;
        }

        public static NodeStatus getByKey(int key) {
            NodeStatus nodeStatus = SDB_NODE_ALL;
            for (NodeStatus status : NodeStatus.values()) {
                if (status.getKey() != key) continue;
                nodeStatus = status;
                break;
            }
            return nodeStatus;
        }
    }
}

