/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.Node;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.response.SdbReply;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;

public class ReplicaGroup {
    private String name;
    private int id;
    private Sequoiadb sequoiadb;
    private boolean isCataRG;

    public Sequoiadb getSequoiadb() {
        return this.sequoiadb;
    }

    public int getId() {
        return this.id;
    }

    public String getGroupName() {
        return this.name;
    }

    ReplicaGroup(Sequoiadb sdb, int id) {
        this.sequoiadb = sdb;
        this.id = id;
        BSONObject group = sdb.getDetailById(id);
        this.name = group.get("GroupName").toString();
        this.isCataRG = this.name.equals("SYSCatalogGroup");
    }

    ReplicaGroup(Sequoiadb sdb, String name) {
        this.sequoiadb = sdb;
        this.name = name;
        BSONObject group = sdb.getDetailByName(name);
        this.isCataRG = name == "SYSCatalogGroup";
        this.id = Integer.parseInt(group.get("GroupID").toString());
    }

    public int getNodeNum(Node.NodeStatus status) throws BaseException {
        BSONObject group = this.sequoiadb.getDetailById(this.id);
        try {
            Object obj = group.get("Group");
            if (obj == null) {
                return 0;
            }
            BasicBSONList list = (BasicBSONList)obj;
            return list.size();
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BaseException(SDBError.SDB_SYS, (Throwable)e);
        }
    }

    public BSONObject getDetail() throws BaseException {
        return this.sequoiadb.getDetailById(this.id);
    }

    public Node getMaster() throws BaseException {
        Object nodeId;
        BSONObject groupInfoObj = this.sequoiadb.getDetailById(this.id);
        if (groupInfoObj == null) {
            throw new BaseException(SDBError.SDB_CLS_GRP_NOT_EXIST, String.format("no information of group id[%d]", this.id));
        }
        Object nodesInfoArr = groupInfoObj.get("Group");
        if (nodesInfoArr == null || !(nodesInfoArr instanceof BasicBSONList)) {
            throw new BaseException(SDBError.SDB_SYS, String.format("invalid content[%s] of field[%s]", nodesInfoArr == null ? "null" : nodesInfoArr.toString(), "Group"));
        }
        BasicBSONList nodesInfoList = (BasicBSONList)nodesInfoArr;
        if (nodesInfoList.isEmpty()) {
            throw new BaseException(SDBError.SDB_CLS_EMPTY_GROUP);
        }
        Object primaryNodeObj = groupInfoObj.get("PrimaryNode");
        if (primaryNodeObj == null) {
            throw new BaseException(SDBError.SDB_RTN_NO_PRIMARY_FOUND);
        }
        if (!(primaryNodeObj instanceof Number)) {
            throw new BaseException(SDBError.SDB_SYS, "invalid primary node's information: " + primaryNodeObj.toString());
        }
        if (primaryNodeObj.equals(-1)) {
            throw new BaseException(SDBError.SDB_RTN_NO_PRIMARY_FOUND);
        }
        BSONObject primaryData = null;
        for (Object nodeInfoObj : nodesInfoList) {
            BSONObject nodeInfo = (BSONObject)nodeInfoObj;
            nodeId = nodeInfo.get("NodeID");
            if (nodeId == null) {
                throw new BaseException(SDBError.SDB_SYS, "node id can not be null");
            }
            if (!nodeId.equals(primaryNodeObj)) continue;
            primaryData = nodeInfo;
            break;
        }
        if (primaryData == null) {
            throw new BaseException(SDBError.SDB_SYS, "no information about the primary node in node array");
        }
        nodeId = primaryData.get("NodeID");
        if (nodeId == null || !(nodeId instanceof Number)) {
            throw new BaseException(SDBError.SDB_SYS, String.format("invalid content[%s] of field[%s]", nodeId == null ? "null" : nodeId.toString(), "NodeID"));
        }
        Object hostNameObj = primaryData.get("HostName");
        if (hostNameObj == null || !(hostNameObj instanceof String)) {
            throw new BaseException(SDBError.SDB_SYS, String.format("invalid content[%s] of field[%s]", hostNameObj == null ? "null" : hostNameObj.toString(), "HostName"));
        }
        String hostName = hostNameObj.toString();
        int port = this.getNodePort(primaryData);
        return new Node(hostName, port, Integer.parseInt(nodeId.toString()), this);
    }

    public Node getSlave() throws BaseException {
        ArrayList<Integer> list = new ArrayList<Integer>();
        return this.getSlave(list);
    }

    public Node getSlave(int ... positions) throws BaseException {
        ArrayList<Integer> list = null;
        if (positions == null || positions.length == 0) {
            return this.getSlave(list);
        }
        list = new ArrayList<Integer>();
        for (int pos : positions) {
            list.add(pos);
        }
        return this.getSlave(list);
    }

    public Node getSlave(Collection<Integer> positions) throws BaseException {
        boolean needGeneratePosition = false;
        ArrayList<Integer> validPositions = new ArrayList<Integer>();
        if (positions == null || positions.size() == 0) {
            needGeneratePosition = true;
        } else {
            for (int pos : positions) {
                if (pos < 1 || pos > 7) {
                    throw new BaseException(SDBError.SDB_INVALIDARG, String.format("invalid position(%d) in the list", pos));
                }
                if (validPositions.contains(pos)) continue;
                validPositions.add(pos);
            }
            if (validPositions.size() < 1 || validPositions.size() > 7) {
                throw new BaseException(SDBError.SDB_INVALIDARG, String.format("the number of valid position in the list is %d, it should be in [1, 7]", validPositions.size()));
            }
        }
        BSONObject groupInfoObj = this.sequoiadb.getDetailById(this.id);
        if (groupInfoObj == null) {
            throw new BaseException(SDBError.SDB_CLS_GRP_NOT_EXIST, String.format("no information of group id[%d]", this.id));
        }
        Object nodesInfoArr = groupInfoObj.get("Group");
        if (nodesInfoArr == null || !(nodesInfoArr instanceof BasicBSONList)) {
            throw new BaseException(SDBError.SDB_SYS, String.format("invalid content[%s] of field[%s]", nodesInfoArr == null ? "null" : nodesInfoArr.toString(), "Group"));
        }
        BasicBSONList nodesInfoList = (BasicBSONList)nodesInfoArr;
        if (nodesInfoList.isEmpty()) {
            throw new BaseException(SDBError.SDB_CLS_EMPTY_GROUP);
        }
        Object primaryNodeId = groupInfoObj.get("PrimaryNode");
        boolean hasPrimary = true;
        if (primaryNodeId == null) {
            hasPrimary = false;
        } else {
            if (!(primaryNodeId instanceof Number)) {
                throw new BaseException(SDBError.SDB_SYS, "invalid primary node's information: " + primaryNodeId.toString());
            }
            if (primaryNodeId.equals(-1)) {
                hasPrimary = false;
            }
        }
        int primaryNodePosition = 0;
        for (int i = 0; i < nodesInfoList.size(); ++i) {
            BSONObject nodeInfo = (BSONObject)nodesInfoList.get(i);
            Object nodeIdValue = nodeInfo.get("NodeID");
            if (nodeIdValue == null) {
                throw new BaseException(SDBError.SDB_SYS, "node id can not be null");
            }
            if (!hasPrimary || !nodeIdValue.equals(primaryNodeId)) continue;
            primaryNodePosition = i + 1;
        }
        if (hasPrimary && primaryNodePosition == 0) {
            throw new BaseException(SDBError.SDB_SYS, "have no primary node in nodes list");
        }
        int nodeCount = nodesInfoList.size();
        if (needGeneratePosition) {
            for (int i = 0; i < nodeCount; ++i) {
                if (hasPrimary && primaryNodePosition == i + 1) continue;
                validPositions.add(i + 1);
            }
        }
        int nodeIndex = -1;
        BSONObject nodeInfoObj = null;
        if (nodeCount == 1) {
            nodeInfoObj = (BSONObject)nodesInfoList.get(0);
        } else if (validPositions.size() == 1) {
            nodeIndex = ((Integer)validPositions.get(0) - 1) % nodeCount;
            nodeInfoObj = (BSONObject)nodesInfoList.get(nodeIndex);
        } else {
            int position = 0;
            Random rand = new Random();
            int[] flags = new int[7];
            ArrayList<Integer> includePrimaryPositions = new ArrayList<Integer>();
            ArrayList<Integer> excludePrimaryPositions = new ArrayList<Integer>();
            Iterator iterator = validPositions.iterator();
            while (iterator.hasNext()) {
                int pos = (Integer)iterator.next();
                if (pos <= nodeCount) {
                    nodeIndex = pos - 1;
                    if (flags[nodeIndex] != 0) continue;
                    flags[nodeIndex] = 1;
                    includePrimaryPositions.add(pos);
                    if (!hasPrimary || primaryNodePosition == pos) continue;
                    excludePrimaryPositions.add(pos);
                    continue;
                }
                nodeIndex = (pos - 1) % nodeCount;
                if (flags[nodeIndex] != 0) continue;
                flags[nodeIndex] = 1;
                includePrimaryPositions.add(pos);
                if (!hasPrimary || primaryNodePosition == nodeIndex + 1) continue;
                excludePrimaryPositions.add(pos);
            }
            if (excludePrimaryPositions.size() > 0) {
                position = rand.nextInt(excludePrimaryPositions.size());
                position = (Integer)excludePrimaryPositions.get(position);
            } else {
                position = rand.nextInt(includePrimaryPositions.size());
                position = (Integer)includePrimaryPositions.get(position);
                if (needGeneratePosition) {
                    ++position;
                }
            }
            nodeIndex = (position - 1) % nodeCount;
            nodeInfoObj = (BSONObject)nodesInfoList.get(nodeIndex);
        }
        int nodeId = Integer.parseInt(nodeInfoObj.get("NodeID").toString());
        String hostName = nodeInfoObj.get("HostName").toString();
        int port = this.getNodePort(nodeInfoObj);
        return new Node(hostName, port, nodeId, this);
    }

    public boolean isNodeExist(String nodeName) {
        try {
            this.getNode(nodeName);
        }
        catch (BaseException e) {
            return false;
        }
        return true;
    }

    public boolean isNodeExist(String hostName, int port) {
        try {
            this.getNode(hostName, port);
        }
        catch (BaseException e) {
            return false;
        }
        return true;
    }

    public Node getNode(String nodeName) throws BaseException {
        if (nodeName == null || nodeName.isEmpty()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, nodeName);
        }
        String[] nodeMetaInfoArray = nodeName.split(":");
        if (nodeMetaInfoArray.length != 2) {
            throw new BaseException(SDBError.SDB_INVALIDARG, nodeName);
        }
        String inputHostName = nodeMetaInfoArray[0];
        int inputPort = Integer.parseInt(nodeMetaInfoArray[1]);
        Node node = this.getNodeByMetaInfo(inputHostName, inputPort);
        if (node != null) {
            return node;
        }
        throw new BaseException(SDBError.SDB_CLS_NODE_NOT_EXIST, nodeName);
    }

    public Node getNode(String hostName, int port) throws BaseException {
        Node node = this.getNodeByMetaInfo(hostName, port);
        if (node != null) {
            return node;
        }
        throw new BaseException(SDBError.SDB_CLS_NODE_NOT_EXIST, hostName + ":" + port);
    }

    public Node attachNode(String hostName, int port, BSONObject configure) throws BaseException {
        BasicBSONObject config = new BasicBSONObject();
        config.put("GroupName", (Object)this.name);
        config.put("HostName", (Object)hostName);
        config.put("svcname", (Object)Integer.toString(port));
        config.put("OnlyAttach", (Object)true);
        if (configure != null) {
            for (String key : configure.keySet()) {
                if (key.equals("GroupName") || key.equals("HostName") || key.equals("svcname") || key.equals("OnlyAttach")) continue;
                config.put(key, configure.get(key));
            }
        }
        AdminRequest request = new AdminRequest("$create node", config);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        String msg = "node = " + hostName + ":" + port + ", configure = " + configure;
        this.sequoiadb.throwIfError(response, msg);
        return this.getNode(hostName, port);
    }

    public void detachNode(String hostName, int port, BSONObject configure) throws BaseException {
        BasicBSONObject config = new BasicBSONObject();
        config.put("GroupName", (Object)this.name);
        config.put("HostName", (Object)hostName);
        config.put("svcname", (Object)Integer.toString(port));
        config.put("OnlyDetach", (Object)true);
        if (configure != null) {
            for (String key : configure.keySet()) {
                if (key.equals("GroupName") || key.equals("HostName") || key.equals("svcname") || key.equals("OnlyDetach")) continue;
                config.put(key, configure.get(key));
            }
        }
        AdminRequest request = new AdminRequest("$remove node", config);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        String msg = "node = " + hostName + ":" + port + ", configure = " + configure;
        this.sequoiadb.throwIfError(response, msg);
    }

    public Node createNode(String hostName, int port, String dbPath, Map<String, String> configure) throws BaseException {
        BasicBSONObject obj = new BasicBSONObject();
        if (configure != null) {
            for (String key : configure.keySet()) {
                obj.put(key, (Object)configure.get(key));
            }
        }
        return this.createNode(hostName, port, dbPath, obj);
    }

    public Node createNode(String hostName, int port, String dbPath) throws BaseException {
        return this.createNode(hostName, port, dbPath, new BasicBSONObject());
    }

    public Node createNode(String hostName, int port, String dbPath, BSONObject configure) throws BaseException {
        BasicBSONObject config = new BasicBSONObject();
        config.put("GroupName", (Object)this.name);
        config.put("HostName", (Object)hostName);
        config.put("svcname", (Object)Integer.toString(port));
        config.put("dbpath", (Object)dbPath);
        if (configure != null && !configure.isEmpty()) {
            for (String key : configure.keySet()) {
                if (key.equals("GroupName") || key.equals("HostName") || key.equals("svcname")) continue;
                config.put(key, configure.get(key));
            }
        }
        AdminRequest request = new AdminRequest("$create node", config);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        String msg = "node = " + hostName + ":" + port + ", dbPath = " + dbPath + ", configure = " + configure;
        this.sequoiadb.throwIfError(response, msg);
        return this.getNode(hostName, port);
    }

    public void removeNode(String hostName, int port, BSONObject configure) throws BaseException {
        BasicBSONObject config = new BasicBSONObject();
        config.put("GroupName", (Object)this.name);
        config.put("HostName", (Object)hostName);
        config.put("svcname", (Object)Integer.toString(port));
        if (configure != null) {
            for (String key : configure.keySet()) {
                if (key.equals("GroupName") || key.equals("HostName") || key.equals("svcname")) continue;
                config.put(key, configure.get(key));
            }
        }
        AdminRequest request = new AdminRequest("$remove node", config);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        String msg = "node = " + hostName + ":" + port + ", configure = " + configure;
        this.sequoiadb.throwIfError(response, msg);
    }

    public void start() throws BaseException {
        BasicBSONObject groupName = new BasicBSONObject();
        groupName.put("GroupName", (Object)this.name);
        AdminRequest request = new AdminRequest("$active group", groupName);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, this.name);
    }

    public void stop() throws BaseException {
        BasicBSONObject groupName = new BasicBSONObject();
        groupName.put("GroupName", (Object)this.name);
        AdminRequest request = new AdminRequest("$shutdown group", groupName);
        SdbReply response = this.sequoiadb.requestAndResponse(request);
        this.sequoiadb.throwIfError(response, this.name);
    }

    public boolean isCatalog() {
        return this.isCataRG;
    }

    private Node getNodeByMetaInfo(String inputHostName, int inputPort) {
        if (inputHostName == null || inputHostName.isEmpty() || inputPort < 0 || inputPort > 65535) {
            throw new BaseException(SDBError.SDB_INVALIDARG, String.format("invalid node info[%s:%d]", inputHostName, inputPort));
        }
        BSONObject groupInfoObj = this.sequoiadb.getDetailById(this.id);
        if (groupInfoObj == null) {
            throw new BaseException(SDBError.SDB_CLS_GRP_NOT_EXIST, String.format("no information of group id[%d]", this.id));
        }
        Object nodesInfoArr = groupInfoObj.get("Group");
        if (nodesInfoArr == null || !(nodesInfoArr instanceof BasicBSONList)) {
            throw new BaseException(SDBError.SDB_SYS, String.format("invalid content[%s] of field[%s]", nodesInfoArr == null ? "null" : nodesInfoArr.toString(), "Group"));
        }
        BasicBSONList nodesInfoList = (BasicBSONList)nodesInfoArr;
        if (nodesInfoList.size() == 0) {
            return null;
        }
        Object nodeIdFromCatalog = null;
        String hostNameFromCatalog = null;
        int portFromCatalog = -1;
        for (Object nodeInfoObj : nodesInfoList) {
            BSONObject nodeInfo = (BSONObject)nodeInfoObj;
            nodeIdFromCatalog = nodeInfo.get("NodeID");
            hostNameFromCatalog = (String)nodeInfo.get("HostName");
            portFromCatalog = this.getNodePort(nodeInfo);
            if (nodeIdFromCatalog == null || hostNameFromCatalog == null) {
                throw new BaseException(SDBError.SDB_SYS, "invalid node's information");
            }
            if (!hostNameFromCatalog.equals(inputHostName) || portFromCatalog != inputPort) continue;
            return new Node(inputHostName, inputPort, Integer.parseInt(nodeIdFromCatalog.toString()), this);
        }
        return null;
    }

    private int getNodePort(BSONObject node) {
        if (node == null) {
            throw new BaseException(SDBError.SDB_SYS, "invalid information of node");
        }
        Object services = node.get("Service");
        if (services == null) {
            throw new BaseException(SDBError.SDB_SYS, node.toString());
        }
        BasicBSONList serviceInfos = (BasicBSONList)services;
        if (serviceInfos.size() == 0) {
            throw new BaseException(SDBError.SDB_SYS, node.toString());
        }
        int port = -1;
        for (Object obj : serviceInfos) {
            BSONObject service = (BSONObject)obj;
            if (!service.get("Type").toString().equals("0")) continue;
            port = Integer.parseInt(service.get("Name").toString());
            break;
        }
        if (port == -1) {
            throw new BaseException(SDBError.SDB_SYS, node.toString());
        }
        return port;
    }
}

