/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.base;

import com.sequoiadb.base.ClientOptions;
import com.sequoiadb.base.CollectionSpace;
import com.sequoiadb.base.ConfigOptions;
import com.sequoiadb.base.DBCursor;
import com.sequoiadb.base.Domain;
import com.sequoiadb.base.ReplicaGroup;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.ResultSet;
import com.sequoiadb.message.request.AdminRequest;
import com.sequoiadb.message.request.AuthRequest;
import com.sequoiadb.message.request.DisconnectRequest;
import com.sequoiadb.message.request.InterruptRequest;
import com.sequoiadb.message.request.KillContextRequest;
import com.sequoiadb.message.request.MessageRequest;
import com.sequoiadb.message.request.QueryRequest;
import com.sequoiadb.message.request.Request;
import com.sequoiadb.message.request.SQLRequest;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.message.request.SysInfoRequest;
import com.sequoiadb.message.request.TransactionRequest;
import com.sequoiadb.message.response.CommonResponse;
import com.sequoiadb.message.response.SdbReply;
import com.sequoiadb.message.response.SdbResponse;
import com.sequoiadb.message.response.SysInfoResponse;
import com.sequoiadb.net.IConnection;
import com.sequoiadb.net.ServerAddress;
import com.sequoiadb.net.TCPConnection;
import java.io.Closeable;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;
import org.bson.types.Code;
import org.bson.util.JSON;

public class Sequoiadb
implements Closeable {
    private InetSocketAddress socketAddress;
    private IConnection connection;
    private String userName;
    private String password;
    private ByteOrder byteOrder = ByteOrder.BIG_ENDIAN;
    private long requestId;
    private long lastUseTime;
    private Map<String, Long> nameCache = new HashMap<String, Long>();
    private static boolean enableCache = true;
    private static long cacheInterval = 300000L;
    private BSONObject attributeCache = null;
    private static final String DEFAULT_HOST = "127.0.0.1";
    private static final int DEFAULT_PORT = 11810;
    public static final int SDB_PAGESIZE_4K = 4096;
    public static final int SDB_PAGESIZE_8K = 8192;
    public static final int SDB_PAGESIZE_16K = 16384;
    public static final int SDB_PAGESIZE_32K = 32768;
    public static final int SDB_PAGESIZE_64K = 65536;
    public static final int SDB_PAGESIZE_DEFAULT = 0;
    public static final int SDB_LIST_CONTEXTS = 0;
    public static final int SDB_LIST_CONTEXTS_CURRENT = 1;
    public static final int SDB_LIST_SESSIONS = 2;
    public static final int SDB_LIST_SESSIONS_CURRENT = 3;
    public static final int SDB_LIST_COLLECTIONS = 4;
    public static final int SDB_LIST_COLLECTIONSPACES = 5;
    public static final int SDB_LIST_STORAGEUNITS = 6;
    public static final int SDB_LIST_GROUPS = 7;
    public static final int SDB_LIST_STOREPROCEDURES = 8;
    public static final int SDB_LIST_DOMAINS = 9;
    public static final int SDB_LIST_TASKS = 10;
    public static final int SDB_LIST_TRANSACTIONS = 11;
    public static final int SDB_LIST_TRANSACTIONS_CURRENT = 12;
    public static final int SDB_LIST_CL_IN_DOMAIN = 129;
    public static final int SDB_LIST_CS_IN_DOMAIN = 130;
    public static final int SDB_SNAP_CONTEXTS = 0;
    public static final int SDB_SNAP_CONTEXTS_CURRENT = 1;
    public static final int SDB_SNAP_SESSIONS = 2;
    public static final int SDB_SNAP_SESSIONS_CURRENT = 3;
    public static final int SDB_SNAP_COLLECTIONS = 4;
    public static final int SDB_SNAP_COLLECTIONSPACES = 5;
    public static final int SDB_SNAP_DATABASE = 6;
    public static final int SDB_SNAP_SYSTEM = 7;
    public static final int SDB_SNAP_CATALOG = 8;
    public static final int SDB_SNAP_TRANSACTIONS = 9;
    public static final int SDB_SNAP_TRANSACTIONS_CURRENT = 10;
    public static final int SDB_SNAP_ACCESSPLANS = 11;
    public static final int SDB_SNAP_HEALTH = 12;
    public static final int SDB_SNAP_CONFIGS = 13;
    public static final int FMP_FUNC_TYPE_INVALID = -1;
    public static final int FMP_FUNC_TYPE_JS = 0;
    public static final int FMP_FUNC_TYPE_C = 1;
    public static final int FMP_FUNC_TYPE_JAVA = 2;
    public static final String CATALOG_GROUP_NAME = "SYSCatalogGroup";

    void upsertCache(String name) {
        if (name == null) {
            return;
        }
        if (enableCache) {
            long current = System.currentTimeMillis();
            this.nameCache.put(name, current);
            String[] arr = name.split("\\.");
            if (arr.length > 1) {
                this.nameCache.put(arr[0], current);
            }
        }
    }

    void removeCache(String name) {
        if (name == null) {
            return;
        }
        String[] arr = name.split("\\.");
        if (arr.length == 1) {
            this.nameCache.remove(name);
            Set<String> keySet = this.nameCache.keySet();
            ArrayList<String> list = new ArrayList<String>();
            for (String str : keySet) {
                String[] nameArr = str.split("\\.");
                if (nameArr.length <= 1 || !nameArr[0].equals(name)) continue;
                list.add(str);
            }
            if (list.size() != 0) {
                for (String str : list) {
                    this.nameCache.remove(str);
                }
            }
        } else {
            this.nameCache.remove(name);
        }
    }

    boolean fetchCache(String name) {
        if (enableCache) {
            if (this.nameCache.containsKey(name)) {
                long lastUpdatedTime = this.nameCache.get(name);
                if (System.currentTimeMillis() - lastUpdatedTime >= cacheInterval) {
                    this.nameCache.remove(name);
                    return false;
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public static void initClient(ClientOptions options) {
        enableCache = options != null ? options.getEnableCache() : true;
        cacheInterval = options != null && options.getCacheInterval() >= 0L ? options.getCacheInterval() : 300000L;
    }

    @Deprecated
    public ServerAddress getServerAddress() {
        return new ServerAddress(this.socketAddress);
    }

    public String getHost() {
        return this.socketAddress.getHostName();
    }

    public String getIP() {
        return this.socketAddress.getAddress().getHostAddress();
    }

    public int getPort() {
        return this.socketAddress.getPort();
    }

    public String getNodeName() {
        return this.getIP() + ":" + this.getPort();
    }

    public String toString() {
        return String.format("%s:%d", this.getHost(), this.getPort());
    }

    @Deprecated
    public boolean isEndianConvert() {
        return this.byteOrder == ByteOrder.BIG_ENDIAN;
    }

    public ByteOrder getByteOrder() {
        return this.byteOrder;
    }

    public long getLastUseTime() {
        return this.lastUseTime;
    }

    @Deprecated
    public Sequoiadb(String username, String password) throws BaseException {
        this(DEFAULT_HOST, 11810, username, password, null);
    }

    public Sequoiadb(String connString, String username, String password) throws BaseException {
        this(connString, username, password, (ConfigOptions)null);
    }

    public Sequoiadb(String connString, String username, String password, ConfigOptions options) throws BaseException {
        this.init(connString, username, password, options);
    }

    @Deprecated
    public Sequoiadb(String connString, String username, String password, com.sequoiadb.net.ConfigOptions options) throws BaseException {
        this(connString, username, password, (ConfigOptions)options);
    }

    public Sequoiadb(List<String> connStrings, String username, String password, ConfigOptions options) throws BaseException {
        if (connStrings == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "connStrings is null");
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String str : connStrings) {
            if (str == null || str.isEmpty()) continue;
            list.add(str);
        }
        if (0 == list.size()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Address list has no valid address");
        }
        if (options == null) {
            options = new ConfigOptions();
        }
        Random random = new Random();
        while (list.size() > 0) {
            int index = random.nextInt(list.size());
            String str = (String)list.get(index);
            try {
                this.init(str, username, password, options);
                return;
            }
            catch (BaseException e) {
                if (e.getErrorCode() == SDBError.SDB_AUTH_AUTHORITY_FORBIDDEN.getErrorCode()) {
                    throw e;
                }
                list.remove(index);
            }
        }
        throw new BaseException(SDBError.SDB_NET_CANNOT_CONNECT, "No valid address");
    }

    @Deprecated
    public Sequoiadb(List<String> connStrings, String username, String password, com.sequoiadb.net.ConfigOptions options) throws BaseException {
        this(connStrings, username, password, (ConfigOptions)options);
    }

    public Sequoiadb(String host, int port, String username, String password) throws BaseException {
        this(host, port, username, password, null);
    }

    public Sequoiadb(String host, int port, String username, String password, ConfigOptions options) throws BaseException {
        this.init(host, port, username, password, options);
    }

    @Deprecated
    public Sequoiadb(String host, int port, String username, String password, com.sequoiadb.net.ConfigOptions options) throws BaseException {
        this(host, port, username, password, (ConfigOptions)options);
    }

    private void init(String host, int port, String username, String password, ConfigOptions options) throws BaseException {
        if (host == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "host is null");
        }
        if (options == null) {
            options = new ConfigOptions();
        }
        InetSocketAddress socketAddress = new InetSocketAddress(host, port);
        this.connection = new TCPConnection(socketAddress, options);
        this.connection.connect();
        this.byteOrder = this.getSysInfo();
        this.authenticate(username, password);
        this.socketAddress = socketAddress;
        this.userName = username;
        this.password = password;
    }

    private void init(String connString, String username, String password, ConfigOptions options) {
        String[] tmp;
        if (connString == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "connString is null");
        }
        if (connString.indexOf(":") > 0) {
            tmp = connString.split(":");
            if (tmp.length != 2) {
                throw new BaseException(SDBError.SDB_INVALIDARG, String.format("Invalid connString: %s", connString));
            }
        } else {
            throw new BaseException(SDBError.SDB_INVALIDARG, String.format("Invalid connString: %s", connString));
        }
        String host = tmp[0].trim();
        int port = Integer.parseInt(tmp[1].trim());
        this.init(host, port, username, password, options);
    }

    private void authenticate(String username, String password) {
        AuthRequest request = new AuthRequest(username, password, AuthRequest.AuthType.Verify);
        SdbReply response = this.requestAndResponse(request);
        try {
            this.throwIfError(response, "failed to authenticate " + this.userName);
        }
        catch (BaseException e) {
            this.close();
            throw e;
        }
    }

    public void createUser(String username, String password) throws BaseException {
        if (username == null || username.length() == 0 || password == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        AuthRequest request = new AuthRequest(username, password, AuthRequest.AuthType.CreateUser);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response, username);
    }

    public void removeUser(String username, String password) throws BaseException {
        AuthRequest request = new AuthRequest(username, password, AuthRequest.AuthType.DeleteUser);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response, username);
    }

    @Deprecated
    public void disconnect() throws BaseException {
        this.close();
    }

    public void releaseResource() throws BaseException {
        this.closeAllCursors();
        this.attributeCache = null;
    }

    public boolean isClosed() {
        if (this.connection == null) {
            return true;
        }
        return this.connection.isClosed();
    }

    public boolean isValid() throws BaseException {
        if (this.isClosed()) {
            return false;
        }
        try {
            this.killContext();
        }
        catch (BaseException e) {
            return false;
        }
        return true;
    }

    @Deprecated
    public void changeConnectionOptions(ConfigOptions options) throws BaseException {
        if (options == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "options is null");
        }
        this.close();
        this.init(this.getHost(), this.getPort(), this.userName, this.password, options);
    }

    public CollectionSpace createCollectionSpace(String csName) throws BaseException {
        return this.createCollectionSpace(csName, 0);
    }

    public CollectionSpace createCollectionSpace(String csName, int pageSize) throws BaseException {
        BasicBSONObject options = new BasicBSONObject();
        options.put("PageSize", (Object)pageSize);
        return this.createCollectionSpace(csName, options);
    }

    public CollectionSpace createCollectionSpace(String csName, BSONObject options) throws BaseException {
        if (csName == null || csName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, csName);
        }
        if (this.isCollectionSpaceExist(csName)) {
            throw new BaseException(SDBError.SDB_DMS_CS_EXIST, csName);
        }
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("Name", (Object)csName);
        if (null != options) {
            obj.putAll(options);
        }
        AdminRequest request = new AdminRequest("$create collectionspace", obj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
        this.upsertCache(csName);
        return new CollectionSpace(this, csName);
    }

    public void dropCollectionSpace(String csName) throws BaseException {
        if (!this.isCollectionSpaceExist(csName)) {
            throw new BaseException(SDBError.SDB_DMS_CS_NOTEXIST, csName);
        }
        BasicBSONObject options = new BasicBSONObject();
        options.put("Name", (Object)csName);
        AdminRequest request = new AdminRequest("$drop collectionspace", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
        this.removeCache(csName);
    }

    public void loadCollectionSpace(String csName, BSONObject options) throws BaseException {
        if (csName == null || csName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, csName);
        }
        if (this.isCollectionSpaceExist(csName)) {
            throw new BaseException(SDBError.SDB_DMS_CS_EXIST, csName);
        }
        BasicBSONObject newOptions = new BasicBSONObject();
        newOptions.put("Name", (Object)csName);
        if (options != null) {
            newOptions.putAll(options);
        }
        AdminRequest request = new AdminRequest("$load collectionspace", newOptions);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
        this.upsertCache(csName);
    }

    public void unloadCollectionSpace(String csName, BSONObject options) throws BaseException {
        if (csName == null || csName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, csName);
        }
        if (!this.isCollectionSpaceExist(csName)) {
            throw new BaseException(SDBError.SDB_DMS_CS_NOTEXIST, csName);
        }
        BasicBSONObject newOptions = new BasicBSONObject();
        newOptions.put("Name", (Object)csName);
        if (options != null) {
            newOptions.putAll(options);
        }
        AdminRequest request = new AdminRequest("$unload collectionspace", newOptions);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
        this.removeCache(csName);
    }

    public void renameCollectionSpace(String oldName, String newName) throws BaseException {
        if (oldName == null || oldName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, oldName);
        }
        if (newName == null || newName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, newName);
        }
        if (!this.isCollectionSpaceExist(oldName)) {
            throw new BaseException(SDBError.SDB_DMS_CS_NOTEXIST, oldName);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        matcher.put("OldName", (Object)oldName);
        matcher.put("NewName", (Object)newName);
        AdminRequest request = new AdminRequest("$rename collectionspace", matcher);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
        this.removeCache(oldName);
        this.upsertCache(newName);
    }

    public void sync(BSONObject options) throws BaseException {
        AdminRequest request = new AdminRequest("$sync db", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void sync() throws BaseException {
        this.sync(null);
    }

    public void analyze(BSONObject options) throws BaseException {
        AdminRequest request = new AdminRequest("$analyze", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void analyze() throws BaseException {
        this.analyze(null);
    }

    public CollectionSpace getCollectionSpace(String csName) throws BaseException {
        if (this.fetchCache(csName)) {
            return new CollectionSpace(this, csName);
        }
        if (this.isCollectionSpaceExist(csName)) {
            return new CollectionSpace(this, csName);
        }
        throw new BaseException(SDBError.SDB_DMS_CS_NOTEXIST, csName);
    }

    public boolean isCollectionSpaceExist(String csName) throws BaseException {
        BasicBSONObject options = new BasicBSONObject();
        options.put("Name", (Object)csName);
        AdminRequest request = new AdminRequest("$test collectionspace", options);
        SdbReply response = this.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag == 0) {
            this.upsertCache(csName);
            return true;
        }
        if (flag == SDBError.SDB_DMS_CS_NOTEXIST.getErrorCode()) {
            this.removeCache(csName);
            return false;
        }
        this.throwIfError(response, csName);
        return false;
    }

    public DBCursor listCollectionSpaces() throws BaseException {
        return this.getList(5, null, null, null);
    }

    public ArrayList<String> getCollectionSpaceNames() throws BaseException {
        DBCursor cursor = this.getList(5, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        try {
            while (cursor.hasNext()) {
                colList.add(cursor.getNext().get("Name").toString());
            }
        }
        finally {
            cursor.close();
        }
        return colList;
    }

    public DBCursor listCollections() throws BaseException {
        return this.getList(4, null, null, null);
    }

    public ArrayList<String> getCollectionNames() throws BaseException {
        DBCursor cursor = this.getList(4, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        try {
            while (cursor.hasNext()) {
                colList.add(cursor.getNext().get("Name").toString());
            }
        }
        finally {
            cursor.close();
        }
        return colList;
    }

    public ArrayList<String> getStorageUnits() throws BaseException {
        DBCursor cursor = this.getList(6, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        try {
            while (cursor.hasNext()) {
                colList.add(cursor.getNext().get("Name").toString());
            }
        }
        finally {
            cursor.close();
        }
        return colList;
    }

    public void resetSnapshot() throws BaseException {
        AdminRequest request = new AdminRequest("$snapshot reset");
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void resetSnapshot(BSONObject options) throws BaseException {
        AdminRequest request = new AdminRequest("$snapshot reset", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public DBCursor getList(int listType, BSONObject query, BSONObject selector, BSONObject orderBy) throws BaseException {
        String command = this.getListCommand(listType);
        AdminRequest request = new AdminRequest(command, query, selector, orderBy, null);
        SdbReply response = this.requestAndResponse(request);
        int flags = response.getFlag();
        if (flags != 0 && flags != SDBError.SDB_DMS_EOC.getErrorCode()) {
            String msg = "query = " + query + ", selector = " + selector + ", orderBy = " + orderBy;
            this.throwIfError(response, msg);
        }
        return new DBCursor(response, this);
    }

    public void flushConfigure(BSONObject options) throws BaseException {
        AdminRequest request = new AdminRequest("$export configuration", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void updateConfig(BSONObject configs, BSONObject options) throws BaseException {
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.putAll(options);
        newObj.put("Configs", (Object)configs);
        AdminRequest request = new AdminRequest("$update config", newObj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void deleteConfig(BSONObject configs, BSONObject options) throws BaseException {
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.putAll(options);
        newObj.put("Configs", (Object)configs);
        AdminRequest request = new AdminRequest("$delete config", newObj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void execUpdate(String sql) throws BaseException {
        SQLRequest request = new SQLRequest(sql);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response, sql);
    }

    public DBCursor exec(String sql) throws BaseException {
        SQLRequest request = new SQLRequest(sql);
        SdbReply response = this.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag != 0) {
            if (flag == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            this.throwIfError(response, sql);
        }
        return new DBCursor(response, this);
    }

    public DBCursor getSnapshot(int snapType, String matcher, String selector, String orderBy) throws BaseException {
        BSONObject ma = null;
        BSONObject se = null;
        BSONObject or = null;
        if (matcher != null) {
            ma = (BSONObject)JSON.parse(matcher);
        }
        if (selector != null) {
            se = (BSONObject)JSON.parse(selector);
        }
        if (orderBy != null) {
            or = (BSONObject)JSON.parse(orderBy);
        }
        return this.getSnapshot(snapType, ma, se, or);
    }

    public DBCursor getSnapshot(int snapType, BSONObject matcher, BSONObject selector, BSONObject orderBy) throws BaseException {
        String command = this.getSnapshotCommand(snapType);
        AdminRequest request = new AdminRequest(command, matcher, selector, orderBy, null);
        SdbReply response = this.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag != 0) {
            if (flag == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            String msg = "matcher = " + matcher + ", selector = " + selector + ", orderBy = " + orderBy;
            this.throwIfError(response, msg);
        }
        return new DBCursor(response, this);
    }

    public DBCursor getSnapshot(int snapType, BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint, long skipRows, long returnRows) throws BaseException {
        String command = this.getSnapshotCommand(snapType);
        QueryRequest request = new QueryRequest(command, matcher, selector, orderBy, hint, skipRows, returnRows, 0);
        SdbReply response = this.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag != 0) {
            if (flag == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            String msg = "matcher = " + matcher + ", selector = " + selector + ", orderBy = " + orderBy + ", hint = " + hint + ", skipRows = " + skipRows + ", returnRows = " + returnRows;
            this.throwIfError(response, msg);
        }
        return new DBCursor(response, this);
    }

    private String getSnapshotCommand(int snapType) {
        switch (snapType) {
            case 0: {
                return "$snapshot contexts";
            }
            case 1: {
                return "$snapshot contexts current";
            }
            case 2: {
                return "$snapshot sessions";
            }
            case 3: {
                return "$snapshot sessions current";
            }
            case 4: {
                return "$snapshot collections";
            }
            case 5: {
                return "$snapshot collectionspaces";
            }
            case 6: {
                return "$snapshot database";
            }
            case 7: {
                return "$snapshot system";
            }
            case 8: {
                return "$snapshot catalog";
            }
            case 9: {
                return "$snapshot transactions";
            }
            case 10: {
                return "$snapshot transactions current";
            }
            case 11: {
                return "$snapshot accessplans";
            }
            case 12: {
                return "$snapshot health";
            }
            case 13: {
                return "$snapshot configs";
            }
        }
        throw new BaseException(SDBError.SDB_INVALIDARG, String.format("Invalid snapshot type: %d", snapType));
    }

    public void beginTransaction() throws BaseException {
        TransactionRequest request = new TransactionRequest(TransactionRequest.TransactionType.Begin);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void commit() throws BaseException {
        TransactionRequest request = new TransactionRequest(TransactionRequest.TransactionType.Commit);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void rollback() throws BaseException {
        TransactionRequest request = new TransactionRequest(TransactionRequest.TransactionType.Rollback);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void crtJSProcedure(String code) throws BaseException {
        if (null == code || code.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG, code);
        }
        BasicBSONObject options = new BasicBSONObject();
        Code codeObj = new Code(code);
        options.put("func", (Object)codeObj);
        options.put("funcType", (Object)0);
        AdminRequest request = new AdminRequest("$create procedure", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void rmProcedure(String name) throws BaseException {
        if (null == name || name.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG, name);
        }
        BasicBSONObject options = new BasicBSONObject();
        options.put("func", (Object)name);
        AdminRequest request = new AdminRequest("$remove procedure", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public DBCursor listProcedures(BSONObject condition) throws BaseException {
        return this.getList(8, condition, null, null);
    }

    public SptEvalResult evalJS(String code) throws BaseException {
        if (code == null || code.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG);
        }
        SptEvalResult evalResult = new SptEvalResult();
        BasicBSONObject newObj = new BasicBSONObject();
        Code codeObj = new Code(code);
        newObj.put("func", (Object)codeObj);
        newObj.put("funcType", (Object)0);
        AdminRequest request = new AdminRequest("$eval", newObj);
        SdbReply response = this.requestAndResponse(request);
        int flag = response.getFlag();
        if (flag != 0) {
            if (response.getErrorObj() != null) {
                evalResult.errmsg = response.getErrorObj();
            }
            return evalResult;
        }
        if (response.getReturnedNum() > 0) {
            BSONObject obj = response.getResultSet().getNext();
            int typeValue = (Integer)obj.get("ReturnType");
            evalResult.returnType = SptReturnType.getTypeByValue(typeValue);
        }
        evalResult.cursor = new DBCursor(response, this);
        return evalResult;
    }

    public void backupOffline(BSONObject options) throws BaseException {
        AdminRequest request = new AdminRequest("$backup offline", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public DBCursor listBackup(BSONObject options, BSONObject matcher, BSONObject selector, BSONObject orderBy) throws BaseException {
        AdminRequest request = new AdminRequest("$list backups", matcher, selector, orderBy, options);
        SdbReply response = this.requestAndResponse(request);
        int flags = response.getFlag();
        if (flags != 0) {
            if (flags == SDBError.SDB_DMS_EOC.getErrorCode()) {
                return null;
            }
            String msg = "matcher = " + matcher + ", selector = " + selector + ", orderBy = " + orderBy + ", options = " + options;
            this.throwIfError(response, msg);
        }
        DBCursor cursor = new DBCursor(response, this);
        return cursor;
    }

    public void removeBackup(BSONObject options) throws BaseException {
        AdminRequest request = new AdminRequest("$remove backup", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public DBCursor listTasks(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint) throws BaseException {
        return this.getList(10, matcher, selector, orderBy);
    }

    public void waitTasks(long[] taskIDs) throws BaseException {
        if (taskIDs == null || taskIDs.length == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "taskIDs is empty or null");
        }
        BasicBSONObject newObj = new BasicBSONObject();
        BasicBSONObject subObj = new BasicBSONObject();
        BasicBSONList list = new BasicBSONList();
        for (int i = 0; i < taskIDs.length; ++i) {
            list.put(Integer.toString(i), (Object)taskIDs[i]);
        }
        subObj.put("$in", (Object)list);
        newObj.put("TaskID", (Object)subObj);
        AdminRequest request = new AdminRequest("$wait task", newObj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void cancelTask(long taskID, boolean isAsync) throws BaseException {
        if (taskID <= 0L) {
            String msg = "taskID = " + taskID + ", isAsync = " + isAsync;
            throw new BaseException(SDBError.SDB_INVALIDARG, msg);
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("TaskID", (Object)taskID);
        newObj.put("Async", (Object)isAsync);
        AdminRequest request = new AdminRequest("$cancel task", newObj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    private void clearSessionAttrCache() {
        this.attributeCache = null;
    }

    private BSONObject getSessionAttrCache() {
        return this.attributeCache;
    }

    private void setSessionAttrCache(BSONObject attribute) {
        this.attributeCache = attribute;
    }

    public void setSessionAttr(BSONObject options) throws BaseException {
        if (null == options || options.isEmpty()) {
            return;
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.putAll(options);
        if (options.containsField("PreferedInstance")) {
            Object value = options.get("PreferedInstance");
            if (value instanceof String) {
                int v = 8;
                if (value.equals("M") || value.equals("m")) {
                    v = 8;
                } else if (value.equals("S") || value.equals("s")) {
                    v = 9;
                } else if (value.equals("A") || value.equals("a")) {
                    v = 10;
                } else {
                    throw new BaseException(SDBError.SDB_INVALIDARG, options.toString());
                }
                newObj.put("PreferedInstance", (Object)v);
            } else if (value instanceof Integer) {
                newObj.put("PreferedInstance", value);
            }
            newObj.put("PreferedInstanceV1", value);
        }
        this.clearSessionAttrCache();
        AdminRequest request = new AdminRequest("$set session attribute", newObj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public BSONObject getSessionAttr() throws BaseException {
        BSONObject result = this.getSessionAttrCache();
        if (null != result) {
            return result;
        }
        AdminRequest request = new AdminRequest("$get session attribute");
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
        ResultSet resultSet = response.getResultSet();
        if (null != resultSet && resultSet.hasNext()) {
            result = resultSet.getNext();
            if (null == result) {
                this.clearSessionAttrCache();
            } else {
                this.setSessionAttrCache(result);
            }
        } else {
            this.clearSessionAttrCache();
        }
        return result;
    }

    public void closeAllCursors() throws BaseException {
        if (this.isClosed()) {
            return;
        }
        InterruptRequest request = new InterruptRequest();
        this.sendRequest(request);
    }

    public DBCursor listReplicaGroups() throws BaseException {
        return this.getList(7, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDomainExist(String domainName) throws BaseException {
        if (null == domainName || domainName.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG, domainName);
        }
        BasicBSONObject matcher = new BasicBSONObject();
        matcher.put("Name", (Object)domainName);
        DBCursor cursor = this.getList(9, matcher, null, null);
        try {
            if (cursor != null && cursor.hasNext()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
    }

    public Domain createDomain(String domainName, BSONObject options) throws BaseException {
        if (null == domainName || domainName.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "domain name is empty or null");
        }
        if (this.isDomainExist(domainName)) {
            throw new BaseException(SDBError.SDB_CAT_DOMAIN_EXIST, domainName);
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("Name", (Object)domainName);
        if (null != options) {
            newObj.put("Options", (Object)options);
        }
        AdminRequest request = new AdminRequest("$create domain", newObj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
        return new Domain(this, domainName);
    }

    public void dropDomain(String domainName) throws BaseException {
        if (null == domainName || domainName.equals("")) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "domain name is empty or null");
        }
        BasicBSONObject newObj = new BasicBSONObject();
        newObj.put("Name", (Object)domainName);
        AdminRequest request = new AdminRequest("$drop domain", newObj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public Domain getDomain(String domainName) throws BaseException {
        if (this.isDomainExist(domainName)) {
            return new Domain(this, domainName);
        }
        throw new BaseException(SDBError.SDB_CAT_DOMAIN_NOT_EXIST, domainName);
    }

    public DBCursor listDomains(BSONObject matcher, BSONObject selector, BSONObject orderBy, BSONObject hint) throws BaseException {
        return this.getList(9, matcher, selector, orderBy);
    }

    public ArrayList<String> getReplicaGroupNames() throws BaseException {
        DBCursor cursor = this.getList(7, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        try {
            while (cursor.hasNext()) {
                colList.add(cursor.getNext().get("GroupName").toString());
            }
        }
        finally {
            cursor.close();
        }
        return colList;
    }

    public ArrayList<String> getReplicaGroupsInfo() throws BaseException {
        DBCursor cursor = this.getList(7, null, null, null);
        if (cursor == null) {
            return null;
        }
        ArrayList<String> colList = new ArrayList<String>();
        try {
            while (cursor.hasNext()) {
                colList.add(cursor.getNext().toString());
            }
        }
        finally {
            cursor.close();
        }
        return colList;
    }

    public boolean isRelicaGroupExist(String rgName) {
        BSONObject rg = this.getDetailByName(rgName);
        return rg != null;
    }

    public boolean isReplicaGroupExist(int rgId) {
        BSONObject rg = this.getDetailById(rgId);
        return rg != null;
    }

    public ReplicaGroup getReplicaGroup(String rgName) throws BaseException {
        BSONObject rg = this.getDetailByName(rgName);
        if (rg == null) {
            throw new BaseException(SDBError.SDB_CLS_GRP_NOT_EXIST, String.format("Group with the name[%s] does not exist", rgName));
        }
        return new ReplicaGroup(this, rgName);
    }

    public ReplicaGroup getReplicaGroup(int rgId) throws BaseException {
        BSONObject rg = this.getDetailById(rgId);
        if (rg == null) {
            throw new BaseException(SDBError.SDB_CLS_GRP_NOT_EXIST, String.format("Group with the name[%d] does not exist", rgId));
        }
        return new ReplicaGroup(this, rgId);
    }

    public ReplicaGroup createReplicaGroup(String rgName) throws BaseException {
        BasicBSONObject rg = new BasicBSONObject();
        rg.put("GroupName", (Object)rgName);
        AdminRequest request = new AdminRequest("$create group", rg);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response, rgName);
        return new ReplicaGroup(this, rgName);
    }

    public void removeReplicaGroup(String rgName) throws BaseException {
        BasicBSONObject rg = new BasicBSONObject();
        rg.put("GroupName", (Object)rgName);
        AdminRequest request = new AdminRequest("$remove group", rg);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response, rgName);
    }

    private long getNextRequestId() {
        return this.requestId++;
    }

    public void activateReplicaGroup(String rgName) throws BaseException {
        BasicBSONObject rg = new BasicBSONObject();
        rg.put("GroupName", (Object)rgName);
        AdminRequest request = new AdminRequest("$active group", rg);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response, rgName);
    }

    public void createReplicaCataGroup(String hostName, int port, String dbPath, BSONObject options) {
        BasicBSONObject obj = new BasicBSONObject();
        obj.put("HostName", (Object)hostName);
        obj.put("svcname", (Object)Integer.toString(port));
        obj.put("dbpath", (Object)dbPath);
        if (options != null) {
            for (String key : options.keySet()) {
                if (key.equals("HostName") || key.equals("svcname") || key.equals("dbpath")) continue;
                obj.put(key, options.get(key));
            }
        }
        AdminRequest request = new AdminRequest("$create catalog group", obj);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void createReplicaCataGroup(String hostName, int port, String dbPath, Map<String, String> configure) {
        BasicBSONObject obj = new BasicBSONObject();
        if (configure != null) {
            for (String key : configure.keySet()) {
                obj.put(key, (Object)configure.get(key));
            }
        }
        this.createReplicaCataGroup(hostName, port, dbPath, obj);
    }

    public void msg(String message) {
        MessageRequest request = new MessageRequest(message);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    public void invalidateCache(BSONObject options) {
        AdminRequest request = new AdminRequest("$invalidate cache", options);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    private String getListCommand(int listType) {
        switch (listType) {
            case 0: {
                return "$list contexts";
            }
            case 1: {
                return "$list contexts current";
            }
            case 2: {
                return "$list sessions";
            }
            case 3: {
                return "$list sessions current";
            }
            case 4: {
                return "$list collections";
            }
            case 5: {
                return "$list collectionspaces";
            }
            case 6: {
                return "$list storageunits";
            }
            case 7: {
                return "$list groups";
            }
            case 8: {
                return "$list procedures";
            }
            case 9: {
                return "$list domains";
            }
            case 10: {
                return "$list tasks";
            }
            case 11: {
                return "$list transactions";
            }
            case 12: {
                return "$list transactions current";
            }
            case 129: {
                return "$list collections in domain";
            }
            case 130: {
                return "$list collectionspaces in domain";
            }
        }
        throw new BaseException(SDBError.SDB_INVALIDARG, String.format("Invalid list type: %d", listType));
    }

    String getUserName() {
        return this.userName;
    }

    String getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BSONObject getDetailByName(String name) throws BaseException {
        BSONObject result;
        BasicBSONObject condition = new BasicBSONObject();
        condition.put("GroupName", (Object)name);
        DBCursor cursor = this.getList(7, condition, null, null);
        try {
            if (cursor == null || !cursor.hasNext()) {
                BSONObject bSONObject = null;
                return bSONObject;
            }
            result = cursor.getNext();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    BSONObject getDetailById(int id) throws BaseException {
        BSONObject result;
        BasicBSONObject condition = new BasicBSONObject();
        condition.put("GroupID", (Object)id);
        DBCursor cursor = this.getList(7, condition, null, null);
        try {
            if (cursor == null || !cursor.hasNext()) {
                BSONObject bSONObject = null;
                return bSONObject;
            }
            result = cursor.getNext();
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        return result;
    }

    private SysInfoResponse receiveSysInfoResponse() {
        SysInfoResponse response = new SysInfoResponse();
        byte[] lengthBytes = this.connection.receive(response.length());
        ByteBuffer buffer = ByteBuffer.wrap(lengthBytes);
        response.decode(buffer);
        return response;
    }

    private ByteBuffer receiveSdbResponse() {
        byte[] lengthBytes = this.connection.receive(4);
        int length = ByteBuffer.wrap(lengthBytes).order(this.byteOrder).getInt();
        byte[] bytes = new byte[length];
        System.arraycopy(lengthBytes, 0, bytes, 0, lengthBytes.length);
        this.connection.receive(bytes, 4, length - 4);
        ByteBuffer buffer = ByteBuffer.wrap(bytes).order(this.byteOrder);
        return buffer;
    }

    private void validateResponse(SdbRequest request, SdbResponse response) {
        if ((request.opCode() | Integer.MIN_VALUE) != response.opCode()) {
            throw new BaseException(SDBError.SDB_UNKNOWN_MESSAGE, "request=" + request.opCode() + " response=" + response.opCode());
        }
    }

    private ByteBuffer encodeRequest(Request request) {
        ByteBuffer buffer = ByteBuffer.allocate(request.length());
        buffer.order(this.byteOrder);
        request.setRequestId(this.getNextRequestId());
        request.encode(buffer);
        return buffer;
    }

    private void sendRequest(Request request) {
        ByteBuffer buffer = this.encodeRequest(request);
        if (this.isClosed()) {
            throw new BaseException(SDBError.SDB_NOT_CONNECTED);
        }
        this.connection.send(buffer);
    }

    private <T extends SdbResponse> T decodeResponse(ByteBuffer buffer, Class<T> tClass) {
        SdbResponse response;
        try {
            response = (SdbResponse)tClass.newInstance();
        }
        catch (Exception e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        response.decode(buffer);
        return (T)response;
    }

    private ByteBuffer sendAndReceive(ByteBuffer request) {
        if (!this.isClosed()) {
            this.connection.send(request);
            this.lastUseTime = System.currentTimeMillis();
            return this.receiveSdbResponse();
        }
        throw new BaseException(SDBError.SDB_NOT_CONNECTED);
    }

    <T extends SdbResponse> T requestAndResponse(SdbRequest request, Class<T> tClass) {
        ByteBuffer out = this.encodeRequest(request);
        ByteBuffer in = this.sendAndReceive(out);
        T response = this.decodeResponse(in, tClass);
        this.validateResponse(request, (SdbResponse)response);
        return response;
    }

    SdbReply requestAndResponse(SdbRequest request) {
        return this.requestAndResponse(request, SdbReply.class);
    }

    private String getErrorDetail(BSONObject errorObj, Object errorMsg) {
        String serverDetail;
        String detail = null;
        if (errorObj != null && (serverDetail = (String)errorObj.get("detail")) != null && !serverDetail.isEmpty()) {
            detail = serverDetail;
        }
        if (errorMsg != null) {
            detail = detail != null && !detail.isEmpty() ? detail + ", " + errorMsg.toString() : errorMsg.toString();
        }
        return detail;
    }

    void throwIfError(CommonResponse response, Object errorMsg) throws BaseException {
        if (response.getFlag() != 0) {
            String remoteAddress = "remote address[" + this.getNodeName() + "]";
            BSONObject errorObj = response.getErrorObj();
            String detail = this.getErrorDetail(errorObj, errorMsg);
            if (detail != null && !detail.isEmpty()) {
                throw new BaseException(response.getFlag(), remoteAddress + ", " + detail, errorObj);
            }
            throw new BaseException(response.getFlag(), remoteAddress, errorObj);
        }
    }

    void throwIfError(CommonResponse response) throws BaseException {
        if (response.getFlag() != 0) {
            String remoteAddress = "remote address[" + this.getNodeName() + "]";
            BSONObject errorObj = response.getErrorObj();
            String detail = this.getErrorDetail(errorObj, null);
            if (detail != null && !detail.isEmpty()) {
                throw new BaseException(response.getFlag(), remoteAddress + ", " + detail, errorObj);
            }
            throw new BaseException(response.getFlag(), remoteAddress, errorObj);
        }
    }

    private ByteOrder getSysInfo() {
        SysInfoRequest request = new SysInfoRequest();
        this.sendRequest(request);
        SysInfoResponse response = this.receiveSysInfoResponse();
        return response.byteOrder();
    }

    private void killContext() {
        if (this.isClosed()) {
            throw new BaseException(SDBError.SDB_NOT_CONNECTED);
        }
        long[] contextIds = new long[]{-1L};
        KillContextRequest request = new KillContextRequest(contextIds);
        SdbReply response = this.requestAndResponse(request);
        this.throwIfError(response);
    }

    @Override
    public void close() throws BaseException {
        if (this.isClosed()) {
            return;
        }
        try {
            this.releaseResource();
            DisconnectRequest request = new DisconnectRequest();
            this.sendRequest(request);
        }
        finally {
            this.connection.close();
        }
    }

    public static enum SptReturnType {
        TYPE_VOID(0),
        TYPE_STR(1),
        TYPE_NUMBER(2),
        TYPE_OBJ(3),
        TYPE_BOOL(4),
        TYPE_RECORDSET(5),
        TYPE_CS(6),
        TYPE_CL(7),
        TYPE_RG(8),
        TYPE_RN(9);

        private int typeValue;

        private SptReturnType(int typeValue) {
            this.typeValue = typeValue;
        }

        public int getTypeValue() {
            return this.typeValue;
        }

        public static SptReturnType getTypeByValue(int typeValue) {
            SptReturnType retType = null;
            for (SptReturnType rt : SptReturnType.values()) {
                if (rt.getTypeValue() != typeValue) continue;
                retType = rt;
                break;
            }
            return retType;
        }
    }

    public static class SptEvalResult {
        private SptReturnType returnType = null;
        private BSONObject errmsg = null;
        private DBCursor cursor = null;

        public void setReturnType(SptReturnType returnType) {
            this.returnType = returnType;
        }

        public SptReturnType getReturnType() {
            return this.returnType;
        }

        public void setErrMsg(BSONObject errmsg) {
            this.errmsg = errmsg;
        }

        public BSONObject getErrMsg() {
            return this.errmsg;
        }

        public void setCursor(DBCursor cursor) {
            if (this.cursor != null) {
                this.cursor.close();
            }
            this.cursor = cursor;
        }

        public DBCursor getCursor() {
            return this.cursor;
        }
    }
}

