/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.datasource;

import com.sequoiadb.datasource.AbstractStrategy;
import com.sequoiadb.datasource.ConnItem;
import com.sequoiadb.datasource.Pair;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Random;

class ConcreteLocalStrategy
extends AbstractStrategy {
    private Random _rand = new Random(47L);
    private List<String> _localAddrs = new ArrayList<String>();
    private List<String> _localIPs = new ArrayList<String>();

    ConcreteLocalStrategy() {
    }

    @Override
    public void init(List<String> addressList, List<Pair> _idleConnPairs, List<Pair> _usedConnPairs) {
        super.init(addressList, _idleConnPairs, _usedConnPairs);
        this._localIPs = ConcreteLocalStrategy.getNetCardIPs();
        this._localAddrs = ConcreteLocalStrategy.getLocalCoordIPs(this._addrs, this._localIPs);
    }

    @Override
    public String getAddress() {
        String addr = null;
        this._addrLock.lock();
        try {
            if (this._localAddrs.size() > 0) {
                addr = this._localAddrs.get(this._rand.nextInt(this._localAddrs.size()));
            } else if (this._addrs.size() > 0) {
                addr = (String)this._addrs.get(this._rand.nextInt(this._addrs.size()));
            }
        }
        finally {
            this._addrLock.unlock();
        }
        return addr;
    }

    @Override
    public void addAddress(String addr) {
        super.addAddress(addr);
        this._addrLock.lock();
        try {
            if (ConcreteLocalStrategy.isLocalAddress(addr, this._localIPs)) {
                this._localAddrs.add(addr);
            }
        }
        finally {
            this._addrLock.unlock();
        }
    }

    @Override
    public List<ConnItem> removeAddress(String addr) {
        List<ConnItem> list = super.removeAddress(addr);
        this._addrLock.lock();
        try {
            if (ConcreteLocalStrategy.isLocalAddress(addr, this._localIPs)) {
                this._localAddrs.remove(addr);
            }
        }
        finally {
            this._addrLock.unlock();
        }
        return list;
    }

    static List<String> getNetCardIPs() {
        ArrayList<String> localIPs = new ArrayList<String>();
        localIPs.add("127.0.0.1");
        try {
            Enumeration<NetworkInterface> netcards = NetworkInterface.getNetworkInterfaces();
            if (null == netcards) {
                return localIPs;
            }
            for (NetworkInterface netcard : Collections.list(netcards)) {
                if (null == netcard.getHardwareAddress()) continue;
                List<InterfaceAddress> list = netcard.getInterfaceAddresses();
                for (InterfaceAddress interfaceAddress : list) {
                    String addr = interfaceAddress.getAddress().toString();
                    if (addr.indexOf("/") < 0) continue;
                    localIPs.add(addr.split("/")[1]);
                }
            }
        }
        catch (SocketException e) {
            throw new BaseException(SDBError.SDB_SYS, "failed to get local ip address");
        }
        return localIPs;
    }

    static List<String> getLocalCoordIPs(List<String> urls, List<String> localIPs) {
        ArrayList<String> localAddrs = new ArrayList<String>();
        if (localIPs.size() > 0) {
            for (String url : urls) {
                String ip = url.split(":")[0].trim();
                if (!localIPs.contains(ip)) continue;
                localAddrs.add(url);
            }
        }
        return localAddrs;
    }

    static boolean isLocalAddress(String url, List<String> localIPs) {
        return localIPs.contains(url.split(":")[0].trim());
    }
}

