/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.datasource;

import com.sequoiadb.datasource.ConnectStrategy;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;

public class DatasourceOptions
implements Cloneable {
    private static final List<String> MODE = Arrays.asList("M", "m", "S", "s", "A", "a");
    private static final String DEFAULT_PREFERRD_INSTANCE_MODE = "random";
    private static final int DEFAULT_SESSION_TIMEOUT = -1;
    private int _deltaIncCount = 10;
    private int _maxIdleCount = 10;
    private int _maxCount = 500;
    private int _keepAliveTimeout = 0;
    private int _checkInterval = 60000;
    private int _syncCoordInterval = 0;
    private boolean _validateConnection = false;
    private ConnectStrategy _connectStrategy = ConnectStrategy.SERIAL;
    private List<Object> _preferedInstance = null;
    private String _preferedInstanceMode = "random";
    private int _sessionTimeout = -1;

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void setDeltaIncCount(int deltaIncCount) {
        this._deltaIncCount = deltaIncCount;
    }

    public void setMaxIdleCount(int maxIdleCount) {
        this._maxIdleCount = maxIdleCount;
    }

    public void setMaxCount(int maxCount) {
        this._maxCount = maxCount;
    }

    public void setKeepAliveTimeout(int keepAliveTimeout) {
        this._keepAliveTimeout = keepAliveTimeout;
    }

    public void setCheckInterval(int checkInterval) {
        this._checkInterval = checkInterval;
    }

    public void setSyncCoordInterval(int syncCoordInterval) {
        this._syncCoordInterval = syncCoordInterval > 0 && syncCoordInterval < 60000 ? 60000 : syncCoordInterval;
    }

    public void setValidateConnection(boolean validateConnection) {
        this._validateConnection = validateConnection;
    }

    public void setConnectStrategy(ConnectStrategy strategy) {
        this._connectStrategy = strategy == ConnectStrategy.BALANCE ? ConnectStrategy.SERIAL : strategy;
    }

    public void setPreferedInstance(List<String> preferedInstance) {
        if (preferedInstance == null || preferedInstance.size() == 0) {
            return;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (String s : preferedInstance) {
            if (this.isValidMode(s)) {
                if (list.contains(s)) continue;
                list.add(s);
                continue;
            }
            throw new BaseException(SDBError.SDB_INVALIDARG, "invalid preferred instance: " + s);
        }
        if (list.size() == 0) {
            return;
        }
        this._preferedInstance = new ArrayList<Object>();
        for (String s : list) {
            try {
                this._preferedInstance.add(Integer.valueOf(s));
            }
            catch (NumberFormatException e) {
                this._preferedInstance.add(s);
            }
        }
    }

    public void setPreferedInstanceMode(String mode) {
        this._preferedInstanceMode = mode == null || mode.isEmpty() ? DEFAULT_PREFERRD_INSTANCE_MODE : mode;
    }

    public void setSessionTimeout(int timeout) {
        this._sessionTimeout = timeout < 0 ? -1 : timeout;
    }

    public int getDeltaIncCount() {
        return this._deltaIncCount;
    }

    public int getMaxIdleCount() {
        return this._maxIdleCount;
    }

    public int getMaxCount() {
        return this._maxCount;
    }

    public int getKeepAliveTimeout() {
        return this._keepAliveTimeout;
    }

    public int getCheckInterval() {
        return this._checkInterval;
    }

    public int getSyncCoordInterval() {
        return this._syncCoordInterval;
    }

    public boolean getValidateConnection() {
        return this._validateConnection;
    }

    public ConnectStrategy getConnectStrategy() {
        return this._connectStrategy;
    }

    public List<String> getPreferedInstance() {
        if (this._preferedInstance == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Object o : this._preferedInstance) {
            if (o instanceof String) {
                list.add((String)o);
                continue;
            }
            if (!(o instanceof Integer)) continue;
            list.add(o + "");
        }
        return list;
    }

    List<Object> getPreferedInstanceObjects() {
        return this._preferedInstance;
    }

    public String getPreferedInstanceMode() {
        return this._preferedInstanceMode;
    }

    public int getSessionTimeout() {
        return this._sessionTimeout;
    }

    public void setInitConnectionNum(int initConnectionNum) {
    }

    public void setMaxIdeNum(int maxIdeNum) {
        this.setMaxIdleCount(maxIdeNum);
    }

    public void setMaxConnectionNum(int maxConnectionNum) {
        this.setMaxCount(maxConnectionNum);
    }

    public void setTimeout(int timeout) {
    }

    public void setRecheckCyclePeriod(int recheckCyclePeriod) {
        this.setCheckInterval(recheckCyclePeriod);
    }

    public void setRecaptureConnPeriod(int recaptureConnPeriod) {
    }

    public void setAbandonTime(int abandonTime) {
        this.setKeepAliveTimeout(abandonTime);
    }

    public int getInitConnectionNum() {
        return 0;
    }

    public int getMaxConnectionNum() {
        return this.getMaxCount();
    }

    public int getMaxIdeNum() {
        return this.getMaxIdleCount();
    }

    public int getAbandonTime() {
        return this.getKeepAliveTimeout();
    }

    public int getRecheckCyclePeriod() {
        return this.getCheckInterval();
    }

    public int getRecaptureConnPeriod() {
        return 0;
    }

    public int getTimeout() {
        return 0;
    }

    BSONObject getSessionAttr() {
        BasicBSONObject obj = new BasicBSONObject();
        if (this._preferedInstance != null && this._preferedInstance.size() > 0) {
            BasicBSONList list = new BasicBSONList();
            int i = 0;
            for (Object o : this._preferedInstance) {
                list.put("" + i++, o);
            }
            obj.put("PreferedInstance", (Object)list);
            obj.put("PreferedInstanceMode", (Object)this._preferedInstanceMode);
            obj.put("Timeout", (Object)this._sessionTimeout);
        }
        return obj;
    }

    private boolean isCharMode(String s) {
        for (int i = 0; i < MODE.size(); ++i) {
            if (!MODE.get(i).equals(s)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidMode(String s) {
        if (this.isCharMode(s)) {
            return true;
        }
        int n = 0;
        try {
            n = Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return n >= 1 && n <= 255;
    }
}

