/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.datasource;

import com.sequoiadb.base.ConfigOptions;
import com.sequoiadb.base.DBCursor;
import com.sequoiadb.base.Sequoiadb;
import com.sequoiadb.datasource.ConcreteBalanceStrategy;
import com.sequoiadb.datasource.ConcreteLocalStrategy;
import com.sequoiadb.datasource.ConcreteRandomStrategy;
import com.sequoiadb.datasource.ConcreteSerialStrategy;
import com.sequoiadb.datasource.ConnItem;
import com.sequoiadb.datasource.ConnectStrategy;
import com.sequoiadb.datasource.ConnectionItemMgr;
import com.sequoiadb.datasource.DatasourceOptions;
import com.sequoiadb.datasource.IConnectStrategy;
import com.sequoiadb.datasource.IConnectionPool;
import com.sequoiadb.datasource.IdleConnectionPool;
import com.sequoiadb.datasource.Pair;
import com.sequoiadb.datasource.UsedConnectionPool;
import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;
import org.bson.types.BasicBSONList;

public class SequoiadbDatasource {
    private List<String> _normalAddrs = Collections.synchronizedList(new ArrayList());
    private ConcurrentSkipListSet<String> _abnormalAddrs = new ConcurrentSkipListSet();
    private ConcurrentSkipListSet<String> _localAddrs = new ConcurrentSkipListSet();
    private List<String> _localIPs = Collections.synchronizedList(new ArrayList());
    private LinkedBlockingQueue<Sequoiadb> _destroyConnQueue = new LinkedBlockingQueue();
    private IConnectionPool _idleConnPool = null;
    private IConnectionPool _usedConnPool = null;
    private IConnectStrategy _strategy = null;
    private ConnectionItemMgr _connItemMgr = null;
    private final Object _createConnSignal = new Object();
    private String _username = null;
    private String _password = null;
    private ConfigOptions _nwOpt = null;
    private DatasourceOptions _dsOpt = null;
    private long _currentSequenceNumber = 0L;
    private ExecutorService _threadExec = null;
    private ScheduledExecutorService _timerExec = null;
    private volatile boolean _isDatasourceOn = false;
    private volatile boolean _hasClosed = false;
    private ReentrantReadWriteLock _rwLock = new ReentrantReadWriteLock();
    private final Object _objForReleaseConn = new Object();
    private volatile BaseException _lastException;
    private volatile BSONObject _sessionAttr = null;
    private Random _rand = new Random(47L);
    private double MULTIPLE = 1.5;
    private volatile int _preDeleteInterval = 0;
    private static final int _deleteInterval = 180000;
    private final Object finalizerGuardian = new Object(){

        protected void finalize() throws Throwable {
            try {
                SequoiadbDatasource.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    };

    public SequoiadbDatasource(List<String> urls, String username, String password, ConfigOptions nwOpt, DatasourceOptions dsOpt) throws BaseException {
        if (null == urls || 0 == urls.size()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "coord addresses can't be empty or null");
        }
        this._init(urls, username, password, nwOpt, dsOpt);
    }

    @Deprecated
    public SequoiadbDatasource(List<String> urls, String username, String password, com.sequoiadb.net.ConfigOptions nwOpt, DatasourceOptions dsOpt) throws BaseException {
        this(urls, username, password, (ConfigOptions)nwOpt, dsOpt);
    }

    public SequoiadbDatasource(String url, String username, String password, DatasourceOptions dsOpt) throws BaseException {
        if (url == null || url.isEmpty()) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "coord address can't be empty or null");
        }
        ArrayList<String> urls = new ArrayList<String>();
        urls.add(url);
        this._init(urls, username, password, null, dsOpt);
    }

    public int getIdleConnNum() {
        if (this._idleConnPool == null) {
            return 0;
        }
        return this._idleConnPool.count();
    }

    public int getUsedConnNum() {
        if (this._usedConnPool == null) {
            return 0;
        }
        return this._usedConnPool.count();
    }

    public int getNormalAddrNum() {
        return this._normalAddrs.size();
    }

    public int getAbnormalAddrNum() {
        return this._abnormalAddrs.size();
    }

    public int getLocalAddrNum() {
        return this._localAddrs.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCoord(String url) throws BaseException {
        ReentrantReadWriteLock.WriteLock wlock = this._rwLock.writeLock();
        wlock.lock();
        try {
            if (this._hasClosed) {
                throw new BaseException(SDBError.SDB_SYS, "connection pool has closed");
            }
            if (null == url || "" == url) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "coord address can't be empty or null");
            }
            String addr = this._parseCoordAddr(url);
            if (this._normalAddrs.contains(addr) || this._abnormalAddrs.contains(addr)) {
                return;
            }
            List<String> list = this._normalAddrs;
            synchronized (list) {
                if (!this._normalAddrs.contains(addr)) {
                    this._normalAddrs.add(addr);
                }
            }
            if (ConcreteLocalStrategy.isLocalAddress(addr, this._localIPs)) {
                this._localAddrs.add(addr);
            }
            if (this._isDatasourceOn) {
                this._strategy.addAddress(addr);
            }
        }
        finally {
            wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCoord(String url) throws BaseException {
        ReentrantReadWriteLock.WriteLock wlock = this._rwLock.writeLock();
        wlock.lock();
        try {
            if (this._hasClosed) {
                throw new BaseException(SDBError.SDB_SYS, "connection pool has closed");
            }
            if (null == url) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "coord address can't be null");
            }
            String addr = this._parseCoordAddr(url);
            this._normalAddrs.remove(addr);
            this._abnormalAddrs.remove(addr);
            this._localAddrs.remove(addr);
            if (this._isDatasourceOn) {
                this._removeAddrInStrategy(addr);
            }
        }
        finally {
            wlock.unlock();
        }
    }

    public DatasourceOptions getDatasourceOptions() throws BaseException {
        ReentrantReadWriteLock.ReadLock rlock = this._rwLock.readLock();
        rlock.lock();
        try {
            DatasourceOptions datasourceOptions = (DatasourceOptions)this._dsOpt.clone();
            return datasourceOptions;
        }
        catch (CloneNotSupportedException e) {
            throw new BaseException(SDBError.SDB_SYS, "failed to clone connnection pool options");
        }
        finally {
            rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDatasourceOptions(DatasourceOptions dsOpt) throws BaseException {
        ReentrantReadWriteLock.WriteLock wlock = this._rwLock.writeLock();
        wlock.lock();
        try {
            if (this._hasClosed) {
                throw new BaseException(SDBError.SDB_SYS, "connection pool has closed");
            }
            this._checkDatasourceOptions(dsOpt);
            int previousMaxCount = this._dsOpt.getMaxCount();
            int previousCheckInterval = this._dsOpt.getCheckInterval();
            int previousSyncCoordInterval = this._dsOpt.getSyncCoordInterval();
            ConnectStrategy previousStrategy = this._dsOpt.getConnectStrategy();
            try {
                this._dsOpt = (DatasourceOptions)dsOpt.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "failed to clone connection pool options");
            }
            if (!this._isDatasourceOn) {
                return;
            }
            if (this._dsOpt.getMaxCount() == 0) {
                this.disableDatasource();
                return;
            }
            this._preDeleteInterval = (int)((double)this._dsOpt.getCheckInterval() * this.MULTIPLE);
            if (previousMaxCount != this._dsOpt.getMaxCount()) {
                if (this._connItemMgr != null) {
                    this._connItemMgr.resetCapacity(this._dsOpt.getMaxCount());
                    if (this._dsOpt.getMaxCount() < previousMaxCount) {
                        int destroyNum;
                        int deltaNum = this.getIdleConnNum() + this.getUsedConnNum() - this._dsOpt.getMaxCount();
                        int n = destroyNum = deltaNum > this.getIdleConnNum() ? this.getIdleConnNum() : deltaNum;
                        if (destroyNum > 0) {
                            this._reduceIdleConnections(destroyNum);
                        }
                        this._currentSequenceNumber = this._connItemMgr.getCurrentSequenceNumber();
                    }
                } else {
                    throw new BaseException(SDBError.SDB_SYS, "the item manager is null");
                }
            }
            if (previousStrategy != this._dsOpt.getConnectStrategy()) {
                this._cancelTimer();
                this._cancelThreads();
                this._changeStrategy();
                this._startTimer();
                this._startThreads();
                this._currentSequenceNumber = this._connItemMgr.getCurrentSequenceNumber();
            } else if (previousCheckInterval != this._dsOpt.getCheckInterval() || previousSyncCoordInterval != this._dsOpt.getSyncCoordInterval()) {
                this._cancelTimer();
                this._startTimer();
            }
        }
        finally {
            wlock.unlock();
        }
    }

    public void enableDatasource() {
        ReentrantReadWriteLock.WriteLock wlock = this._rwLock.writeLock();
        wlock.lock();
        try {
            if (this._hasClosed) {
                throw new BaseException(SDBError.SDB_SYS, "connection pool has closed");
            }
            if (this._isDatasourceOn) {
                return;
            }
            if (this._dsOpt.getMaxCount() == 0) {
                this._dsOpt.setMaxCount(500);
            }
            this._enableDatasource(this._dsOpt.getConnectStrategy());
        }
        finally {
            wlock.unlock();
        }
    }

    public void disableDatasource() {
        ReentrantReadWriteLock.WriteLock wlock = this._rwLock.writeLock();
        wlock.lock();
        try {
            if (this._hasClosed) {
                throw new BaseException(SDBError.SDB_SYS, "connection pool has closed");
            }
            if (!this._isDatasourceOn) {
                return;
            }
            this._cancelTimer();
            this._cancelThreads();
            this._closePoolConnections(this._idleConnPool);
            this._isDatasourceOn = false;
        }
        finally {
            wlock.unlock();
        }
    }

    public Sequoiadb getConnection() throws BaseException, InterruptedException {
        return this.getConnection(5000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Sequoiadb getConnection(long timeout) throws BaseException, InterruptedException {
        if (timeout < 0L) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "timeout should >= 0");
        }
        ReentrantReadWriteLock.ReadLock rlock = this._rwLock.readLock();
        rlock.lock();
        try {
            ConnItem connItem;
            Sequoiadb sdb;
            long restTime = timeout;
            while (true) {
                sdb = null;
                connItem = null;
                if (this._hasClosed) {
                    throw new BaseException(SDBError.SDB_SYS, "connection pool has closed");
                }
                if (!this._isDatasourceOn) {
                    Sequoiadb sequoiadb = this._newConnByNormalAddr();
                    return sequoiadb;
                }
                connItem = this._strategy.pollConnItemForGetting();
                if (connItem != null) {
                    sdb = this._idleConnPool.poll(connItem);
                    if (sdb == null) {
                        this._connItemMgr.releaseItem(connItem);
                        connItem = null;
                        throw new BaseException(SDBError.SDB_SYS, "no matching connection");
                    }
                } else {
                    connItem = this._connItemMgr.getItem();
                    if (connItem != null) {
                        try {
                            sdb = this._newConnByNormalAddr();
                        }
                        catch (BaseException e) {
                            this._connItemMgr.releaseItem(connItem);
                            connItem = null;
                            throw e;
                        }
                        if (sdb == null) {
                            this._connItemMgr.releaseItem(connItem);
                            connItem = null;
                            throw new BaseException(SDBError.SDB_SYS, "create connection directly failed");
                        }
                        if (this._sessionAttr != null) {
                            try {
                                sdb.setSessionAttr(this._sessionAttr);
                            }
                            catch (Exception e) {
                                this._connItemMgr.releaseItem(connItem);
                                connItem = null;
                                this._destroyConnQueue.add(sdb);
                                throw new BaseException(SDBError.SDB_SYS, String.format("failed to set the session attribute[%s]", this._sessionAttr.toString()), e);
                            }
                        }
                        connItem.setAddr(sdb.getServerAddress().toString());
                        Object e = this._createConnSignal;
                        synchronized (e) {
                            this._createConnSignal.notify();
                        }
                    } else {
                        SequoiadbDatasource sequoiadbDatasource;
                        block38: {
                            long beginTime = 0L;
                            long endTime = 0L;
                            rlock.unlock();
                            if (timeout == 0L) break block38;
                            if (restTime <= 0L) {
                                rlock.lock();
                                break;
                            }
                            beginTime = System.currentTimeMillis();
                            try {
                                sequoiadbDatasource = this;
                                synchronized (sequoiadbDatasource) {
                                    this.wait(restTime);
                                }
                            }
                            finally {
                                endTime = System.currentTimeMillis();
                                restTime -= endTime - beginTime;
                            }
                            {
                                catch (Throwable throwable) {
                                    throw throwable;
                                }
                            }
                        }
                        try {
                            sequoiadbDatasource = this;
                            synchronized (sequoiadbDatasource) {
                                this.wait(5000L);
                            }
                        }
                        finally {
                            rlock.lock();
                        }
                        continue;
                    }
                }
                if (!sdb.isClosed() && (!this._dsOpt.getValidateConnection() || sdb.isValid())) break;
                this._connItemMgr.releaseItem(connItem);
                connItem = null;
                this._destroyConnQueue.add(sdb);
                sdb = null;
            }
            if (connItem == null) {
                String detail = this._getDataSourceSnapshot();
                if (this.getNormalAddrNum() != 0) throw new BaseException(SDBError.SDB_DRIVER_DS_RUNOUT, "the pool has run out of connections, " + detail);
                if (this.getUsedConnNum() >= this._dsOpt.getMaxCount()) throw new BaseException(SDBError.SDB_DRIVER_DS_RUNOUT, "the pool has run out of connections, " + detail);
                BaseException exception = this._getLastException();
                String errMsg = "get connection failed, no available address for connection, " + detail;
                if (exception == null) throw new BaseException(SDBError.SDB_NETWORK, errMsg);
                throw new BaseException(SDBError.SDB_NETWORK, errMsg, exception);
            }
            this._usedConnPool.insert(connItem, sdb);
            this._strategy.updateUsedConnItemCount(connItem, 1);
            Sequoiadb sequoiadb = sdb;
            return sequoiadb;
        }
        finally {
            rlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(Sequoiadb sdb) throws BaseException {
        block27: {
            ReentrantReadWriteLock.ReadLock rlock = this._rwLock.readLock();
            rlock.lock();
            try {
                if (sdb == null) {
                    throw new BaseException(SDBError.SDB_INVALIDARG, "connection can't be null");
                }
                if (this._hasClosed) {
                    throw new BaseException(SDBError.SDB_SYS, "connection pool has closed");
                }
                if (!this._isDatasourceOn) {
                    Object object = this._objForReleaseConn;
                    synchronized (object) {
                        if (this._usedConnPool != null && this._usedConnPool.contains(sdb)) {
                            ConnItem item = this._usedConnPool.poll(sdb);
                            if (item == null) {
                                throw new BaseException(SDBError.SDB_SYS, "the pool does't have item for the coming back connection");
                            }
                            this._connItemMgr.releaseItem(item);
                        }
                    }
                    try {
                        sdb.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return;
                }
                ConnItem item = null;
                Object object = this._objForReleaseConn;
                synchronized (object) {
                    if (this._usedConnPool.contains(sdb)) {
                        item = this._usedConnPool.poll(sdb);
                        if (item == null) {
                            throw new BaseException(SDBError.SDB_SYS, "the pool does not have item for the coming back connection");
                        }
                    } else {
                        throw new BaseException(SDBError.SDB_INVALIDARG, "the connection pool doesn't contain the offered connection");
                    }
                }
                this._strategy.updateUsedConnItemCount(item, -1);
                if (this._connIsValid(item, sdb)) {
                    this._idleConnPool.insert(item, sdb);
                    this._strategy.addConnItemAfterReleasing(item);
                    object = this;
                    synchronized (object) {
                        this.notifyAll();
                        break block27;
                    }
                }
                this._connItemMgr.releaseItem(item);
                this._destroyConnQueue.add(sdb);
                object = this;
                synchronized (object) {
                    this.notifyAll();
                }
            }
            finally {
                rlock.unlock();
            }
        }
    }

    public void close(Sequoiadb sdb) throws BaseException {
        this.releaseConnection(sdb);
    }

    public void close() {
        ReentrantReadWriteLock.WriteLock wlock = this._rwLock.writeLock();
        wlock.lock();
        try {
            if (this._hasClosed) {
                return;
            }
            if (this._isDatasourceOn) {
                this._cancelTimer();
                this._cancelThreads();
            }
            if (this._idleConnPool != null) {
                this._closePoolConnections(this._idleConnPool);
            }
            if (this._usedConnPool != null) {
                this._closePoolConnections(this._usedConnPool);
            }
            this._isDatasourceOn = false;
            this._hasClosed = true;
        }
        finally {
            wlock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _init(List<String> addrList, String username, String password, ConfigOptions nwOpt, DatasourceOptions dsOpt) throws BaseException {
        for (String elem : addrList) {
            if (elem == null || elem.isEmpty()) continue;
            String addr = this._parseCoordAddr(elem);
            List<String> list = this._normalAddrs;
            synchronized (list) {
                if (!this._normalAddrs.contains(addr)) {
                    this._normalAddrs.add(addr);
                }
            }
        }
        this._username = username == null ? "" : username;
        String string = this._password = password == null ? "" : password;
        if (nwOpt == null) {
            ConfigOptions temp = new ConfigOptions();
            temp.setConnectTimeout(100);
            temp.setMaxAutoConnectRetryTime(0L);
            this._nwOpt = temp;
        } else {
            this._nwOpt = nwOpt;
        }
        if (dsOpt == null) {
            this._dsOpt = new DatasourceOptions();
        } else {
            try {
                this._dsOpt = (DatasourceOptions)dsOpt.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "failed to clone connection pool options");
            }
        }
        List<String> localIPList = ConcreteLocalStrategy.getNetCardIPs();
        this._localIPs.addAll(localIPList);
        List<String> localCoordList = ConcreteLocalStrategy.getLocalCoordIPs(this._normalAddrs, localIPList);
        this._localAddrs.addAll(localCoordList);
        this._checkDatasourceOptions(this._dsOpt);
        if (this._dsOpt.getMaxCount() == 0) {
            this._isDatasourceOn = false;
        } else {
            this._enableDatasource(this._dsOpt.getConnectStrategy());
        }
        Runtime.getRuntime().addShutdownHook(new ExitClearUpTask());
    }

    private void _startTimer() {
        this._timerExec = Executors.newScheduledThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        if (this._dsOpt.getSyncCoordInterval() > 0) {
            this._timerExec.scheduleAtFixedRate(new SynchronizeAddressTask(), 0L, this._dsOpt.getSyncCoordInterval(), TimeUnit.MILLISECONDS);
        }
        this._timerExec.scheduleAtFixedRate(new CheckConnectionTask(), this._dsOpt.getCheckInterval(), this._dsOpt.getCheckInterval(), TimeUnit.MILLISECONDS);
        this._timerExec.scheduleAtFixedRate(new RetrieveAddressTask(), 60L, 60L, TimeUnit.SECONDS);
    }

    private void _cancelTimer() {
        this._timerExec.shutdownNow();
    }

    private void _startThreads() {
        this._threadExec = Executors.newCachedThreadPool(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = Executors.defaultThreadFactory().newThread(r);
                t.setDaemon(true);
                return t;
            }
        });
        this._threadExec.execute(new CreateConnectionTask());
        this._threadExec.execute(new DestroyConnectionTask());
        this._threadExec.shutdown();
    }

    private void _cancelThreads() {
        this._threadExec.shutdownNow();
    }

    private void _changeStrategy() {
        ArrayList<Pair> idleConnPairs = new ArrayList<Pair>();
        ArrayList<Pair> usedConnPairs = new ArrayList<Pair>();
        Iterator<Pair> itr = null;
        itr = this._idleConnPool.getIterator();
        while (itr.hasNext()) {
            idleConnPairs.add(itr.next());
        }
        itr = this._usedConnPool.getIterator();
        while (itr.hasNext()) {
            usedConnPairs.add(itr.next());
        }
        this._strategy = this._createStrategy(this._dsOpt.getConnectStrategy());
        this._strategy.init(this._normalAddrs, idleConnPairs, usedConnPairs);
    }

    private void _closePoolConnections(IConnectionPool pool) {
        if (pool == null) {
            return;
        }
        Iterator<Pair> iter = pool.getIterator();
        while (iter.hasNext()) {
            Pair pair = iter.next();
            Sequoiadb sdb = pair.second();
            try {
                sdb.disconnect();
            }
            catch (Exception exception) {}
        }
        List<ConnItem> list = pool.clear();
        for (ConnItem item : list) {
            this._connItemMgr.releaseItem(item);
        }
    }

    private void _checkDatasourceOptions(DatasourceOptions newOpt) throws BaseException {
        if (newOpt == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "the offering datasource options can't be null");
        }
        int deltaIncCount = newOpt.getDeltaIncCount();
        int maxIdleCount = newOpt.getMaxIdleCount();
        int maxCount = newOpt.getMaxCount();
        int keepAliveTimeout = newOpt.getKeepAliveTimeout();
        int checkInterval = newOpt.getCheckInterval();
        int syncCoordInterval = newOpt.getSyncCoordInterval();
        List<Object> preferredInstanceList = newOpt.getPreferedInstanceObjects();
        String preferredInstanceMode = newOpt.getPreferedInstanceMode();
        int sessionTimeout = newOpt.getSessionTimeout();
        if (maxCount < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "maxCount can't be less then 0");
        }
        if (deltaIncCount <= 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "deltaIncCount should be more then 0");
        }
        if (maxIdleCount < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "maxIdleCount can't be less then 0");
        }
        if (keepAliveTimeout < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "keepAliveTimeout can't be less than 0");
        }
        if (checkInterval <= 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "checkInterval should be more than 0");
        }
        if (0 != keepAliveTimeout && checkInterval >= keepAliveTimeout) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "when keepAliveTimeout is not 0, checkInterval should be less than keepAliveTimeout");
        }
        if (syncCoordInterval < 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "syncCoordInterval can't be less than 0");
        }
        if (maxCount != 0) {
            if (deltaIncCount > maxCount) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "deltaIncCount can't be great then maxCount");
            }
            if (maxIdleCount > maxCount) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "maxIdleCount can't be great then maxCount");
            }
        }
        if (preferredInstanceList != null && preferredInstanceList.size() > 0) {
            for (Object obj : preferredInstanceList) {
                if (obj instanceof String) {
                    String s = (String)obj;
                    if ("M".equals(s) || "m".equals(s) || "S".equals(s) || "s".equals(s) || "A".equals(s) || "a".equals(s)) continue;
                    throw new BaseException(SDBError.SDB_INVALIDARG, "the element of preferred instance should be 'M'/'S'/'A'/'m'/'s'/'a/['1','255'], but it is " + s);
                }
                if (obj instanceof Integer) {
                    int i = (Integer)obj;
                    if (i > 0 && i <= 255) continue;
                    throw new BaseException(SDBError.SDB_INVALIDARG, "the element of preferred instance should be 'M'/'S'/'A'/'m'/'s'/'a/['1','255'], but it is " + i);
                }
                throw new BaseException(SDBError.SDB_INVALIDARG, "the preferred instance should instance of int or String, but it is " + (obj == null ? null : obj.getClass()));
            }
            if (!"ordered".equals(preferredInstanceMode) && !"random".equals(preferredInstanceMode)) {
                throw new BaseException(SDBError.SDB_INVALIDARG, String.format("the preferred instance mode should be '%s' or '%s', but it is %s", "ordered", "random", preferredInstanceMode));
            }
            if (sessionTimeout < -1) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "the session timeout can not less than -1");
            }
            this._sessionAttr = newOpt.getSessionAttr();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequoiadb _newConnByNormalAddr() throws BaseException {
        Sequoiadb sdb = null;
        String address = null;
        try {
            block14: {
                while (true) {
                    if (this._isDatasourceOn) {
                        address = this._strategy.getAddress();
                    } else {
                        List<String> list = this._normalAddrs;
                        synchronized (list) {
                            int size = this._normalAddrs.size();
                            if (size > 0) {
                                address = this._normalAddrs.get(this._rand.nextInt(size));
                            }
                        }
                    }
                    if (address == null) break;
                    try {
                        sdb = new Sequoiadb(address, this._username, this._password, this._nwOpt);
                        break block14;
                    }
                    catch (BaseException e) {
                        this._setLastException(e);
                        String errType = e.getErrorType();
                        if (errType.equals("SDB_NETWORK") || errType.equals("SDB_INVALIDARG") || errType.equals("SDB_NET_CANNOT_CONNECT")) {
                            this._handleErrorAddr(address);
                            continue;
                        }
                        throw e;
                    }
                    break;
                }
                sdb = this._newConnByAbnormalAddr();
            }
            if (sdb == null) {
                throw new BaseException(SDBError.SDB_SYS, "failed to create connection directly");
            }
        }
        catch (BaseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BaseException(SDBError.SDB_SYS, (Throwable)e);
        }
        return sdb;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Sequoiadb _newConnByAbnormalAddr() throws BaseException {
        Sequoiadb retConn = null;
        int retry = 3;
        while (retry-- > 0) {
            for (String addr : this._abnormalAddrs) {
                try {
                    retConn = new Sequoiadb(addr, this._username, this._password, this._nwOpt);
                }
                catch (Exception e) {
                    if (!(e instanceof BaseException)) continue;
                    this._setLastException((BaseException)e);
                    continue;
                }
                this._abnormalAddrs.remove(addr);
                List<String> e = this._normalAddrs;
                synchronized (e) {
                    if (!this._normalAddrs.contains(addr)) {
                        this._normalAddrs.add(addr);
                    }
                }
                if (!this._isDatasourceOn) break;
                this._strategy.addAddress(addr);
                break;
            }
            if (retConn == null) continue;
            break;
        }
        if (retConn == null) {
            String detail = this._getDataSourceSnapshot();
            BaseException exp = this._getLastException();
            String errMsg = "no available address for connection, " + detail;
            if (exp != null) {
                throw new BaseException(SDBError.SDB_NETWORK, errMsg, exp);
            }
            throw new BaseException(SDBError.SDB_NETWORK, errMsg);
        }
        return retConn;
    }

    private String _getDataSourceSnapshot() {
        String snapshot = String.format("[thread id: %d], total item: %d, idle item: %d, used item: %d, idle connections: %d, used connections: %d, normal addresses: %d, abnormal addresses: %d, local addresses: %d", Thread.currentThread().getId(), this._connItemMgr.getCapacity(), this._connItemMgr.getIdleItemNum(), this._connItemMgr.getUsedItemNum(), this._idleConnPool != null ? Integer.valueOf(this._idleConnPool.count()) : null, this._usedConnPool != null ? Integer.valueOf(this._usedConnPool.count()) : null, this.getNormalAddrNum(), this.getAbnormalAddrNum(), this.getLocalAddrNum());
        return snapshot;
    }

    private void _setLastException(BaseException e) {
        this._lastException = e;
    }

    private BaseException _getLastException() {
        BaseException exp = this._lastException;
        return exp;
    }

    private void _handleErrorAddr(String addr) {
        this._normalAddrs.remove(addr);
        this._abnormalAddrs.add(addr);
        if (this._isDatasourceOn) {
            this._removeAddrInStrategy(addr);
        }
    }

    private void _removeAddrInStrategy(String addr) {
        List<ConnItem> list = this._strategy.removeAddress(addr);
        for (ConnItem item : list) {
            Sequoiadb sdb = this._idleConnPool.poll(item);
            this._destroyConnQueue.add(sdb);
            item.setAddr("");
            this._connItemMgr.releaseItem(item);
        }
    }

    private void _createConnections() {
        for (int count = this._dsOpt.getDeltaIncCount(); count > 0; --count) {
            Sequoiadb sdb = null;
            String addr = null;
            ConnItem connItem = this._connItemMgr.getItem();
            if (connItem == null) break;
            while (true) {
                addr = null;
                addr = this._strategy.getAddress();
                if (addr == null) break;
                try {
                    sdb = new Sequoiadb(addr, this._username, this._password, this._nwOpt);
                }
                catch (BaseException e) {
                    this._setLastException(e);
                    String errType = e.getErrorType();
                    if (!errType.equals("SDB_NETWORK") && !errType.equals("SDB_INVALIDARG") && !errType.equals("SDB_NET_CANNOT_CONNECT")) break;
                    this._handleErrorAddr(addr);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
                break;
            }
            if (sdb == null) {
                this._connItemMgr.releaseItem(connItem);
                break;
            }
            if (this._sessionAttr != null) {
                try {
                    sdb.setSessionAttr(this._sessionAttr);
                }
                catch (Exception e) {
                    this._connItemMgr.releaseItem(connItem);
                    connItem = null;
                    this._destroyConnQueue.add(sdb);
                    break;
                }
            }
            connItem.setAddr(addr);
            this._idleConnPool.insert(connItem, sdb);
            this._strategy.addConnItemAfterCreating(connItem);
        }
    }

    private boolean _connIsValid(ConnItem item, Sequoiadb sdb) {
        try {
            sdb.releaseResource();
        }
        catch (Exception e) {
            try {
                sdb.disconnect();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
        if (0 != this._dsOpt.getKeepAliveTimeout()) {
            long lastTime = sdb.getLastUseTime();
            long currentTime = System.currentTimeMillis();
            if (currentTime - lastTime + (long)this._preDeleteInterval >= (long)this._dsOpt.getKeepAliveTimeout()) {
                return false;
            }
        }
        return item.getSequenceNumber() > this._currentSequenceNumber;
    }

    private IConnectStrategy _createStrategy(ConnectStrategy strategy) {
        IConnectStrategy obj = null;
        switch (strategy) {
            case BALANCE: {
                obj = new ConcreteBalanceStrategy();
                break;
            }
            case SERIAL: {
                obj = new ConcreteSerialStrategy();
                break;
            }
            case RANDOM: {
                obj = new ConcreteRandomStrategy();
                break;
            }
            case LOCAL: {
                obj = new ConcreteLocalStrategy();
                break;
            }
        }
        return obj;
    }

    private void _enableDatasource(ConnectStrategy strategy) {
        this._preDeleteInterval = (int)((double)this._dsOpt.getCheckInterval() * this.MULTIPLE);
        this._idleConnPool = new IdleConnectionPool();
        if (this._usedConnPool == null) {
            this._usedConnPool = new UsedConnectionPool();
            this._connItemMgr = new ConnectionItemMgr(this._dsOpt.getMaxCount(), null);
        } else {
            ArrayList<ConnItem> list = new ArrayList<ConnItem>();
            Iterator<Pair> itr = this._usedConnPool.getIterator();
            while (itr.hasNext()) {
                list.add(itr.next().first());
            }
            this._connItemMgr = new ConnectionItemMgr(this._dsOpt.getMaxCount(), list);
            this._currentSequenceNumber = this._connItemMgr.getCurrentSequenceNumber();
        }
        this._strategy = this._createStrategy(strategy);
        this._strategy.init(this._normalAddrs, null, null);
        this._startTimer();
        this._startThreads();
        this._isDatasourceOn = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reduceIdleConnections(int count) {
        Sequoiadb sdb;
        ConnItem connItem = null;
        long lastTime = 0L;
        long currentTime = System.currentTimeMillis();
        while (count-- > 0 && (connItem = this._strategy.peekConnItemForDeleting()) != null && currentTime - (lastTime = (sdb = this._idleConnPool.peek(connItem)).getLastUseTime()) >= 180000L) {
            connItem = this._strategy.pollConnItemForDeleting();
            sdb = this._idleConnPool.poll(connItem);
            try {
                this._destroyConnQueue.add(sdb);
            }
            finally {
                this._connItemMgr.releaseItem(connItem);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _reduceIdleConnections_bak(int count) {
        ConnItem item;
        while (count-- > 0 && (item = this._strategy.pollConnItemForDeleting()) != null) {
            try {
                Sequoiadb sdb = this._idleConnPool.poll(item);
                this._destroyConnQueue.add(sdb);
            }
            finally {
                this._connItemMgr.releaseItem(item);
            }
        }
    }

    private String _parseHostName(String hostName) {
        InetAddress ia = null;
        try {
            ia = InetAddress.getByName(hostName);
        }
        catch (UnknownHostException e) {
            throw new BaseException(SDBError.SDB_SYS, "Failed to parse host name to ip for UnknownHostException", e);
        }
        catch (SecurityException e) {
            throw new BaseException(SDBError.SDB_SYS, "Failed to parse host name to ip for SecurityException", e);
        }
        return ia.getHostAddress();
    }

    private String _parseCoordAddr(String coordAddr) {
        String[] tmp;
        int port;
        String host;
        String retCoordAddr = null;
        if (coordAddr.indexOf(":") > 0) {
            host = "";
            port = 0;
            tmp = coordAddr.split(":");
            if (tmp.length < 2) {
                throw new BaseException(SDBError.SDB_INVALIDARG, "Point 1: invalid format coord address: " + coordAddr);
            }
            host = tmp[0].trim();
            try {
                host = InetAddress.getByName(host).toString().split("/")[1];
            }
            catch (Exception e) {
                throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
            }
        } else {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Point 2: invalid format coord address: " + coordAddr);
        }
        port = Integer.parseInt(tmp[1].trim());
        retCoordAddr = host + ":" + port;
        return retCoordAddr;
    }

    class SynchronizeAddressTask
    implements Runnable {
        SynchronizeAddressTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            block38: {
                ArrayList<String> decList;
                ArrayList<String> incList;
                ReentrantReadWriteLock.WriteLock wlock;
                block37: {
                    List<String> cachedAddrList;
                    Sequoiadb sdb;
                    Iterator<Object> itr;
                    block36: {
                        wlock = SequoiadbDatasource.this._rwLock.writeLock();
                        wlock.lock();
                        if (Thread.interrupted()) {
                            return;
                        }
                        if (SequoiadbDatasource.this._hasClosed) {
                            return;
                        }
                        if (SequoiadbDatasource.this._dsOpt.getSyncCoordInterval() == 0) {
                            return;
                        }
                        itr = SequoiadbDatasource.this._normalAddrs.iterator();
                        sdb = null;
                        while (itr.hasNext()) {
                            String addr = (String)itr.next();
                            try {
                                sdb = new Sequoiadb(addr, SequoiadbDatasource.this._username, SequoiadbDatasource.this._password, SequoiadbDatasource.this._nwOpt);
                                break;
                            }
                            catch (BaseException e) {
                            }
                        }
                        if (sdb == null) {
                            return;
                        }
                        cachedAddrList = this._synchronizeCoordAddr(sdb);
                        try {
                            sdb.disconnect();
                            break block36;
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        break block36;
                        catch (Exception e) {
                            try {
                                sdb.disconnect();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            sdb = null;
                            wlock.unlock();
                            return;
                            catch (Throwable throwable) {
                                try {
                                    sdb.disconnect();
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                sdb = null;
                                throw throwable;
                            }
                        }
                    }
                    sdb = null;
                    incList = new ArrayList<String>();
                    decList = new ArrayList<String>();
                    String addr22222222222 = null;
                    if (cachedAddrList == null || cachedAddrList.size() <= 0) break block37;
                    itr = SequoiadbDatasource.this._normalAddrs.iterator();
                    for (int i = 0; i < 2; ++i) {
                        while (itr.hasNext()) {
                            addr22222222222 = (String)itr.next();
                            if (cachedAddrList.contains(addr22222222222)) continue;
                            decList.add(addr22222222222);
                        }
                        itr = SequoiadbDatasource.this._abnormalAddrs.iterator();
                    }
                    for (String addr22222222222 : cachedAddrList) {
                        if (SequoiadbDatasource.this._normalAddrs.contains(addr22222222222) || SequoiadbDatasource.this._abnormalAddrs.contains(addr22222222222)) continue;
                        incList.add(addr22222222222);
                    }
                }
                if (incList.size() > 0) {
                    for (String addr22222222222 : incList) {
                        List list = SequoiadbDatasource.this._normalAddrs;
                        synchronized (list) {
                            if (!SequoiadbDatasource.this._normalAddrs.contains(addr22222222222)) {
                                SequoiadbDatasource.this._normalAddrs.add(addr22222222222);
                            }
                        }
                        SequoiadbDatasource.this._strategy.addAddress(addr22222222222);
                    }
                }
                if (decList.size() > 0) {
                    for (String addr22222222222 : decList) {
                        SequoiadbDatasource.this._normalAddrs.remove(addr22222222222);
                        SequoiadbDatasource.this._abnormalAddrs.remove(addr22222222222);
                        SequoiadbDatasource.this._removeAddrInStrategy(addr22222222222);
                    }
                }
                break block38;
                finally {
                    wlock.unlock();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<String> _synchronizeCoordAddr(Sequoiadb sdb) {
            ArrayList<String> addrList = new ArrayList<String>();
            BasicBSONObject condition = new BasicBSONObject();
            condition.put("GroupName", (Object)"SYSCoord");
            BasicBSONObject select = new BasicBSONObject();
            select.put("Group.HostName", (Object)"");
            select.put("Group.Service", (Object)"");
            DBCursor cursor = sdb.getList(7, condition, select, null);
            BaseException exp = new BaseException(SDBError.SDB_SYS, "Invalid coord information got from catalog");
            try {
                while (cursor.hasNext()) {
                    BSONObject obj = cursor.getNext();
                    BasicBSONList arr = (BasicBSONList)obj.get("Group");
                    if (arr == null) {
                        throw exp;
                    }
                    Object[] objArr = arr.toArray();
                    block6: for (int i = 0; i < objArr.length; ++i) {
                        BasicBSONObject subObj = (BasicBSONObject)objArr[i];
                        String hostName = (String)subObj.get("HostName");
                        if (hostName == null || hostName.trim().isEmpty()) {
                            throw exp;
                        }
                        String svcName = "";
                        BasicBSONList subArr = (BasicBSONList)subObj.get("Service");
                        if (subArr == null) {
                            throw exp;
                        }
                        Object[] subObjArr = subArr.toArray();
                        for (int j = 0; j < subObjArr.length; ++j) {
                            String ip;
                            BSONObject subSubObj = (BSONObject)subObjArr[j];
                            Integer type = (Integer)subSubObj.get("Type");
                            if (type == null) {
                                throw exp;
                            }
                            if (type != 0) continue;
                            svcName = (String)subSubObj.get("Name");
                            if (svcName == null || svcName.trim().isEmpty()) {
                                throw exp;
                            }
                            try {
                                ip = SequoiadbDatasource.this._parseHostName(hostName.trim());
                            }
                            catch (Exception e) {
                                continue block6;
                            }
                            addrList.add(ip + ":" + svcName.trim());
                            continue block6;
                        }
                    }
                }
            }
            finally {
                cursor.close();
            }
            return addrList;
        }
    }

    class RetrieveAddressTask
    implements Runnable {
        RetrieveAddressTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReentrantReadWriteLock.ReadLock rlock = SequoiadbDatasource.this._rwLock.readLock();
            rlock.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                if (SequoiadbDatasource.this._hasClosed) {
                    return;
                }
                if (SequoiadbDatasource.this._abnormalAddrs.size() == 0) {
                    return;
                }
                Iterator abnormalAddrSetItr = SequoiadbDatasource.this._abnormalAddrs.iterator();
                ConfigOptions nwOpt = new ConfigOptions();
                String addr = "";
                nwOpt.setConnectTimeout(100);
                nwOpt.setMaxAutoConnectRetryTime(0L);
                while (abnormalAddrSetItr.hasNext()) {
                    addr = (String)abnormalAddrSetItr.next();
                    try {
                        Sequoiadb sdb = new Sequoiadb(addr, SequoiadbDatasource.this._username, SequoiadbDatasource.this._password, nwOpt);
                        try {
                            sdb.disconnect();
                        }
                        catch (Exception exception) {}
                    }
                    catch (Exception e) {
                        continue;
                    }
                    abnormalAddrSetItr.remove();
                    List list = SequoiadbDatasource.this._normalAddrs;
                    synchronized (list) {
                        if (!SequoiadbDatasource.this._normalAddrs.contains(addr)) {
                            SequoiadbDatasource.this._normalAddrs.add(addr);
                        }
                    }
                    SequoiadbDatasource.this._strategy.addAddress(addr);
                }
            }
            finally {
                rlock.unlock();
            }
        }
    }

    class CheckConnectionTask
    implements Runnable {
        CheckConnectionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ReentrantReadWriteLock.WriteLock wlock = SequoiadbDatasource.this._rwLock.writeLock();
            wlock.lock();
            try {
                if (Thread.interrupted()) {
                    return;
                }
                if (SequoiadbDatasource.this._hasClosed) {
                    return;
                }
                if (!SequoiadbDatasource.this._isDatasourceOn) {
                    return;
                }
                if (SequoiadbDatasource.this._dsOpt.getKeepAliveTimeout() > 0) {
                    Sequoiadb sdb;
                    long lastTime = 0L;
                    long currentTime = System.currentTimeMillis();
                    ConnItem connItem = null;
                    while ((connItem = SequoiadbDatasource.this._strategy.peekConnItemForDeleting()) != null && currentTime - (lastTime = (sdb = SequoiadbDatasource.this._idleConnPool.peek(connItem)).getLastUseTime()) + (long)SequoiadbDatasource.this._preDeleteInterval >= (long)SequoiadbDatasource.this._dsOpt.getKeepAliveTimeout()) {
                        connItem = SequoiadbDatasource.this._strategy.pollConnItemForDeleting();
                        sdb = SequoiadbDatasource.this._idleConnPool.poll(connItem);
                        try {
                            SequoiadbDatasource.this._destroyConnQueue.add(sdb);
                        }
                        finally {
                            SequoiadbDatasource.this._connItemMgr.releaseItem(connItem);
                        }
                    }
                }
                if (SequoiadbDatasource.this._idleConnPool.count() > SequoiadbDatasource.this._dsOpt.getMaxIdleCount()) {
                    int destroyCount = SequoiadbDatasource.this._idleConnPool.count() - SequoiadbDatasource.this._dsOpt.getMaxIdleCount();
                    SequoiadbDatasource.this._reduceIdleConnections(destroyCount);
                }
            }
            finally {
                wlock.unlock();
            }
        }
    }

    class DestroyConnectionTask
    implements Runnable {
        DestroyConnectionTask() {
        }

        @Override
        public void run() {
            block8: while (true) {
                try {
                    while (!Thread.interrupted()) {
                        Sequoiadb sdb = (Sequoiadb)SequoiadbDatasource.this._destroyConnQueue.take();
                        try {
                            sdb.disconnect();
                            continue block8;
                        }
                        catch (BaseException e) {
                        }
                    }
                    break;
                }
                catch (InterruptedException e) {
                    try {
                        Sequoiadb[] arr;
                        for (Sequoiadb db : arr = (Sequoiadb[])SequoiadbDatasource.this._destroyConnQueue.toArray()) {
                            try {
                                db.disconnect();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        break;
                    }
                    catch (Exception exception) {
                        // empty catch block
                        break;
                    }
                }
            }
        }
    }

    class CreateConnectionTask
    implements Runnable {
        CreateConnectionTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!Thread.interrupted()) {
                    Object object = SequoiadbDatasource.this._createConnSignal;
                    synchronized (object) {
                        SequoiadbDatasource.this._createConnSignal.wait();
                    }
                    ReentrantReadWriteLock.ReadLock rlock = SequoiadbDatasource.this._rwLock.readLock();
                    rlock.lock();
                    try {
                        if (Thread.interrupted()) {
                            return;
                        }
                        SequoiadbDatasource.this._createConnections();
                    }
                    finally {
                        rlock.unlock();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    class ExitClearUpTask
    extends Thread {
        ExitClearUpTask() {
        }

        @Override
        public void run() {
            try {
                SequoiadbDatasource.this.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

