/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.util.Helper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import org.bson.BSONObject;
import org.bson.BasicBSONObject;

public class DeleteRequest
extends SdbRequest {
    private static final int FIXED_LENGTH = 44;
    private static final byte[] EMPTY_BSON_BYTES = Helper.encodeBSONObj(new BasicBSONObject());
    private static final int ALIGNED_EMPTY_BSON_LENGTH = Helper.alignedSize(EMPTY_BSON_BYTES.length);
    private static final int version = 1;
    private static final short w = 0;
    private static final short padding = 0;
    private static int flag = 0;
    private String collectionName;
    private byte[] matcherBytes;
    private byte[] hintBytes;

    public DeleteRequest(String collectionName, BSONObject matcher, BSONObject hint) {
        this.opCode = 2006;
        this.length = 44;
        if (collectionName == null || collectionName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Collection name is null or empty");
        }
        this.collectionName = collectionName;
        this.length += Helper.alignedSize(collectionName.length() + 1);
        if (matcher == null) {
            this.matcherBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.matcherBytes = Helper.encodeBSONObj(matcher);
            this.length += Helper.alignedSize(this.matcherBytes.length);
        }
        if (hint == null) {
            this.hintBytes = (byte[])EMPTY_BSON_BYTES.clone();
            this.length += ALIGNED_EMPTY_BSON_LENGTH;
        } else {
            this.hintBytes = Helper.encodeBSONObj(hint);
            this.length += Helper.alignedSize(this.hintBytes.length);
        }
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.putInt(1);
        out.putShort((short)0);
        out.putShort((short)0);
        out.putInt(flag);
        out.putInt(this.collectionName.length());
        try {
            out.put(this.collectionName.getBytes("UTF-8"));
            out.put((byte)0);
            int length = this.collectionName.length() + 1;
            int paddingLen = Helper.alignedSize(length) - length;
            if (paddingLen > 0) {
                out.put(new byte[paddingLen]);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        DeleteRequest.encodeBSONBytes(this.matcherBytes, out);
        DeleteRequest.encodeBSONBytes(this.hintBytes, out);
    }
}

