/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import com.sequoiadb.util.Helper;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.bson.BSONObject;
import org.bson.types.ObjectId;

public class InsertRequest
extends SdbRequest {
    private static final String OID = "_id";
    private static final int FIXED_LENGTH = 44;
    private static final int version = 1;
    private static final short w = 0;
    private static final short padding = 0;
    private int flag = 0;
    private String collectionName;
    private List<byte[]> docsBytes;

    private InsertRequest(String collectionName) {
        this.opCode = 2002;
        this.length = 44;
        if (collectionName == null || collectionName.length() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "Collection name is null or empty");
        }
        this.collectionName = collectionName;
        this.length += Helper.alignedSize(collectionName.length() + 1);
    }

    public InsertRequest(String collectionName, BSONObject doc) {
        this(collectionName);
        if (doc == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "doc is null");
        }
        this.docsBytes = new ArrayList<byte[]>(1);
        byte[] docBytes = Helper.encodeBSONObj(doc);
        this.docsBytes.add(docBytes);
        this.length += Helper.alignedSize(docBytes.length);
    }

    public InsertRequest(String collectionName, List<BSONObject> docs, int flag, boolean ensureOID) {
        this(collectionName);
        this.flag = flag;
        if (docs == null || docs.size() == 0) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "docs is null or empty");
        }
        this.docsBytes = new ArrayList<byte[]>(docs.size());
        for (BSONObject doc : docs) {
            if (ensureOID && !doc.containsField(OID)) {
                doc.put(OID, ObjectId.get());
            }
            byte[] docBytes = Helper.encodeBSONObj(doc);
            this.docsBytes.add(docBytes);
            this.length += Helper.alignedSize(docBytes.length);
        }
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.putInt(1);
        out.putShort((short)0);
        out.putShort((short)0);
        out.putInt(this.flag);
        out.putInt(this.collectionName.length());
        try {
            out.put(this.collectionName.getBytes("UTF-8"));
            out.put((byte)0);
            int length = this.collectionName.length() + 1;
            int paddingLen = Helper.alignedSize(length) - length;
            if (paddingLen > 0) {
                out.put(new byte[paddingLen]);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new BaseException(SDBError.SDB_INVALIDARG, (Throwable)e);
        }
        for (byte[] docBytes : this.docsBytes) {
            InsertRequest.encodeBSONBytes(docBytes, out);
        }
    }
}

