/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.SdbRequest;
import java.nio.ByteBuffer;

public class KillContextRequest
extends SdbRequest {
    private static final int FIXED_LENGTH = 36;
    private static final int reserved = 0;
    private long[] contextIds;

    public KillContextRequest(long[] contextIds) {
        this.opCode = 2007;
        this.length = 36;
        if (contextIds == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "contextIds is null");
        }
        this.contextIds = contextIds;
        this.length += contextIds.length * 8;
    }

    @Override
    protected void encodeBody(ByteBuffer out) {
        out.putInt(0);
        out.putInt(this.contextIds.length);
        for (long contextId : this.contextIds) {
            out.putLong(contextId);
        }
    }
}

