/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.message.request.LobRequest;
import com.sequoiadb.util.Helper;
import java.nio.ByteBuffer;
import org.bson.BasicBSONObject;

public class LobLockRequest
extends LobRequest {
    private static final String FIELD_NAME_OFFSET = "Offset";
    private static final String FIELD_NAME_LENGTH = "Length";
    private byte[] bsonBytes;

    public LobLockRequest(long contextId, long offset, long length) {
        this.opCode = 8007;
        this.contextId = contextId;
        BasicBSONObject obj = new BasicBSONObject();
        obj.put(FIELD_NAME_OFFSET, (Object)offset);
        obj.put(FIELD_NAME_LENGTH, (Object)length);
        this.bsonBytes = Helper.encodeBSONObj(obj);
        this.bsonLength = this.bsonBytes.length;
        this.length += Helper.alignedSize(this.bsonBytes.length);
    }

    @Override
    protected void encodeLobBody(ByteBuffer out) {
        LobLockRequest.encodeBSONBytes(this.bsonBytes, out);
    }
}

