/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.LobRequest;
import com.sequoiadb.util.Helper;
import java.nio.ByteBuffer;
import org.bson.BSONObject;

public class LobOpenRequest
extends LobRequest {
    private byte[] bsonBytes;

    public LobOpenRequest(BSONObject obj, int flag) {
        this.opCode = 8001;
        if (obj == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "obj is null");
        }
        this.bsonBytes = Helper.encodeBSONObj(obj);
        this.bsonLength = this.bsonBytes.length;
        this.length += Helper.alignedSize(this.bsonBytes.length);
        this.flag = flag;
    }

    @Override
    protected void encodeLobBody(ByteBuffer out) {
        LobOpenRequest.encodeBSONBytes(this.bsonBytes, out);
    }
}

