/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.LobRequest;
import com.sequoiadb.util.Helper;
import java.nio.ByteBuffer;
import org.bson.BSONObject;

public class LobTruncateRequest
extends LobRequest {
    private byte[] bsonBytes;

    public LobTruncateRequest(BSONObject obj) {
        this.opCode = 8008;
        if (obj == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "obj is null");
        }
        this.bsonBytes = Helper.encodeBSONObj(obj);
        this.bsonLength = this.bsonBytes.length;
        this.length += Helper.alignedSize(this.bsonBytes.length);
    }

    @Override
    protected void encodeLobBody(ByteBuffer out) {
        LobTruncateRequest.encodeBSONBytes(this.bsonBytes, out);
    }
}

