/*
 * Decompiled with CFR 0.152.
 */
package com.sequoiadb.message.request;

import com.sequoiadb.exception.BaseException;
import com.sequoiadb.exception.SDBError;
import com.sequoiadb.message.request.LobRequest;
import com.sequoiadb.util.Helper;
import java.nio.ByteBuffer;

public class LobWriteRequest
extends LobRequest {
    private static final int FIXED_LENGTH = 68;
    private int bufLen;
    private static final int sequence = 0;
    private long offset;
    private ByteBuffer buffer;

    public LobWriteRequest(long contextId, byte[] buf, int off, int len, long lobOffset) {
        this.opCode = 8002;
        this.length = 68;
        if (buf == null) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "obj is null");
        }
        if (off + len > buf.length) {
            throw new BaseException(SDBError.SDB_INVALIDARG, "off + len is more than buf.length");
        }
        this.contextId = contextId;
        this.bufLen = len;
        this.buffer = ByteBuffer.wrap(buf, off, len);
        this.length += Helper.alignedSize(len);
        this.offset = lobOffset;
    }

    @Override
    protected void encodeLobBody(ByteBuffer out) {
        out.putInt(this.bufLen);
        out.putInt(0);
        out.putLong(this.offset);
        out.put(this.buffer);
        int paddingSize = Helper.alignedSize(this.bufLen) - this.bufLen;
        if (paddingSize > 0) {
            out.put(new byte[paddingSize]);
        }
    }
}

